/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib.multijvm.group.wrapper;

import com.sun.javatest.JavaTestSecurityManager;
import com.sun.javatest.Status;
import com.sun.javatest.agent.Agent;
import com.sun.javatest.agent.Connection;
import com.sun.jck.lib.multijvm.group.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledFuture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wrapper
implements Agent.Observer,
Closeable,
Util.ArgHandler {
    protected Agent agent;
    protected List<String> agentArgs = Collections.EMPTY_LIST;
    protected int testTimeout = 600000;
    protected int idleTimeout = 60000;
    protected int activePort = -1;
    protected String activeHost = null;
    protected String id;
    protected ScheduledFuture onIdleFuture;
    protected ScheduledFuture onTestFuture;
    protected boolean debug = false;

    public String[] generateAgentArgs() throws IOException {
        return Util.join({"-active", "-activeHost", this.activeHost, "-activePort", String.valueOf(this.activePort)}, this.agentArgs.toArray(new String[0]));
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
        agent.addObserver(this);
    }

    public void init() {
        if (this.activeHost == null) {
            throw new IllegalArgumentException("activeHost is not specified");
        }
        if (this.activePort == -1) {
            throw new IllegalArgumentException("activePort is not specified");
        }
        if (this.id == null) {
            throw new IllegalArgumentException("id is not specified");
        }
    }

    private synchronized void scheduleCloseOnIdle() {
        Util.cancelClose(this.onTestFuture);
        if (this.onIdleFuture == null || this.onIdleFuture.isCancelled()) {
            this.onIdleFuture = Util.scheduleClose(this, this.idleTimeout);
        }
    }

    private synchronized void scheduleCloseOnTest() {
        Util.cancelClose(this.onIdleFuture);
        this.onTestFuture = Util.scheduleClose(this, this.testTimeout);
    }

    @Override
    public void started(Agent agent) {
        this.scheduleCloseOnIdle();
    }

    @Override
    public void errorOpeningConnection(Agent agent, Exception exception) {
        this.scheduleCloseOnIdle();
    }

    @Override
    public void finished(Agent agent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openedConnection(Agent agent, Connection connection) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(connection.getOutputStream()));
            dataOutputStream.writeUTF(this.id);
            dataOutputStream.flush();
            Util.cancelClose(this.onIdleFuture);
            this.scheduleCloseOnIdle();
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(connection.getInputStream()));
            String string = dataInputStream.readUTF();
            Util.cancelClose(this.onIdleFuture);
            dataOutputStream.writeUTF(string);
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
        }
        finally {
            this.scheduleCloseOnIdle();
        }
    }

    @Override
    public void execTest(Agent agent, Connection connection, String string, String string2, String[] stringArray) {
    }

    @Override
    public void execCommand(Agent agent, Connection connection, String string, String string2, String[] stringArray) {
        this.scheduleCloseOnTest();
    }

    @Override
    public void execMain(Agent agent, Connection connection, String string, String string2, String[] stringArray) {
    }

    @Override
    public void result(Agent agent, Connection connection, Status status) {
        this.scheduleCloseOnIdle();
    }

    @Override
    public void exception(Agent agent, Connection connection, Throwable throwable) {
        this.scheduleCloseOnIdle();
    }

    @Override
    public void completed(Agent agent, Connection connection) {
        this.scheduleCloseOnIdle();
    }

    public void log(String string) {
        if (this.debug) {
            Util.printLog(this, string);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.log("agent closed internally (timeout?)");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager instanceof JavaTestSecurityManager) {
            ((JavaTestSecurityManager)securityManager).setAllowExit(true);
        }
        System.exit(0);
    }

    @Override
    public int decodeArg(List<String> list, int n) {
        if ("-idleTimeout".equals(list.get(n))) {
            this.idleTimeout = Integer.parseInt(list.get(++n));
            return 2;
        }
        if ("-testTimeout".equals(list.get(n))) {
            this.testTimeout = Integer.parseInt(list.get(++n));
            return 2;
        }
        if ("-host".equals(list.get(n))) {
            this.activeHost = list.get(++n);
            return 2;
        }
        if ("-port".equals(list.get(n))) {
            this.activePort = Integer.parseInt(list.get(++n));
            return 2;
        }
        if ("-id".equals(list.get(n))) {
            this.id = list.get(++n);
            return 2;
        }
        if ("-debug".equals(list.get(n))) {
            this.debug = true;
            return 1;
        }
        if ("-agentArgs".equals(list.get(n))) {
            this.agentArgs = list.subList(n + 1, list.size());
            return this.agentArgs.size() + 1;
        }
        return 0;
    }

    public String toString() {
        return "AgentWrapper(id=" + this.id + ",port=" + this.activePort + ")";
    }
}

