/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.jck.lib.MultiInstanceTool;
import com.sun.jck.lib.SchemaCompilerTool;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;

public class SchemaCompiler
extends MultiInstanceTool
implements SchemaCompilerTool {
    private final int FAILED = -1;
    private final String[] xjcClassNames = new String[]{"com.sun.tools.xjc.Driver", "com.sun.tools.internal.xjc.Driver"};

    public int compile(String[] stringArray, String string, File file, String[] stringArray2, PrintStream printStream, PrintStream printStream2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (stringArray2 != null) {
            linkedList.addAll(Arrays.asList(stringArray2));
        }
        linkedList.add("-d");
        linkedList.add(file.getAbsolutePath());
        linkedList.add("-p");
        linkedList.add(string);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                linkedList.add(string2);
            }
        }
        try {
            Class<?> clazz = this.getToolClass(this.xjcClassNames);
            Method method = clazz.getMethod("run", String[].class, PrintStream.class, PrintStream.class);
            Object object = method.invoke(clazz.newInstance(), linkedList.toArray(new String[linkedList.size()]), printStream, printStream2);
            if (object instanceof Integer) {
                int n = (Integer)object;
                if (n == 0) {
                    this.touch(file, string);
                }
                return n;
            }
            throw new Exception("Unexpected return value was expected: " + object.toString());
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            printStream2.println("Schema compiler failed " + (string3 != null ? "with the message '" + string3 + "'" : ""));
            exception.printStackTrace(printStream2);
            return -1;
        }
    }

    private void touch(File file, String string) {
        String string2 = string.replace(".", File.separator);
        File file2 = new File(file, string2);
        file2 = new File(file2, "ObjectFactory.java");
        file2.setLastModified(System.currentTimeMillis() - 1000L);
    }
}

