/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.util.StringArray;
import com.sun.jck.lib.Arguments;
import com.sun.jck.lib.Counter;
import com.sun.jck.lib.IntermediateScript;
import com.sun.jck.lib.Invoker;
import com.sun.jck.lib.WSGenInvoker;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbTckScript
extends IntermediateScript {
    protected final boolean debug = false;
    public static final String SCHEMA_NAME = "schemaName";
    public static final String KWD_SCHEMA = "schema";
    public static final String KWD_DOCUMENT = "document";
    public static final String KWD_NEGATIVE = "negative";
    public static final String KWD_POSITIVE = "positive";
    public static final String KWD_RUNTIME = "runtime";
    public static final String KWD_JAXB_NOT_REQUIRED = "jaxb_not_required";
    public static final String KWD_SCHEMAGEN_REQUIRED = "java_to_schema";
    public static final String KWD_RTGEN = "rtgen";
    public static final String KWD_JAXWS = "jaxws";
    public static final String KWD_EMPTY_OUT = "empty_output";
    public static final String KWD_NOT_STRICT_VALIDATION = "not_strict_validation";
    public static final String KWD_ONLY_ONCE = "only_once";
    public static final String SCHEMA_SEPARATOR = ";";
    private static final int INVOCATION_LIMIT = 50;
    private static volatile Counter counter = new Counter();
    protected static String testSuiteRootDir;
    protected String outDir = "";
    protected ArrayList<String> schemaSrcList = new ArrayList();
    protected String schemaSources = null;
    protected String pkg = "";
    protected boolean isSchema;
    protected boolean isDocument;
    protected boolean isNegative;
    protected boolean isPositive;
    protected boolean isRuntime;
    protected boolean isJaxbNotRequired;
    protected boolean defaultOperationMode;
    protected boolean isSchemaGenRequired;
    protected boolean isJava2WSDL;
    protected boolean isWSDL2Java;
    protected boolean isSameJVM;
    protected boolean isMultiJVMGroup;
    protected boolean isEmptyOut;
    protected boolean isNotStrictValidation;
    protected boolean isRtgen;
    protected boolean isOnlyOnce;
    protected String schemaName = "";
    static final Map<String, Status[]> schemaCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status run(String[] stringArray, TestDescription testDescription, TestEnvironment testEnvironment) {
        counter.inc();
        try {
            Object object;
            if (testSuiteRootDir == null) {
                try {
                    testSuiteRootDir = testEnvironment.lookup("testSuiteRootDir")[0];
                }
                catch (TestEnvironment.Fault fault) {
                    fault.printStackTrace();
                    Status status = Status.error(fault.getMessage());
                    this.clearVariables();
                    this.finish(stringArray, testDescription, testEnvironment);
                    return status;
                }
            }
            this.start(stringArray, testDescription, testEnvironment);
            this.initTestRun(testDescription, testEnvironment);
            if (this.isJaxbNotRequired && !this.defaultOperationMode) {
                Status status = Status.passed("Test requires the default operation mode.");
                return status;
            }
            Status status = error_noActionSpecified;
            this.initMacroOutDirValue();
            if (!(!this.isSchemaGenRequired || (status = this.generate()).isPassed() && this.isDefaultMappingJ2Stest(testDescription))) {
                Status status2 = status;
                return status2;
            }
            if (this.isJava2WSDL) {
                Status status3 = this.generateWSDL();
                return status3;
            }
            if (this.isWSDL2Java) {
                Status status4 = this.compileWSDL();
                return status4;
            }
            if (this.needCompileStage()) {
                this.initMacroCompileValues();
                status = this.compile();
                if (!status.isPassed()) {
                    Status status5 = status;
                    return status5;
                }
                if (this.isEmptyOut) {
                    if (this.getGeneratedSources(".java") == null) {
                        Status status6 = Status.passed("No java sources were generated as expected");
                        return status6;
                    }
                    Status status7 = Status.failed("Unexpected java sources were generated");
                    return status7;
                }
            }
            if (this.needExecuteStage()) {
                String string;
                object = this.getFileSeparator("java");
                if (!File.separator.equals(object)) {
                    this.changeFileSeparatorInMacroTestURL((String)object);
                }
                if (!File.pathSeparator.equals(string = this.getPathSeparator("java"))) {
                    this.changePathSeparatorInMacroJaxbClasses(string);
                }
                status = this.execute();
            }
            object = status;
            return object;
        }
        catch (InitializationException initializationException) {
            Status status = Status.error(initializationException.getMessage());
            return status;
        }
        finally {
            this.clearVariables();
            this.finish(stringArray, testDescription, testEnvironment);
        }
    }

    protected String getFileSeparator(String string) {
        try {
            return this.env.lookup(string + "_map_file_separator")[0];
        }
        catch (Exception exception) {
            return File.separator;
        }
    }

    protected String getPathSeparator(String string) {
        try {
            return this.env.lookup(string + "_map_path_separator")[0];
        }
        catch (Exception exception) {
            return File.pathSeparator;
        }
    }

    protected void changeFileSeparatorInMacroTestURL(String string) {
        String string2 = "file://" + (testSuiteRootDir.startsWith("/") ? "" : "/") + testSuiteRootDir + string + "tests" + string + this.td.getRootRelativePath().replace('/', string.charAt(0));
        this.env.put("testURL", string2);
    }

    protected void changePathSeparatorInMacroJaxbClasses(String string) {
        try {
            String string2 = this.env.lookup("jaxbClasses")[0];
            string2 = string2.replace(File.pathSeparatorChar, string.charAt(0));
            this.env.put("jaxbClasses", string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void initMacroCompileValues() {
        String string = this.getFileSeparator("xjc");
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.schemaSrcList) {
            String string3 = testSuiteRootDir + string + "tests" + string + (string.equals(File.separator) ? string2 : string2.replace(File.separatorChar, string.charAt(0)));
            if (this.isSameJVM || this.isMultiJVMGroup) {
                stringBuilder.append((stringBuilder.length() > 0 ? "\u0085" : "") + string3);
                continue;
            }
            arrayList.add(string3);
        }
        if (this.isSameJVM || this.isMultiJVMGroup) {
            this.env.put(KWD_SCHEMA, stringBuilder.toString());
        } else {
            this.env.put(KWD_SCHEMA, arrayList.toArray(new String[arrayList.size()]));
        }
        if (this.isEmptyOut) {
            this.env.put("empty_output_placeholder", "-empty_output");
        }
        if (this.isNotStrictValidation) {
            this.env.put("strict_validation_placeholder", "-nv");
        }
    }

    protected void initMacroOutDirValue() {
        String string = this.workDir.getFile(this.outDir).getAbsolutePath();
        this.env.put("outDir", string);
    }

    protected void clearVariables() {
        this.outDir = "";
        this.schemaSrcList = new ArrayList();
        this.pkg = "";
        this.isSchema = false;
        this.isDocument = false;
        this.isNegative = false;
        this.isPositive = false;
        this.isRuntime = false;
        this.isJaxbNotRequired = false;
        this.defaultOperationMode = false;
        this.isSchemaGenRequired = false;
        this.isEmptyOut = false;
        this.isNotStrictValidation = false;
        if (counter.getValue() >= 50) {
            counter.reset();
            System.runFinalization();
            System.gc();
        }
    }

    protected void initTestRun(TestDescription testDescription, TestEnvironment testEnvironment) throws InitializationException {
        String string;
        this.initKeywords(testDescription);
        if (!testEnvironment.equals(this.env)) {
            this.initTestEnvironment(testEnvironment);
        }
        if (!testDescription.equals(this.td)) {
            this.initTestDescription(testDescription);
        }
        try {
            if (testSuiteRootDir == null) {
                testSuiteRootDir = testEnvironment.lookup("testSuiteRootDir")[0];
            }
        }
        catch (Exception exception) {
            throw new InitializationException(exception.toString());
        }
        try {
            string = testEnvironment.lookup("xjc_default_operation_mode")[0];
            this.defaultOperationMode = "true".equals(string);
        }
        catch (Exception exception) {
            this.defaultOperationMode = false;
        }
        this.isSameJVM = false;
        try {
            string = testEnvironment.lookup("platform.multiJVM")[0];
            this.isSameJVM = !"true".equals(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isMultiJVMGroup = false;
        try {
            string = testEnvironment.lookup("platform.groupMode")[0];
            this.isMultiJVMGroup = "true".equals(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.isSchemaGenRequired) {
            this.initTestPackage();
            this.initSchema();
        }
        this.initOutputDir();
    }

    protected void initKeywords(TestDescription testDescription) {
        Set set = testDescription.getKeywordTable();
        this.isSchema = set.contains(KWD_SCHEMA);
        this.isDocument = set.contains(KWD_DOCUMENT);
        this.isNegative = set.contains(KWD_NEGATIVE);
        this.isPositive = set.contains(KWD_POSITIVE);
        this.isRuntime = set.contains(KWD_RUNTIME);
        this.isJaxbNotRequired = set.contains(KWD_JAXB_NOT_REQUIRED);
        this.isSchemaGenRequired = set.contains(KWD_SCHEMAGEN_REQUIRED);
        this.isRtgen = set.contains(KWD_RTGEN);
        this.isEmptyOut = set.contains(KWD_EMPTY_OUT);
        this.isNotStrictValidation = set.contains(KWD_NOT_STRICT_VALIDATION);
        this.isJava2WSDL = set.contains(KWD_JAXWS) && this.isRuntime;
        this.isWSDL2Java = set.contains(KWD_JAXWS) && !this.isRuntime;
        this.isOnlyOnce = set.contains(KWD_ONLY_ONCE);
    }

    protected void initOutputDir() throws InitializationException {
        Object object;
        this.outDir = this.isSchemaGenRequired ? this.createOutputDirName4Jxc() : this.createOutputDirName4Xjc();
        if (this.outDir.length() == 0) {
            return;
        }
        if (this.needPersonalDir() && (object = this.td.getName()) != null) {
            if (!this.outDir.endsWith(File.separator)) {
                this.outDir = this.outDir + File.separator;
            }
            this.outDir = this.outDir + (String)object;
        }
        if (!this.mkdirs((File)(object = this.workDir.getFile(this.outDir)))) {
            throw new InitializationException("Can't create the directory: " + ((File)object).getAbsolutePath());
        }
    }

    protected String createOutputDirName4Jxc() {
        return "schemas" + File.separator + this.getRelativePath();
    }

    protected String createOutputDirName4Xjc() {
        String string = "javasoft.sqe.tests.";
        int n = this.pkg.indexOf(string);
        if (n == -1 || this.pkg.length() == string.length()) {
            return this.pkg.replace('.', File.separatorChar);
        }
        String string2 = this.pkg.substring(n + string.length());
        string2 = this.deleteCharFromStr('_', string2);
        string2 = "classes" + File.separator + string2.toLowerCase().replace('.', File.separatorChar);
        return string2;
    }

    private String deleteCharFromStr(char c, String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < stringBuilder.length(); ++i) {
            if (stringBuilder.charAt(i) != c) continue;
            stringBuilder.deleteCharAt(i--);
        }
        return stringBuilder.toString();
    }

    protected boolean needPersonalDir() {
        return this.isSchemaGenRequired || this.isRtgen;
    }

    protected void initTestPackage() {
        String string = this.td.getParameter("package");
        if (string == null || string.length() == 0) {
            string = this.getDefaultPackage();
        }
        this.pkg = string;
        this.env.put("package", string);
    }

    private String getDefaultPackage() {
        String string = this.getRelativePath().replaceAll("_", ".").replaceAll(Pattern.quote(".." + File.separator), "");
        return string.replaceAll(Pattern.quote(File.separator), ".").toLowerCase();
    }

    private String getRelativePath() {
        String string = this.td.getDir().getAbsolutePath();
        String string2 = File.separator + "tests" + File.separator;
        int n = string.indexOf(testSuiteRootDir);
        n = string.indexOf(File.separator, testSuiteRootDir.length() + string2.length() + n);
        string = string.substring(n + 1);
        return string;
    }

    protected void initSchema() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.td.getParameter(SCHEMA_NAME);
        if (string == null) {
            return;
        }
        for (String string2 : StringArray.split(string)) {
            arrayList.add(string2);
        }
        this.schemaName = this.arrayListAsString(arrayList);
        ArrayList arrayList2 = new ArrayList();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : arrayList) {
            String string3 = this.td.getRootRelativeFile().getParent() + File.separator + string2;
            this.schemaSrcList.add(string3);
            string3 = testSuiteRootDir + File.separator + "tests" + File.separator + string3;
            if (this.isSameJVM || this.isMultiJVMGroup) {
                stringBuilder.append((stringBuilder.length() > 0 ? "\u0085" : "") + string3);
                continue;
            }
            arrayList2.add(string3);
        }
        if (this.isSameJVM || this.isMultiJVMGroup) {
            this.env.put(KWD_SCHEMA, stringBuilder.toString());
        } else {
            this.env.put(KWD_SCHEMA, arrayList2.toArray(new String[arrayList2.size()]));
        }
    }

    protected boolean needCompileStage() {
        return this.isSchema || this.isDocument;
    }

    protected boolean needExecuteStage() {
        return !this.isSchema || !this.isNegative && !this.isEmptyOut || this.isRtgen;
    }

    protected boolean isDefaultMappingJ2Stest(TestDescription testDescription) {
        return testDescription.getParameter("testSource") != null;
    }

    protected Status generate() {
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder2 = new StringBuilder();
        String string = this.td.getParameter("executeArgs");
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
        while (stringTokenizer.hasMoreElements()) {
            object2 = stringTokenizer.nextToken();
            if ("-j".equals(object2) && stringTokenizer.hasMoreElements()) {
                object2 = stringTokenizer.nextToken();
                object = this.td.getDir();
                StringTokenizer stringTokenizer2 = new StringTokenizer((String)object2, ":", false);
                while (stringTokenizer2.hasMoreElements()) {
                    String string2 = stringTokenizer2.nextToken();
                    File file = new File((File)object, string2);
                    if (this.isSameJVM || this.isMultiJVMGroup) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append('\u0085');
                        }
                        stringBuilder.append(file.getAbsolutePath());
                        continue;
                    }
                    arrayList.add(file.getAbsolutePath());
                }
                continue;
            }
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(' ');
            }
            stringBuilder2.append((String)object2);
        }
        if (this.isSameJVM || this.isMultiJVMGroup) {
            this.env.put("java_source_files", stringBuilder.toString());
        } else {
            this.env.put("java_source_files", arrayList.toArray(new String[arrayList.size()]));
        }
        object2 = super.invokeCommand(this.adjustForGroupMode("schemagen.jxc"));
        if (this.isNegative) {
            return ((Status)object2).isPassed() ? fail_compSuccUnexp : pass_compFailExp;
        }
        if (((Status)object2).isPassed()) {
            this.schemaSources = this.getGeneratedSources(".xsd");
            if (this.isEmptyOut) {
                object2 = this.schemaSources == null ? Status.passed("No schemas were generated as expected") : Status.failed("Unexpected schemas were generated");
            } else if (this.schemaSources == null) {
                object2 = Status.failed("No schemas were generated");
            } else {
                stringBuilder2.append(" -schemas ").append(JaxbTckScript.adjustForSpace(this.schemaSources));
                object = this.td.getParameter("executeClass");
                object2 = super.execute(this.adjustForGroupMode("execute"), (String)object, stringBuilder2.toString());
            }
        }
        return object2;
    }

    protected Status compileSchema() {
        Status status = super.invokeCommand(this.adjustForGroupMode("compile.xsd"));
        if (this.isSchema && this.isNegative) {
            switch (status.getType()) {
                case 0: {
                    status = fail_compSuccUnexp;
                    break;
                }
                case 1: {
                    status = pass_compFailExp;
                    break;
                }
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Status compile() {
        if (this.isSchema && (this.isNegative || this.isEmptyOut)) {
            return this.compileSchema();
        }
        Status[] statusArray = schemaCache;
        synchronized (schemaCache) {
            Status[] statusArray2 = schemaCache.get(this.arrayListAsString(this.schemaSrcList));
            if (statusArray2 == null) {
                statusArray2 = new Status[1];
                if (!this.isScriptGenMode()) {
                    schemaCache.put(this.arrayListAsString(this.schemaSrcList), statusArray2);
                }
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            statusArray = statusArray2;
            synchronized (statusArray2) {
                if (statusArray2[0] != null) {
                    this.trOut.println("Using compiled schema(s):");
                    for (String string : this.schemaSrcList) {
                        this.trOut.println(string);
                    }
                } else {
                    statusArray2[0] = this.compileSchema();
                }
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return statusArray2[0];
            }
        }
    }

    protected Status execute() {
        Object object;
        String string = this.td.getParameter("executeArgs");
        if (this.isDocument && !this.isRuntime) {
            string = string + " -schema " + this.schemaName;
        } else if (this.isRtgen) {
            this.env.put("testWorkDir", JaxbTckScript.adjustForSpace(this.workDir.getFile(this.outDir).getAbsolutePath()));
        }
        if (!this.defaultOperationMode && this.isSchema && this.isPositive) {
            string = string + " -EnableSuperSet";
        }
        if (this.isSchemaGenRequired) {
            this.schemaSources = this.getGeneratedSources(".xsd");
            if (this.schemaSources != null) {
                string = string + " -schemas " + JaxbTckScript.adjustForSpace(this.schemaSources);
                object = new StringTokenizer(string, " ", false);
                StringBuilder stringBuilder = new StringBuilder();
                while (((StringTokenizer)object).hasMoreElements()) {
                    String string2 = ((StringTokenizer)object).nextToken();
                    if ("-j".equals(string2) && ((StringTokenizer)object).hasMoreElements()) {
                        ((StringTokenizer)object).nextToken();
                        continue;
                    }
                    stringBuilder.append(" " + string2);
                }
                string = "";
                if (stringBuilder.length() > 0) {
                    string = stringBuilder.toString().substring(1);
                }
            }
        }
        object = this.td.getParameter("executeClass");
        return super.execute(this.adjustForGroupMode("execute"), (String)object, string);
    }

    private String getGeneratedSources(String string) {
        File file = this.workDir.getFile(this.outDir);
        if (this.isScriptGenMode()) {
            if (this.isEmptyOut) {
                return null;
            }
            return super.filesInDir(file, string, SCHEMA_SEPARATOR, this.isEmptyOut);
        }
        Arguments arguments = new Arguments();
        arguments.addFileNames(file, string);
        if (arguments.size() != 0) {
            return arguments.getArgsAsString(SCHEMA_SEPARATOR);
        }
        return null;
    }

    protected Status generateWSDL() {
        Object object;
        String string;
        String string2 = this.td.getParameter("executeArgs");
        String[] stringArray = string2.split(" - ");
        if (stringArray.length != 2) {
            return Status.failed("Cannot parse execute arguments: " + string2);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringArray[0], " ", false);
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (!"-sei".equals(string)) continue;
            string3 = stringTokenizer.nextToken();
            break;
        }
        string = this.workDir.getFile(this.outDir).getAbsolutePath();
        this.env.put("wsdlLocation", string);
        StringBuilder stringBuilder = new StringBuilder(stringArray[1]);
        stringBuilder.append(" -wsdlLocation ").append(JaxbTckScript.adjustForSpace(string));
        Status status = Status.error("wsgen task has not been started.");
        if (this.isSameJVM || this.isMultiJVMGroup) {
            this.env.put("wsgenArgs", string3);
            status = super.invokeCommand(this.adjustForGroupMode("wsgen"));
        } else {
            object = null;
            try {
                object = WSGenInvoker.getSeiList(string3);
            }
            catch (Invoker.ArgumentException argumentException) {
                return Status.error(argumentException.getMessage());
            }
            Iterator<String> iterator = object.iterator();
            while (iterator.hasNext()) {
                String string4 = iterator.next();
                this.env.put("wsgenArgs", string4);
                status = super.invokeCommand(this.adjustForGroupMode("wsgen"));
                if (status.isPassed()) continue;
                break;
            }
        }
        if (this.isNegative) {
            if (status.isPassed()) {
                return fail_compSuccUnexp;
            }
            return pass_compFailExp;
        }
        if (status.isPassed()) {
            object = this.td.getParameter("executeClass");
            status = super.execute(this.adjustForGroupMode("execute"), (String)object, stringBuilder.toString());
        }
        return status;
    }

    protected Status compileWSDL() {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        String string = "-b";
        File file = this.td.getDir();
        String[] stringArray2 = this.td.getSources();
        for (int i = 0; i < stringArray2.length; ++i) {
            object = new File(file, stringArray2[i]);
            if (stringArray2[i].endsWith(".xml")) {
                if (!this.isSameJVM && !this.isMultiJVMGroup) {
                    arrayList2.add(string);
                }
                String string2 = ((File)object).toURI().toString();
                arrayList2.add(string2);
                continue;
            }
            if (stringArray2[i].endsWith(".wsdl")) {
                String string3 = ((File)object).toURI().toString();
                arrayList.add(string3);
                continue;
            }
            if (!stringArray2[i].endsWith(".java")) continue;
            arrayList3.add(((File)object).getAbsolutePath());
        }
        if (this.isSameJVM || this.isMultiJVMGroup) {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string4 : arrayList2) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append('\u0085');
                }
                stringBuffer.append(string4);
            }
            this.env.put("xml_files", stringBuffer.toString());
            stringBuffer.delete(0, stringBuffer.length());
            for (String string5 : arrayList) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append('\u0085');
                }
                stringBuffer.append(string5);
            }
            this.env.put("wsdl_files", stringBuffer.toString());
        } else {
            this.env.put("xml_files", arrayList2.toArray(new String[arrayList2.size()]));
            this.env.put("wsdl_files", arrayList.toArray(new String[arrayList.size()]));
        }
        String string2 = this.workDir.getFile(this.outDir).getAbsolutePath();
        this.env.put("wsdlLocation", string2);
        object = super.invokeCommand(this.adjustForGroupMode("wsimport"));
        if (this.isNegative) {
            if (((Status)object).isPassed()) {
                return fail_compSuccUnexp;
            }
            return pass_compFailExp;
        }
        if (((Status)object).isPassed()) {
            this.env.put("testClassDir", string2);
            String[] stringArray = arrayList3.toArray(new String[arrayList3.size()]);
            object = this.isGroupMode("compile") ? this.compileTogether("compile.group", stringArray) : this.compileTogether(stringArray);
            if (((Status)object).isPassed()) {
                String string6 = this.td.getParameter("executeClass");
                object = super.execute(this.adjustForGroupMode("execute"), string6, this.td.getParameter("executeArgs"));
            }
        }
        return object;
    }

    static String adjustForSpace(String string) {
        if (string != null && string.indexOf(" ") > 0) {
            return "'" + string + "'";
        }
        return string;
    }

    private String arrayListAsString(ArrayList<String> arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return "";
        }
        return StringArray.join(arrayList.toArray(new String[arrayList.size()]));
    }

    protected boolean isGroupMode(String string) {
        try {
            if (this.isOnlyOnce) {
                return false;
            }
            String[] stringArray = this.env.lookup(string + ".isGroupMode");
            if (stringArray != null && stringArray.length > 0 && "true".equalsIgnoreCase(stringArray[0])) {
                this.env.put("testTimeout", String.valueOf(this.getTestTimeout()));
                return true;
            }
        }
        catch (TestEnvironment.Fault fault) {
            this.trOut.println(string + ".isGroupMode is not set: " + fault);
        }
        return false;
    }

    protected String adjustForGroupMode(String string) {
        return this.isGroupMode(string) ? (string = string + ".group") : string;
    }

    static {
        schemaCache = Collections.synchronizedMap(new HashMap());
    }

    public static class InitializationException
    extends Exception {
        private static final long serialVersionUID = 3977022838043587382L;

        public InitializationException(String string) {
            super(string);
        }
    }
}

