/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.interview.Interview;
import com.sun.javatest.DefaultTestRunner;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Script;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestRunner;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.finder.BinaryTestFinder;
import com.sun.javatest.services.ServiceManager;
import com.sun.javatest.services.ServiceReader;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import com.sun.jck.interview.JCKParameters;
import com.sun.jck.lib.IntermediateScript;
import com.sun.jck.lib.JCKReverseTestFinder;
import com.sun.jck.lib.JCKScript;
import com.sun.jck.lib.JCKTestFilter;
import com.sun.jck.lib.JCKTestFinder;
import com.sun.jck.lib.JaxbTckScript;
import com.sun.jck.lib.PrecompileJaxbTckScript;
import com.sun.jck.lib.runner.JCKTestRunner;
import com.sun.jck.services.KeyServiceReader;
import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JCKTestSuite
extends TestSuite {
    private int concurrency = 1;
    private boolean compilerFlag = false;
    private boolean runtimeFlag = false;
    private boolean devtoolsFlag = false;
    private boolean certifyFlag = false;
    private boolean precompileFlag = false;
    private boolean developerFlag = false;
    private boolean scriptGenFlag = false;
    public static final int COMPILER = 1;
    public static final int RUNTIME = 2;
    public static final int DEVTOOLS = 3;
    public static final int CERTIFY = 1;
    public static final int PRECOMPILE = 2;
    public static final int DEVELOPER = 3;
    private int product;
    private int mode;
    private String scriptPrecompileClassDir;
    private boolean finderVerifyFlag;
    private int finderMode;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(JCKTestSuite.class);

    public JCKTestSuite(File file, Map map, ClassLoader classLoader) throws TestSuite.Fault {
        super(JCKTestSuite.canonicalizeRoot(file), map, classLoader);
    }

    public ServiceReader getServiceReader() {
        KeyServiceReader keyServiceReader = new KeyServiceReader();
        keyServiceReader.init(this, null);
        return keyServiceReader;
    }

    private static File canonicalizeRoot(File file) throws TestSuite.Fault {
        if (file.isFile()) {
            if (file.getName().equalsIgnoreCase("testsuite.html")) {
                return file.getParentFile().getParentFile();
            }
            throw new TestSuite.Fault(i18n, "ts.badRootFile", file);
        }
        if (new File(file, "testsuite.jtt").exists()) {
            return file;
        }
        if (new File(file, "testsuite.html").exists()) {
            return file.getParentFile();
        }
        if (new File(new File(file, "tests"), "testsuite.html").exists()) {
            return file;
        }
        throw new TestSuite.Fault(i18n, "ts.badRootFile", file);
    }

    public TestRunner createTestRunner() {
        if (this.concurrency > 1 && System.getProperty(JCKTestRunner.USE_DEFAULT) == null) {
            return new JCKTestRunner(this.concurrency);
        }
        return new DefaultTestRunner();
    }

    public void init(String[] stringArray) throws TestSuite.Fault {
        String string = System.getProperty("JCKTestSuite.defaultArgs");
        if (string != null) {
            this.decodeArgs(StringArray.split(string));
        }
        this.decodeArgs(stringArray);
        if (!(this.compilerFlag || this.runtimeFlag || this.devtoolsFlag)) {
            throw new TestSuite.Fault(i18n, "ts.needCompOrRuntime");
        }
        if (this.compilerFlag && this.runtimeFlag || this.compilerFlag && this.devtoolsFlag || this.runtimeFlag && this.devtoolsFlag) {
            throw new TestSuite.Fault(i18n, "ts.multCompOrRuntime");
        }
        if (this.certifyFlag && this.developerFlag || this.developerFlag && this.precompileFlag || this.precompileFlag && this.certifyFlag) {
            throw new TestSuite.Fault(i18n, "ts.badMode");
        }
        if (!(this.certifyFlag || this.developerFlag || this.precompileFlag)) {
            this.mode = 1;
        }
    }

    public void starting(Harness harness) throws TestSuite.Fault {
        Object object;
        JaxbTckScript.schemaCache.clear();
        this.concurrency = harness.getParameters().getConcurrency();
        String string = this.getRootDir().getAbsolutePath();
        TestEnvironment testEnvironment = harness.getParameters().getEnv();
        boolean bl = false;
        try {
            object = testEnvironment.lookup("servicesOn");
            if (object != null && ((String[])object).length > 0) {
                bl = Boolean.parseBoolean(object[0]);
            }
        }
        catch (TestEnvironment.Fault fault) {
            Logger.getLogger(JCKTestSuite.class.getName()).log(Level.SEVERE, null, fault);
        }
        object = bl ? ServiceManager.StartMode.LAZY : ServiceManager.StartMode.MANUALLY;
        ServiceManager serviceManager = this.getServiceManager();
        if (serviceManager != null) {
            serviceManager.setStartMode((ServiceManager.StartMode)((Object)object));
        }
        super.starting(harness);
    }

    protected void decodeArgs(String[] stringArray) throws TestSuite.Fault {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("-webWalk")) {
                this.finderMode = 1;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-dirWalk")) {
                this.finderMode = 2;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-verify")) {
                this.finderVerifyFlag = true;
                continue;
            }
            if (stringArray[i].equals("-compiler")) {
                this.product = 1;
                this.compilerFlag = true;
                continue;
            }
            if (stringArray[i].equals("-runtime")) {
                this.product = 2;
                this.runtimeFlag = true;
                continue;
            }
            if (stringArray[i].equals("-devtools")) {
                this.product = 3;
                this.devtoolsFlag = true;
                continue;
            }
            if (stringArray[i].equals("-certify")) {
                this.mode = 1;
                this.certifyFlag = true;
                continue;
            }
            if (stringArray[i].equals("-developer")) {
                this.mode = 3;
                this.developerFlag = true;
                continue;
            }
            if (stringArray[i].equals("-scriptgen")) {
                this.scriptGenFlag = true;
                continue;
            }
            if (stringArray[i].equals("-precompile")) {
                this.mode = 2;
                this.precompileFlag = true;
                continue;
            }
            if (stringArray[i].equals("-precompileClassDir") && i + 1 < stringArray.length) {
                this.scriptPrecompileClassDir = stringArray[++i];
                continue;
            }
            throw new TestSuite.Fault(i18n, "ts.badArg", stringArray[i]);
        }
    }

    public File getTestsDir() {
        String string = (String)this.getTestSuiteInfo().get("tests");
        if (string == null || string.length() == 0) {
            return new File(this.getRootDir(), "tests");
        }
        File file = new File(string);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.getRootDir(), file.getPath());
    }

    public TestFilter createTestFilter(TestEnvironment testEnvironment) {
        return new JCKTestFilter(testEnvironment, this.product, this.mode);
    }

    private TestFinder createTestFinder0() throws TestSuite.Fault {
        if (this.product == 3) {
            return super.createTestFinder();
        }
        try {
            File file;
            String string = (String)this.getTestSuiteInfo().get("testsuite.jtd");
            File file2 = string == null || string.length() == 0 ? new File(new File(this.getRootDir(), "tests"), "testsuite.jtd") : ((file = new File(string)).isAbsolute() ? file : new File(this.getRootDir(), file.getPath()));
            file = this.getTestsDir();
            if (file2.exists()) {
                BinaryTestFinder binaryTestFinder = new BinaryTestFinder();
                binaryTestFinder.init(new String[]{"-binary", file2.getPath()}, file, null);
                return binaryTestFinder;
            }
            JCKTestFinder jCKTestFinder = new JCKTestFinder();
            if (this.finderMode == 1) {
                jCKTestFinder.setMode(1);
                jCKTestFinder.setRoot(new File(file, "testsuite.html"));
            } else {
                jCKTestFinder.setMode(2);
                jCKTestFinder.setRoot(file);
            }
            jCKTestFinder.setVerify(this.finderVerifyFlag);
            return jCKTestFinder;
        }
        catch (TestFinder.Fault fault) {
            throw new TestSuite.Fault(i18n, "ts.errorInitFinder", fault.getMessage());
        }
    }

    public TestFinder createTestFinder() throws TestSuite.Fault {
        TestFinder testFinder = this.createTestFinder0();
        if (Boolean.getBoolean("jck.testOrderReversed")) {
            return new JCKReverseTestFinder(testFinder);
        }
        return testFinder;
    }

    public Script createScript(TestDescription testDescription, String[] stringArray, TestEnvironment testEnvironment, WorkDirectory workDirectory, BackupPolicy backupPolicy) throws TestSuite.Fault {
        Class clazz = this.product == 3 ? (this.mode == 2 ? PrecompileJaxbTckScript.class : JaxbTckScript.class) : JCKScript.class;
        try {
            if (testEnvironment.lookup("script").length == 0) {
                testEnvironment.put("script", clazz.getName());
            }
        }
        catch (TestEnvironment.Fault fault) {
            testEnvironment.put("script", clazz.getName());
        }
        Script script = super.createScript(testDescription, stringArray, testEnvironment, workDirectory, backupPolicy);
        if (script instanceof IntermediateScript) {
            IntermediateScript intermediateScript = (IntermediateScript)script;
            intermediateScript.setScriptGenMode(this.scriptGenFlag);
            intermediateScript.setProduct(this.product);
            if (script instanceof JCKScript) {
                JCKScript jCKScript = (JCKScript)script;
                jCKScript.initArgs(null);
                jCKScript.setProduct(this.product);
                jCKScript.setMode(this.mode);
                if (this.mode == 2) {
                    jCKScript.setPrecompileClassDir(this.scriptPrecompileClassDir);
                }
            }
        }
        return script;
    }

    public InterviewParameters createInterview() throws TestSuite.Fault {
        try {
            if (this.mode == 2) {
                return new JCKParameters(this, "runtime", 2);
            }
            if (this.product == 2) {
                return new JCKParameters(this, "runtime", this.mode);
            }
            if (this.product == 1) {
                return new JCKParameters(this, "compiler", this.mode);
            }
            return new JCKParameters(this, "devtools", this.mode);
        }
        catch (Interview.Fault fault) {
            throw new TestSuite.Fault(i18n, "ts.errorInitInterview", fault.getMessage());
        }
    }

    public int getProduct() {
        return this.product;
    }

    public static String[] getRequiredEntries() {
        return new String[]{"keywords", "source", "title"};
    }

    public static String[] getValidEntries() {
        return new String[]{"keywords", "source", "title", "context", "executeArgs", "executeClass", "executeNative", "id", "remote", "jplisAgent", "rmicClass", "rmicClasses", "selectIf", "executeIf", "timeout", "executeLocks", "apSource", "apClass", "apArgs", "apClassSource", "jvmArgSplash", "jvmArgJar"};
    }

    public static String[] getValidKeywords() {
        return new String[]{"compiler", "runtime", "devtools", "positive", "negative", "idl_inherit", "idl_tie", "interactive", "jniinvocationapi", "only_once", "rmi_iiop", "rmi_v11", "serial"};
    }
}

