/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.interview.YesNoQuestion;
import com.sun.javatest.TestSuite;
import com.sun.jck.interview.CompilerInterview;
import com.sun.jck.interview.DevtoolsInterview;
import com.sun.jck.interview.JCKEnvInterview;
import com.sun.jck.interview.JCKParameters;
import com.sun.jck.interview.ProductInterview;
import com.sun.jck.interview.RuntimeInterview;
import com.sun.jck.interview.TestPlatformInterview;
import com.sun.jck.interview.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServicesInterview
extends JCKEnvInterview {
    private List<String> rmidTests = Arrays.asList("api/java_rmi/activation");
    static final List<String> distrTests = Arrays.asList("api/java_net/distributed", "api/java_nio/channels/DatagramChannel", "api/java_nio/channels/AsynchronousDatagramChannel", "api/java_util/jar/Pack200/distributed", "api/javax_management/remote", "api/javax_xml/ws", "api/org_omg/PortableInterceptor", "api/org_omg/PortableServer", "vm/jdwp", "api/org_omg/PortableServer/POA");
    private List<String> orbTests = Arrays.asList("api/org_omg", "api/javax_rmi", "api/javax_management/remote");
    private ProductInterview parent;
    Suite suite;
    private Question qIntro = new NullQuestion(this, "intro"){

        protected Question getNext() {
            if (!ServicesInterview.this.isLocal()) {
                return ServicesInterview.this.qAutoServices;
            }
            if (ServicesInterview.this.suite == Suite.RUNTIME && (ServicesInterview.this.matchTests(distrTests) || ServicesInterview.this.matchTests(ServicesInterview.this.orbTests) || ServicesInterview.this.matchTests(ServicesInterview.this.rmidTests))) {
                return ServicesInterview.this.qAutoServices;
            }
            return ServicesInterview.this.qEnd;
        }

        public boolean isHidden() {
            return true;
        }
    };
    private Question qAutoServices = new AutoServiceQuestion(this, "servicesOn"){

        public boolean isHidden() {
            return ServicesInterview.this.isLocal();
        }
    };
    private Question qAutoServicesRt = new AutoServiceQuestion(this, "servicesOnRt"){

        public boolean isHidden() {
            if (!ServicesInterview.this.isLocal()) {
                return false;
            }
            return !ServicesInterview.this.matchTests(distrTests) && !ServicesInterview.this.matchTests(ServicesInterview.this.orbTests) && !ServicesInterview.this.matchTests(ServicesInterview.this.rmidTests);
        }
    };
    private Question qRemoteCommand = new StringQuestion(this, "sshCommand"){
        private final String[] SSH_PROGS;
        private final String SSH_OPTIONS = " -t -t @{host} (cd @{testsuite}; @{command})";
        private final List<String> suggestionList;
        {
            this.SSH_PROGS = new String[]{"ssh", "ssh.exe"};
            this.SSH_OPTIONS = " -t -t @{host} (cd @{testsuite}; @{command})";
            this.suggestionList = new ArrayList<String>();
            this.suggestionList.add("");
            Map<String, String> map = System.getenv();
            String string2 = System.getenv("PATH");
            if (string2 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
                HashSet<String> hashSet = new HashSet<String>();
                block2: while (stringTokenizer.hasMoreElements()) {
                    File file = new File(stringTokenizer.nextToken());
                    if (!file.exists()) continue;
                    for (String string3 : this.SSH_PROGS) {
                        File file2 = new File(file, string3);
                        if (!file2.exists()) continue;
                        hashSet.add(file2.getAbsolutePath());
                        continue block2;
                    }
                }
                if (hashSet.isEmpty()) {
                    hashSet.add("ssh");
                }
                for (String string4 : hashSet) {
                    this.suggestionList.add(string4 + " -t -t @{host} (cd @{testsuite}; @{command})");
                }
            }
            this.setSuggestions(this.suggestionList.toArray(new String[0]));
            if (this.getValue() == null) {
                try {
                    this.setValue(this.getSuggestions()[1]);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }

        public void export(Map map) {
            if (this.getValue() == null) {
                return;
            }
            String string = Utils.adjustForSpace(this.getValue());
            map.put("ssh.command", string);
        }

        public boolean isHidden() {
            if (!ServicesInterview.this.areServicesOn()) {
                return true;
            }
            if (!ServicesInterview.this.isLocal()) {
                return false;
            }
            ProductInterview productInterview = ServicesInterview.this.parent;
            if (productInterview instanceof RuntimeInterview) {
                return !ServicesInterview.this.matchTests(distrTests) && !ServicesInterview.this.matchTests(ServicesInterview.this.orbTests);
            }
            return true;
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            return ServicesInterview.this.qEnd;
        }
    };
    private Question qEnd = new FinalQuestion(this);

    public ServicesInterview(ProductInterview productInterview) {
        super(productInterview, "services");
        this.parent = productInterview;
        this.suite = Suite.getSuite(productInterview);
        this.setFirstQuestion(this.qIntro);
        if (this.suite == Suite.RUNTIME) {
            this.qAutoServices = this.qAutoServicesRt;
        }
    }

    private boolean containsTests(File file, List<String> list) {
        boolean bl = false;
        char c = '/';
        for (String string : list) {
            File file2 = new File(file, string = string.replace(c, File.separatorChar));
            if (!file2.exists()) continue;
            return true;
        }
        return bl;
    }

    boolean matchTests(List<String> list) {
        if (list == null) {
            return true;
        }
        JCKParameters jCKParameters = this.parent.getRootInterview();
        String[] stringArray = jCKParameters.getTests();
        TestSuite testSuite = jCKParameters.getTestSuite();
        if (testSuite == null) {
            return false;
        }
        File file = testSuite.getTestsDir();
        if (!this.containsTests(file, list)) {
            return false;
        }
        if (stringArray == null || stringArray.length == 0) {
            return true;
        }
        for (String string : list) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith(string) && !string.startsWith(stringArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isLocal() {
        TestPlatformInterview testPlatformInterview = this.parent.getTestPlatformInterview();
        return !testPlatformInterview.isUseAgent();
    }

    boolean areServicesOn() {
        if (this.qAutoServices == null) {
            return false;
        }
        if (this.qAutoServices.isHidden()) {
            return false;
        }
        String string = this.qAutoServices.getStringValue();
        return "Yes".equals(string);
    }

    boolean needRmid() {
        return this.matchTests(this.rmidTests);
    }

    boolean needOrb() {
        return this.matchTests(this.orbTests);
    }

    boolean needDistr() {
        return this.matchTests(distrTests);
    }

    public void exportJavaHome(String string, Map map) {
        if (string == null) {
            return;
        }
        TestPlatformInterview testPlatformInterview = this.parent.getTestPlatformInterview();
        char c = testPlatformInterview.getFileSep();
        String string2 = string;
        for (int i = 0; i < 2; ++i) {
            int n = string2.lastIndexOf(c);
            if (n < 0) {
                return;
            }
            string2 = string.substring(0, n);
        }
        map.put("java.home", Utils.adjust(string2));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Suite {
        RUNTIME,
        COMPILER,
        DEVTOOLS;


        public static Suite getSuite(ProductInterview productInterview) {
            if (productInterview instanceof RuntimeInterview) {
                return RUNTIME;
            }
            if (productInterview instanceof CompilerInterview) {
                return COMPILER;
            }
            if (productInterview instanceof DevtoolsInterview) {
                return DEVTOOLS;
            }
            throw new RuntimeException("Unknown interview type: " + productInterview);
        }
    }

    public static interface QTags {
        public static final String AUTO_SERVICES_RT = "servicesOnRt";
        public static final String AUTO_SERVICES = "servicesOn";
        public static final String REMOTE_COMMAND = "sshCommand";
        public static final String AGENT_HOSTS = "activeHosts";
        public static final String DISTR_AGENT_COMMAND = "serviceCommand";
        public static final String RMI_LOCAL = "rmiServiceLocal";
        public static final String RMI_REMOTE = "rmiServiceRemote";
        public static final String ORB = "orbService";
        public static final String ACTIVE_AGENT_COMMAND = "activeServiceCommand";
        public static final String PASSIVE_AGENT_COMMAND = "passiveServiceCommand";
        public static final String RMI_INTRO = "rmiService";
    }

    private class AutoServiceQuestion
    extends YesNoQuestion {
        public AutoServiceQuestion(Interview interview, String string) {
            super(interview, string);
            this.setDefaultValue("No");
        }

        public void export(Map map) {
            boolean bl = "Yes".equals(this.value);
            String string = Boolean.toString(bl);
            map.put("servicesOn", string);
        }

        public boolean isHidden() {
            return false;
        }

        protected Question getNext() {
            if (!ServicesInterview.this.qRemoteCommand.isHidden()) {
                return ServicesInterview.this.qRemoteCommand;
            }
            return ServicesInterview.this.qEnd;
        }
    }
}

