/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.interview.ErrorQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.IntQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.jck.interview.JCKEnvInterview;
import com.sun.jck.interview.JCKExportedQuestion;
import com.sun.jck.interview.JCKInetAddressQuestion;
import com.sun.jck.interview.JCKYesNoQuestion;
import com.sun.jck.interview.RuntimeInterview;
import com.sun.jck.interview.TestPlatformInterview;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;

class RuntimeNetworkInterview
extends JCKEnvInterview {
    StringQuestion qLocalHostName = new StringQuestion(this, "localHostName"){

        public String[] getSuggestions() {
            String[] stringArray = super.getSuggestions();
            TestPlatformInterview testPlatformInterview = RuntimeNetworkInterview.this.iRuntime.getTestPlatformInterview();
            if (stringArray == null && testPlatformInterview.isLocal()) {
                stringArray = new String[]{this.getDefValue()};
                this.setSuggestions(stringArray);
            }
            return stringArray;
        }

        protected void load(Map map) {
            super.setValue((String)map.get(this.tag));
        }

        public void setValue(String string) {
            super.setValue(string);
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return RuntimeNetworkInterview.this.qLocalHostIPAddress;
        }

        public boolean isHidden() {
            boolean bl = RuntimeNetworkInterview.this.iRuntime.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return RuntimeNetworkInterview.getLocalhostName();
        }
    };
    private JCKInetAddressQuestion qLocalHostIPAddress = new JCKInetAddressQuestion(this, "localHostIPAddr", 1){

        public void export(Map map) {
            if (this.value != null) {
                String string = RuntimeNetworkInterview.this.qLocalHostName.getValue() + "/" + this.value.getHostAddress();
                map.put("localHost", string);
                map.put("network.localHost", string);
                map.put("serialHost", "localHost/127.0.0.1");
                map.put("netSerialFile", "../lib/InetAddr.ser");
            }
        }

        public InetAddress getValue() {
            return super.getValue();
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            return RuntimeNetworkInterview.this.qTestHost1Name;
        }

        public boolean isHidden() {
            boolean bl = RuntimeNetworkInterview.this.iRuntime.isSimple();
            if (bl) {
                try {
                    this.setValue(this.getDefValue());
                }
                catch (Interview.Fault fault) {
                    return false;
                }
            }
            return bl;
        }

        private String getDefValue() {
            return RuntimeNetworkInterview.getLocalhostIP();
        }
    };
    private ErrorQuestion qIPAddressError = new ErrorQuestion(this, "ipAddressError");
    private StringQuestion qTestHost1Name = new StringQuestion(this, "testHost1Name"){

        protected void load(Map map) {
            super.setValue((String)map.get(this.tag));
        }

        public void setValue(String string) {
            super.setValue(string);
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            if (this.value.equals(RuntimeNetworkInterview.this.qLocalHostName.getValue())) {
                return RuntimeNetworkInterview.this.qTestHost1NameError1;
            }
            return RuntimeNetworkInterview.this.qTestHost1IPAddress;
        }
    };
    private ErrorQuestion qTestHost1NameError1 = new ErrorQuestion(this, "testHost1NameError1");
    private JCKInetAddressQuestion qTestHost1IPAddress = new JCKInetAddressQuestion(this, "testHost1IPAddr", 1){

        public Object[] getTextArgs() {
            return new Object[]{RuntimeNetworkInterview.this.qTestHost1Name.getValue()};
        }

        public void export(Map map) {
            if (this.value != null) {
                String string = RuntimeNetworkInterview.this.qTestHost1Name.getValue() + "/" + this.value.getHostAddress();
                map.put("testHost1", string);
                map.put("network.testHost1", string);
            }
        }

        public InetAddress getValue() {
            try {
                this.setValue(RuntimeNetworkInterview.this.qTestHost1Name.getValue());
            }
            catch (Interview.Fault fault) {
                this.setValue((InetAddress)null);
            }
            return super.getValue();
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            return RuntimeNetworkInterview.this.qTestHost2Name;
        }

        public InetAddress[] getSuggestions() {
            InetAddress inetAddress;
            InetAddress[] inetAddressArray = super.getSuggestions();
            boolean bl = RuntimeNetworkInterview.this.iRuntime.isSimple();
            if (inetAddressArray == null && bl && !this.isHidden() && (inetAddress = this.getDefValue()) != null) {
                return new InetAddress[]{inetAddress};
            }
            return null;
        }

        private InetAddress getDefValue() {
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(RuntimeNetworkInterview.this.qTestHost1Name.getValue());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            return inetAddress;
        }
    };
    private StringQuestion qTestHost2Name = new StringQuestion(this, "testHost2Name"){

        protected void load(Map map) {
            super.setValue((String)map.get(this.tag));
        }

        public void setValue(String string) {
            super.setValue(string);
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            if (this.value.equals(RuntimeNetworkInterview.this.qLocalHostName.getValue())) {
                return RuntimeNetworkInterview.this.qTestHost2NameError1;
            }
            if (this.value.equals(RuntimeNetworkInterview.this.qTestHost1Name.getValue())) {
                return RuntimeNetworkInterview.this.qTestHost2NameError2;
            }
            return RuntimeNetworkInterview.this.qTestHost2IPAddress;
        }
    };
    private ErrorQuestion qTestHost2NameError1 = new ErrorQuestion(this, "testHost2NameError1");
    private ErrorQuestion qTestHost2NameError2 = new ErrorQuestion(this, "testHost2NameError2");
    private JCKInetAddressQuestion qTestHost2IPAddress = new JCKInetAddressQuestion(this, "testHost2IPAddr", 1){

        public Object[] getTextArgs() {
            return new Object[]{RuntimeNetworkInterview.this.qTestHost2Name.getValue()};
        }

        public void export(Map map) {
            if (this.value != null) {
                String string = RuntimeNetworkInterview.this.qTestHost2Name.getValue() + "/" + this.value.getHostAddress();
                map.put("testHost2", string);
                map.put("network.testHost2", string);
            }
        }

        public InetAddress getValue() {
            try {
                this.setValue(RuntimeNetworkInterview.this.qTestHost2Name.getValue());
            }
            catch (Interview.Fault fault) {
                this.setValue((InetAddress)null);
            }
            return super.getValue();
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            return RuntimeNetworkInterview.this.qUDPRange;
        }

        public InetAddress[] getSuggestions() {
            InetAddress inetAddress;
            InetAddress[] inetAddressArray = super.getSuggestions();
            boolean bl = RuntimeNetworkInterview.this.iRuntime.isSimple();
            if (inetAddressArray == null && bl && !this.isHidden() && (inetAddress = this.getDefValue()) != null) {
                return new InetAddress[]{inetAddress};
            }
            return null;
        }

        private InetAddress getDefValue() {
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(RuntimeNetworkInterview.this.qTestHost2Name.getValue());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            return inetAddress;
        }
    };
    private JCKYesNoQuestion qUDPRange = new JCKYesNoQuestion(this, "udpRange"){

        public void export(Map map) {
            String string = this.value == "No" ? "0" : RuntimeNetworkInterview.this.qUDPLower.getValue() + "-" + RuntimeNetworkInterview.this.qUDPUpper.getValue();
            map.put("network.udpPortRange", string);
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "No") {
                return RuntimeNetworkInterview.this.qEnd;
            }
            return RuntimeNetworkInterview.this.qUDPLower;
        }

        public boolean isHidden() {
            boolean bl = RuntimeNetworkInterview.this.iRuntime.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "No";
        }
    };
    IntQuestion qUDPLower = new IntQuestion(this, "udpLower", 1, 65535){

        protected Question getNext() {
            if (!this.isValid()) {
                return null;
            }
            return RuntimeNetworkInterview.this.qUDPUpper;
        }
    };
    IntQuestion qUDPUpper = new IntQuestion(this, "udpUpper", 1, 65535){

        protected Question getNext() {
            if (!this.isValid()) {
                return null;
            }
            if (RuntimeNetworkInterview.this.qUDPLower.getValue() > this.value) {
                return RuntimeNetworkInterview.this.qUDPRangeError;
            }
            return RuntimeNetworkInterview.this.qEnd;
        }
    };
    private ErrorQuestion qUDPRangeError = new ErrorQuestion(this, "udpRangeError1");
    private Question qEnd = new FinalQuestion(this);
    private RuntimeInterview iRuntime;

    RuntimeNetworkInterview(RuntimeInterview runtimeInterview) {
        super(runtimeInterview, "net");
        this.iRuntime = runtimeInterview;
        this.setFirstQuestion(this.qLocalHostName);
    }

    public void export(Map map) {
        if (this.iRuntime.isSimple()) {
            JCKExportedQuestion[] jCKExportedQuestionArray = new JCKExportedQuestion[]{this.qLocalHostIPAddress, this.qTestHost1IPAddress, this.qTestHost2IPAddress, this.qUDPRange};
            for (int i = 0; i < jCKExportedQuestionArray.length; ++i) {
                JCKExportedQuestion jCKExportedQuestion = jCKExportedQuestionArray[i];
                if (!jCKExportedQuestion.isHidden()) continue;
                jCKExportedQuestion.export(map);
            }
        }
    }

    static String getLocalhostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "localhost";
        }
    }

    static String getLocalhostIP() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return "127.0.0.1";
        }
    }
}

