/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import com.sun.javatest.CompositeFilter;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestSuite;
import com.sun.javatest.interview.DefaultInterviewParameters;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.jck.interview.EnvironmentInterview;
import com.sun.jck.interview.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;

public class JCKParameters
extends DefaultInterviewParameters
implements Parameters.EnvParameters {
    private Question qIntro = new NullQuestion(this, "intro"){

        protected Question getNext() {
            return JCKParameters.this.getPrologSuccessorQuestion();
        }
    };
    private Question qParameters = new NullQuestion(this, "parameters"){

        public boolean isHidden() {
            return JCKParameters.this.isSimple();
        }

        protected Question getNext() {
            if (!JCKParameters.this.isSimple()) {
                return JCKParameters.this.getExcludeListFirstQuestion();
            }
            return JCKParameters.this.qEnd;
        }
    };
    private Question qEnd = new FinalQuestion(this, "end");
    private final EnvironmentInterview iEnvironment = new EnvironmentInterview(this);
    public static final int CERTIFY = 1;
    public static final int PRECOMPILE = 2;
    public static final int DEVELOPER = 3;
    private Properties backdoorProps;
    private static final String BACKDOOR_FILE = "lib/tck.properties";

    public JCKParameters() throws Interview.Fault {
        super("jck");
        this.setHelpSet("moreInfo/jckwiz");
        this.setResourceBundle("resources/jck");
        this.setFirstQuestion(this.qIntro);
        this.setEdited(false);
    }

    public JCKParameters(TestSuite testSuite, String string, int n) throws Interview.Fault {
        super("jck", testSuite);
        this.setDefaultImage(this.getClass().getResource("wave.med.gif"));
        this.setHelpSet("moreInfo/jckwiz");
        this.setResourceBundle("resources/jck");
        this.setFirstQuestion(this.qIntro);
        this.setEdited(false);
        this.iEnvironment.setProduct(string);
        this.iEnvironment.setMode(n);
    }

    public TestEnvironment getEnv() {
        String string = this.iEnvironment.getName();
        if (string == null) {
            return null;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        this.loadBackdoorValues();
        this.iEnvironment.export(hashMap);
        if (this.backdoorProps != null) {
            hashMap.putAll(this.backdoorProps);
        }
        hashMap.put("testsuite.root", Utils.adjust(this.getTestSuite().getRootDir().getPath()));
        hashMap.put("javatestTimeoutFactor", Float.toString(this.getTimeoutFactor()));
        try {
            File file = this.getFile();
            String string2 = file != null ? file.getPath() : this.getTitle();
            return new TestEnvironment(string, hashMap, string2);
        }
        catch (TestEnvironment.Fault fault) {
            I18NResourceBundle i18NResourceBundle = I18NResourceBundle.getBundleForClass(this.getClass());
            throw new JavaTestError(i18NResourceBundle, "unexpected exception", fault);
        }
    }

    public TestFilter getRelevantTestFilter() {
        TestFilter testFilter = this.getTestSuite().createTestFilter(this.getEnv());
        TestFilter testFilter2 = this.getExcludeTableFilter();
        I18NResourceBundle i18NResourceBundle = I18NResourceBundle.getBundleForClass(this.getClass());
        Vector<TestFilter> vector = new Vector<TestFilter>(2);
        if (testFilter != null) {
            vector.add(testFilter);
        }
        if (testFilter2 != null) {
            vector.add(testFilter2);
        }
        Object[] objectArray = new TestFilter[vector.size()];
        vector.copyInto(objectArray);
        CompositeFilter compositeFilter = new CompositeFilter((TestFilter[])objectArray, i18NResourceBundle, "params.rFilter");
        return compositeFilter;
    }

    String getTestClassPath() {
        return this.getTestSuite().getTestSuiteInfo("testclasspath");
    }

    public Parameters.EnvParameters getEnvParameters() {
        return this;
    }

    boolean isErrorCheckingEnabled() {
        String string = System.getProperty("jck.interviewErrorCheckingEnabled");
        return string == null || !string.equals("false");
    }

    private void loadBackdoorValues() {
        TestSuite testSuite = this.getTestSuite();
        if (testSuite == null) {
            return;
        }
        File file = new File(testSuite.getRootDir(), BACKDOOR_FILE);
        if (file.canRead()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                this.backdoorProps = new Properties();
                this.backdoorProps.load(fileInputStream);
            }
            catch (IOException iOException) {
                this.backdoorProps = null;
            }
        }
    }

    protected Question getPrologSuccessorQuestion() {
        return this.getEnvFirstQuestion();
    }

    protected Question getEnvFirstQuestion() {
        return this.callInterview(this.iEnvironment, this.getEnvSuccessorQuestion());
    }

    protected Question getEnvSuccessorQuestion() {
        return this.qParameters;
    }

    protected Question getTestsSuccessorQuestion() {
        return this.getExcludeTableFirstQuestion();
    }

    protected Question getPriorStatusSuccessorQuestion() {
        return this.getConcurrencyFirstQuestion();
    }

    protected Question getEpilogFirstQuestion() {
        return this.qEnd;
    }

    protected boolean isSimple() {
        return this.iEnvironment.isSimple();
    }
}

