/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.interview.ChoiceQuestion;
import com.sun.interview.FileQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.interview.YesNoQuestion;
import com.sun.jck.interview.CompilerAPIMultiJVMInterview;
import com.sun.jck.interview.CompilerInterview;
import com.sun.jck.interview.GroupModeSupport;
import com.sun.jck.interview.JCKEnvInterview;
import com.sun.jck.interview.JCKParameters;
import com.sun.jck.interview.ServicesInterview;
import com.sun.jck.interview.TestPlatformInterview;
import com.sun.jck.interview.Utils;
import java.io.File;
import java.util.Map;

class CompilerTestCompileInterview
extends JCKEnvInterview {
    private GroupModeSupport iGroupMode;
    private Question qIntro = new NullQuestion(this, "intro"){

        protected Question getNext() {
            if (CompilerTestCompileInterview.this.getTestPlatformInterview().isMultiJVM()) {
                return CompilerTestCompileInterview.this.qCompilerType;
            }
            ServicesInterview servicesInterview = CompilerTestCompileInterview.this.parent.getServicesInterview();
            if (servicesInterview.areServicesOn()) {
                return CompilerTestCompileInterview.this.callInterview(CompilerTestCompileInterview.this.iCompilerAPIMultiJVM, CompilerTestCompileInterview.this.qOtherOpts);
            }
            return CompilerTestCompileInterview.this.qOtherOpts;
        }

        public void export(Map map) {
            TestPlatformInterview testPlatformInterview = CompilerTestCompileInterview.this.parent.getTestPlatformInterview();
            char c = testPlatformInterview.getFileSep();
            char[] cArray = new char[]{c};
            String string = new String(cArray);
            map.put("platform.fileSeparator", string);
            boolean bl = testPlatformInterview.isGroupMode() && CompilerTestCompileInterview.this.iGroupMode.isGroupModeEnabled();
            map.put("testCompile.isGroupMode", String.valueOf(bl));
            map.put("testAnnoProcSrc.isGroupMode", String.valueOf(bl));
            map.put("testAnnoProcCls.isGroupMode", String.valueOf(bl));
            CommandBuilder commandBuilder = new CommandBuilder();
            map.put("command.testCompile.java", commandBuilder.makeCommand(1, false));
            map.put("command.testAnnoProcSrc.java", commandBuilder.makeCommand(2, false));
            map.put("command.testAnnoProcCls.java", commandBuilder.makeCommand(3, false));
            if (bl) {
                map.put("command.testCompile.group.java", commandBuilder.makeCommand(1, true));
                map.put("command.testAnnoProcSrc.group.java", commandBuilder.makeCommand(2, true));
                map.put("command.testAnnoProcCls.group.java", commandBuilder.makeCommand(3, true));
            }
            map.put("compilerClassOutURL", new File(CompilerTestCompileInterview.this.getRootInterview().getWorkDirectory().getPath(), "classes").toURI().toString());
            map.put("annoProcRefClassPath", "$testSuiteRootURL/lib/ap/classes.jar");
            map.put("pathTo.javac", Utils.adjust(CompilerTestCompileInterview.this.getCompilerPathName().getPath()));
        }
    };
    static final String COMPILER_API = "Java compiler API (JSR 199)";
    static final String CMD_LINE = "command line tool";
    private ChoiceQuestion qCompilerType = new ChoiceQuestion(this, "compilerType"){
        {
            this.setChoices(new String[]{null, CompilerTestCompileInterview.COMPILER_API, CompilerTestCompileInterview.CMD_LINE});
            this.setDefaultValue(CompilerTestCompileInterview.CMD_LINE);
        }

        protected Question getNext() {
            if (CompilerTestCompileInterview.CMD_LINE.equals(this.value)) {
                if (CompilerTestCompileInterview.this.getTestPlatformInterview().isLocal()) {
                    return CompilerTestCompileInterview.this.qCmdAsFile;
                }
                return CompilerTestCompileInterview.this.qCmdAsString;
            }
            if (CompilerTestCompileInterview.COMPILER_API.equals(this.value)) {
                return CompilerTestCompileInterview.this.getTestPlatformInterview().isMultiJVM() ? CompilerTestCompileInterview.this.callInterview(CompilerTestCompileInterview.this.iCompilerAPIMultiJVM, CompilerTestCompileInterview.this.qOtherOpts) : CompilerTestCompileInterview.this.qOtherOpts;
            }
            return null;
        }

        public boolean isHidden() {
            boolean bl = CompilerTestCompileInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            } else if (CompilerTestCompileInterview.this.getTestPlatformInterview().isGroupMode()) {
                this.setValue(CompilerTestCompileInterview.COMPILER_API);
                return true;
            }
            return bl;
        }

        private String getDefValue() {
            return CompilerTestCompileInterview.CMD_LINE;
        }
    };
    private YesNoQuestion qDefaultCompiler = new YesNoQuestion(this, "defaultCompiler"){
        {
            this.setDefaultValue("Yes");
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            return "Yes".equals(this.value) ? CompilerTestCompileInterview.this.qAnnoProcOpt : CompilerTestCompileInterview.this.qCompilerClass;
        }
    };
    private StringQuestion qCompilerClass = new StringQuestion(this, "compilerClass"){

        protected Question getNext() {
            return this.value == null || this.value.trim().length() == 0 ? null : CompilerTestCompileInterview.this.qAnnoProcOpt;
        }
    };
    private StringQuestion qAnnoProc = new StringQuestion(this, "annoProc"){
        {
            this.setSuggestions(new String[]{"", "-processor #", "/processor:#"});
            this.setDefaultValue("-processor #");
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0 || this.value.indexOf("#") == -1) {
                return null;
            }
            return CompilerTestCompileInterview.this.qAnnoProcOpt;
        }

        public boolean isHidden() {
            boolean bl = CompilerTestCompileInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return this.getSuggestions()[1];
        }
    };
    private StringQuestion qAnnoProcOpt = new StringQuestion(this, "annoProcOpt"){
        {
            this.setSuggestions(new String[]{"", "-A#key=#value", "/A:#key=#value"});
            this.setDefaultValue("-A#key=#value");
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0 || this.value.indexOf("#key") == -1 || this.value.indexOf("#value") == -1) {
                return null;
            }
            return CompilerTestCompileInterview.this.qEnd;
        }

        public boolean isHidden() {
            if (CompilerTestCompileInterview.this.isCompilerAPI()) {
                this.setValue(this.getDefValue());
                return true;
            }
            boolean bl = CompilerTestCompileInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return this.getSuggestions()[1];
        }
    };
    private FileQuestion qCmdAsFile = new FileQuestion(this, "cmdAsFile"){

        protected Question getNext() {
            if (this.value == null || this.value.getPath().length() == 0) {
                return null;
            }
            if (CompilerTestCompileInterview.this.getRootInterview().isErrorCheckingEnabled() && !this.value.isFile()) {
                return ((CompilerTestCompileInterview)CompilerTestCompileInterview.this).parent.qNoFileError;
            }
            return CompilerTestCompileInterview.this.qClassPath;
        }

        public void export(Map map) {
            ServicesInterview servicesInterview = CompilerTestCompileInterview.this.parent.getServicesInterview();
            String string = this.getValue().getPath();
            servicesInterview.exportJavaHome(string, map);
        }
    };
    private StringQuestion qCmdAsString = new StringQuestion(this, "cmdAsString"){

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return CompilerTestCompileInterview.this.qClassPath;
        }

        public void export(Map map) {
            ServicesInterview servicesInterview = CompilerTestCompileInterview.this.parent.getServicesInterview();
            servicesInterview.exportJavaHome(this.getValue(), map);
        }
    };
    static final String CP_ENV = "environment variable";
    static final String CP_OPT = "command line option";
    private ChoiceQuestion qClassPath = new ChoiceQuestion(this, "classpath"){
        {
            this.setChoices(new String[]{null, CompilerTestCompileInterview.CP_ENV, CompilerTestCompileInterview.CP_OPT});
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == CompilerTestCompileInterview.CP_ENV) {
                return CompilerTestCompileInterview.this.qClassPathEnv;
            }
            return CompilerTestCompileInterview.this.qClassPathOpt;
        }

        public boolean isHidden() {
            boolean bl = CompilerTestCompileInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return CompilerTestCompileInterview.CP_OPT;
        }
    };
    private StringQuestion qClassPathEnv = new StringQuestion(this, "classpathEnv"){
        {
            this.setSuggestions(new String[]{"", "CLASSPATH"});
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return CompilerTestCompileInterview.this.qOutSrcDirOpt;
        }
    };
    private StringQuestion qClassPathOpt = new StringQuestion(this, "classpathOpt"){
        {
            this.setSuggestions(new String[]{"", "-classpath #", "/cp:#", "-cp #"});
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0 || this.value.indexOf("#") == -1) {
                return null;
            }
            return CompilerTestCompileInterview.this.qOutSrcDirOpt;
        }

        public boolean isHidden() {
            boolean bl = CompilerTestCompileInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return this.getSuggestions()[1];
        }
    };
    private StringQuestion qOutSrcDirOpt = new StringQuestion(this, "outSrcDirOpt"){
        {
            this.setSuggestions(new String[]{"", "-s #", "/s:#"});
            this.setDefaultValue("-s #");
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0 || this.value.indexOf("#") == -1) {
                return null;
            }
            return CompilerTestCompileInterview.this.qOutDirOpt;
        }

        public boolean isHidden() {
            boolean bl = CompilerTestCompileInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return this.getSuggestions()[1];
        }
    };
    private StringQuestion qOutDirOpt = new StringQuestion(this, "outDirOpt"){
        {
            this.setSuggestions(new String[]{"", "-d #", "/d:#"});
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0 || this.value.indexOf("#") == -1) {
                return null;
            }
            return CompilerTestCompileInterview.this.qOtherEnvVars;
        }

        public boolean isHidden() {
            boolean bl = CompilerTestCompileInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return this.getSuggestions()[1];
        }
    };
    StringQuestion qOtherOpts = new StringQuestion(this, "otherOpts"){

        protected Question getNext() {
            if (CompilerTestCompileInterview.COMPILER_API.equals(CompilerTestCompileInterview.this.qCompilerType.getStringValue()) || !CompilerTestCompileInterview.this.getTestPlatformInterview().isMultiJVM()) {
                return CompilerTestCompileInterview.this.qDefaultCompiler;
            }
            return CompilerTestCompileInterview.this.qAnnoProc;
        }
    };
    StringQuestion qOtherEnvVars = new StringQuestion(this, "otherEnvVars"){

        protected Question getNext() {
            return CompilerTestCompileInterview.this.qOtherOpts;
        }
    };
    private Question qEnd = new FinalQuestion(this);
    private CompilerInterview parent;
    private CompilerAPIMultiJVMInterview iCompilerAPIMultiJVM = new CompilerAPIMultiJVMInterview(this);

    CompilerTestCompileInterview(CompilerInterview compilerInterview) {
        super(compilerInterview, "testCompile");
        this.parent = compilerInterview;
        this.setFirstQuestion(this.qIntro);
        this.iGroupMode = new GroupModeSupport(this);
    }

    JCKParameters getRootInterview() {
        return this.parent == null ? null : this.parent.getRootInterview();
    }

    String getAnnoProc() {
        return this.qAnnoProc.getStringValue();
    }

    protected File getCompilerPathName() {
        return this.qCmdAsFile.getValue();
    }

    public File getJavaHome() {
        if (this.qCmdAsFile.isValueValid()) {
            File file = this.qCmdAsFile.getValue();
            try {
                return file.getParentFile().getParentFile();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return null;
    }

    private String getCmd() {
        TestPlatformInterview testPlatformInterview = this.parent.getTestPlatformInterview();
        if (testPlatformInterview.isLocal()) {
            return this.qCmdAsFile.getValue().getPath();
        }
        return this.qCmdAsString.getValue();
    }

    private static String replaceString(StringBuffer stringBuffer, String string, String string2) {
        int n = 0;
        while ((n = stringBuffer.indexOf(string, n)) != -1) {
            stringBuffer.replace(n, n + string.length(), string2);
        }
        return stringBuffer.toString();
    }

    private static String replaceString(String string, String string2, String string3) {
        return CompilerTestCompileInterview.replaceString(new StringBuffer(string), string2, string3);
    }

    boolean isOtherJVM() {
        TestPlatformInterview testPlatformInterview = this.parent.getTestPlatformInterview();
        return testPlatformInterview.isMultiJVM();
    }

    boolean isCompilerAPI() {
        return !this.isOtherJVM() || COMPILER_API.equals(this.qCompilerType.getStringValue());
    }

    TestPlatformInterview getTestPlatformInterview() {
        return this.parent.getTestPlatformInterview();
    }

    ServicesInterview getServicesInterview() {
        return this.parent.getServicesInterview();
    }

    class CommandBuilder {
        public static final int NORMAL = 1;
        public static final int ANNOPROC_SRC = 2;
        public static final int ANNOPROC_CLS = 3;
        TestPlatformInterview tp;

        CommandBuilder() {
            this.tp = CompilerTestCompileInterview.this.parent.getTestPlatformInterview();
        }

        String getWorkDirectory() {
            return CompilerTestCompileInterview.this.getRootInterview() != null && CompilerTestCompileInterview.this.getRootInterview().getWorkDirectory() != null ? Utils.adjust(CompilerTestCompileInterview.this.getRootInterview().getWorkDirectory().getPath()) : "$workDir";
        }

        boolean isClassPatEnvSelected() {
            return CompilerTestCompileInterview.this.isCompilerAPI() ? CompilerTestCompileInterview.CP_ENV.equals(CompilerTestCompileInterview.this.iCompilerAPIMultiJVM.getClassPath()) : CompilerTestCompileInterview.CP_ENV.equals(CompilerTestCompileInterview.this.qClassPath.getValue());
        }

        String getClassPathEnv() {
            return CompilerTestCompileInterview.this.isCompilerAPI() ? CompilerTestCompileInterview.this.iCompilerAPIMultiJVM.getClassPathEnv() : CompilerTestCompileInterview.this.qClassPathEnv.getStringValue();
        }

        String getCmdToExecute() {
            return CompilerTestCompileInterview.this.isCompilerAPI() ? CompilerTestCompileInterview.this.iCompilerAPIMultiJVM.getCmd() : CompilerTestCompileInterview.this.getCmd();
        }

        String getAnnoProc() {
            return CompilerTestCompileInterview.this.isCompilerAPI() ? "-processor #" : CompilerTestCompileInterview.this.qAnnoProc.getStringValue();
        }

        String getOutSrcDirOpt() {
            return CompilerTestCompileInterview.this.isCompilerAPI() ? "-s #" : CompilerTestCompileInterview.this.qOutSrcDirOpt.getStringValue();
        }

        String getOutDirOpt() {
            return CompilerTestCompileInterview.this.isCompilerAPI() ? "-d #" : CompilerTestCompileInterview.this.qOutDirOpt.getStringValue();
        }

        String getOtherEnvVars() {
            return CompilerTestCompileInterview.this.isCompilerAPI() ? CompilerTestCompileInterview.this.iCompilerAPIMultiJVM.getOtherEnvVars() : CompilerTestCompileInterview.this.qOtherEnvVars.getStringValue();
        }

        String getCompilerOpts() {
            return CompilerTestCompileInterview.this.qOtherOpts.getStringValue();
        }

        String getOtherOpts() {
            return CompilerTestCompileInterview.this.isOtherJVM() && CompilerTestCompileInterview.this.isCompilerAPI() ? CompilerTestCompileInterview.this.iCompilerAPIMultiJVM.getOtherOpts() : this.getCompilerOpts();
        }

        String getClassPathOpt() {
            return CompilerTestCompileInterview.this.isCompilerAPI() ? CompilerTestCompileInterview.this.iCompilerAPIMultiJVM.getClassPathOpt() : CompilerTestCompileInterview.this.qClassPathOpt.getStringValue();
        }

        boolean isDefaultCompilerSelected() {
            return "Yes".equals(CompilerTestCompileInterview.this.qDefaultCompiler.getStringValue());
        }

        String getClassOutDir() {
            char c = this.tp.getFileSep();
            String string = this.getWorkDirectory() + c + "classes";
            return string.replace(File.separatorChar, c);
        }

        String makeCommand(int n, boolean bl) {
            char c = this.tp.getFileSep();
            char c2 = this.tp.getPathSep();
            String string = this.getClassOutDir();
            if (n == 3) {
                string = "${testSuiteRootDir:MAP FS=" + c + "}" + c + "lib" + c + "ap" + c + "classes.jar";
            }
            String string2 = "${testSuiteRootDir:MAP FS=" + c + "}";
            String string3 = string2 + c + "lib" + c + "javatest.jar";
            String string4 = string + c2 + string2 + c + "classes" + c2 + string3;
            StringBuffer stringBuffer = new StringBuffer();
            String string5 = CompilerTestCompileInterview.this.qAnnoProcOpt.getStringValue();
            String string6 = CompilerTestCompileInterview.replaceString(string5, "#key", "jckTestWorkDir");
            string6 = CompilerTestCompileInterview.replaceString(string6, "#value", "$testWorkDirURL");
            String string7 = CompilerTestCompileInterview.replaceString(string5, "#key", "jckApArgs");
            string7 = CompilerTestCompileInterview.replaceString(string7, "#value", "$apArgs");
            if (this.tp.isUseAgent()) {
                CompilerTestCompileInterview.this.parent.appendAgentCommandPrefix(stringBuffer);
            }
            if (CompilerTestCompileInterview.this.isOtherJVM()) {
                if (bl) {
                    CompilerTestCompileInterview.this.iGroupMode.appendArguments(stringBuffer);
                } else {
                    stringBuffer.append("com.sun.javatest.lib.ProcessCommand ");
                }
                int n2 = stringBuffer.length();
                if (this.isClassPatEnvSelected()) {
                    stringBuffer.append(this.getClassPathEnv());
                    stringBuffer.append('=');
                    stringBuffer.append(string4);
                    stringBuffer.append(' ');
                }
                if (this.getOtherEnvVars() != null && this.getOtherEnvVars().length() > 0) {
                    stringBuffer.append(this.getOtherEnvVars());
                    stringBuffer.append(' ');
                }
                if (bl) {
                    if (n2 < stringBuffer.length()) {
                        stringBuffer.insert(n2, "-MENV_ ");
                    }
                    stringBuffer.append("-MCMD_ ");
                }
                stringBuffer.append(Utils.adjust(this.getCmdToExecute()));
                stringBuffer.append(' ');
                if (this.getOtherOpts() != null && this.getOtherOpts().length() > 0) {
                    stringBuffer.append(this.getOtherOpts());
                    stringBuffer.append(' ');
                }
                if (!this.isClassPatEnvSelected()) {
                    stringBuffer.append(Utils.evalTemplate(this.getClassPathOpt(), string4));
                    stringBuffer.append(' ');
                }
                if (bl) {
                    stringBuffer.append("-MTEST_ ");
                }
            }
            if (CompilerTestCompileInterview.this.isCompilerAPI()) {
                if (this.tp.isUseAgent() || bl) {
                    stringBuffer.append("com.sun.jck.lib.SharedCompilerAPICmd");
                } else {
                    stringBuffer.append("com.sun.jck.lib.CompilerAPICommand");
                }
                stringBuffer.append(' ');
                stringBuffer.append("-cp " + string4);
                stringBuffer.append(' ');
                if (this.getCompilerOpts() != null && this.getCompilerOpts().length() > 0) {
                    stringBuffer.append("-optStart " + this.getCompilerOpts() + " -optEnd");
                    stringBuffer.append(' ');
                }
                String string8 = CompilerTestCompileInterview.this.qCompilerClass.getStringValue();
                if (!this.isDefaultCompilerSelected()) {
                    stringBuffer.append("-class " + string8);
                    stringBuffer.append(' ');
                }
            }
            stringBuffer.append(Utils.evalTemplate(this.getOutDirOpt(), this.getClassOutDir()));
            stringBuffer.append(' ');
            if (n == 2 || n == 3) {
                stringBuffer.append(Utils.evalTemplate(this.getAnnoProc(), "$apClass"));
                stringBuffer.append(' ');
                stringBuffer.append(string6);
                stringBuffer.append(' ');
                stringBuffer.append(string7);
                stringBuffer.append(' ');
                stringBuffer.append(Utils.evalTemplate(this.getOutSrcDirOpt(), "$testWorkDir"));
                stringBuffer.append(' ');
            }
            if (n == 3) {
                if (CompilerTestCompileInterview.this.isCompilerAPI()) {
                    stringBuffer.append("-inputClassMode");
                    stringBuffer.append(' ');
                }
                stringBuffer.append("$testClassSource");
            } else {
                stringBuffer.append("$testSource");
            }
            return stringBuffer.toString();
        }
    }
}

