/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jacc.ejb.mr;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.tests.ejb30.common.helper.Helper;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.annotation.security.PermitAll;
import javax.annotation.security.DenyAll;
import javax.annotation.Resource;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.SessionContext;
import javax.ejb.EJBs;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.Remote;

@Stateless(name="TargetBean")
//@Remote({Target.class})
@DeclareRoles({"Administrator", "Manager", "Employee"})

public class TargetBean implements Target {
    
    private SessionContext sctx ;
    private Logger logger=Helper.getLogger();
    
    @RolesAllowed({"Administrator", "Manager", "Employee"})
    @TransactionAttribute(TransactionAttributeType.REQUIRED)
    public void initLogging(java.util.Properties p) {
    }
    
    @TransactionAttribute(TransactionAttributeType.REQUIRED)
    public boolean IsCaller(String caller) {
        if ( sctx.getCallerPrincipal().getName().indexOf(caller) < 0)
            return false;
        else
            return true;
    }
    
    @RolesAllowed({"Administrator"})
    @TransactionAttribute(TransactionAttributeType.REQUIRED)
    public boolean EjbNotAuthz() {
        return true;
    }
    
    @RolesAllowed({"Administrator", "Manager", "Employee"})
    @TransactionAttribute(TransactionAttributeType.REQUIRED)
    public boolean EjbIsAuthz() {
        return true;
    }
    
    @RolesAllowed({"Manager", "Employee"})
    @TransactionAttribute(TransactionAttributeType.REQUIRED)
    public boolean EjbSecRoleRef(String role) {
        return  sctx.isCallerInRole(role);
    }
    
    @PermitAll
    public boolean uncheckedTest() {
        return true;
    }
    
    @DenyAll
    @TransactionAttribute(TransactionAttributeType.REQUIRED)
            public boolean excludeTest() {
        return true;
    }
    
    @Resource
    public void setSessionContext(SessionContext sc)  {
        sctx = sc;
    }
}

