/*
 * Copyright (c) 2008, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*
 * $Id: NumberEnum.java 62595 2011-04-20 20:38:55Z kgrucci $
 */
package com.sun.ts.tests.ejb30.common.lite;

import java.util.EnumSet;

public enum NumberEnum implements NumberIF {

    ZERO(0),
    ONE(1),
    TWO(2),
    THREE(3),
    FOUR(4),
    FIVE(5),
    OTHERS(6);
    
    private int number;
    
    private NumberEnum(int n) {
        number = n;
    }

    public int getNumber() {
        return number;
    }
    
    public static NumberEnum getEnumFor(int n) {
        for(NumberEnum e : EnumSet.allOf(NumberEnum.class)) {
            if(e.number == n) {
                return e;
            }
        }
	return OTHERS;
    }
    
    public int add(int toAdd) {
        return toAdd + number;
    }

    public NumberIF add(NumberIF toAdd) {
	return getEnumFor(toAdd.add(number));
    }
}
