/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*
 * $Id: TestBeanBase.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.busiface;


abstract public class TestBeanBase implements TestIF {
    abstract protected BusinessLocalIF1 getLocalBean1();

    abstract protected BusinessLocalIF2 getLocalBean2();

    // not to use abstract since this class is extended by multiple test
    // directories that
    // may not have this kind of tests. Test directories that support these
    // tests should
    // override the two methods to return a meaningful value.
    protected AnnotatedLocalBusinessInterface1 getAnnotatedLocalInterfaceBean1() {
        return null;
    }

    protected AnnotatedLocalBusinessInterface2 getAnnotatedLocalInterfaceBean2() {
        return null;
    }

    abstract protected BusinessLocalIF1 getSerializableLocalBean();

    abstract protected BusinessLocalIF1 getExternalizableLocalBean();

    abstract protected BusinessLocalIF1 getTimedObjectLocalBean();

    abstract protected BusinessLocalIF1 getSessionSynchronizationLocalBean();

    abstract protected BusinessLocalIF1 getSessionBeanLocalBean();

    public String[] multipleInterfacesLocalTest2(String[] s) {
        final BusinessLocalIF2 b = getLocalBean2();
        final String[] result = b.businessMethodLocal2(s);
        b.remove();
        return result;
    }

    public String[] multipleInterfacesLocalTest1(String[] s) {
        final BusinessLocalIF1 b = getLocalBean1();
        final String[] result = b.businessMethodLocal1(s);
        b.remove();
        return result;
    }

    public String[] multipleAnnotatedInterfacesLocalTest2(String[] s) {
        final AnnotatedLocalBusinessInterface2 b = getAnnotatedLocalInterfaceBean2();
        final String[] result = b.businessMethodLocal1(s);
        b.remove();
        return result;
    }

    public String[] multipleAnnotatedInterfacesLocalTest1(String[] s) {
        final AnnotatedLocalBusinessInterface1 b = getAnnotatedLocalInterfaceBean1();
        final String[] result = b.businessMethodLocal1(s);
        b.remove();
        return result;
    }

    public String[] singleInterfaceLocalExternalizableTest(String[] s) {
        final BusinessLocalIF1 b = getExternalizableLocalBean();
        final String[] result = b.businessMethodLocal1(s);
        b.remove();
        return result;
    }

    public String[] singleInterfaceLocalSerializableTest(String[] s) {
        final BusinessLocalIF1 b = getSerializableLocalBean();
        final String[] result = b.businessMethodLocal1(s);
        b.remove();
        return result;
    }

    public String[] singleInterfaceLocalSessionBeanTest(String[] s) {
        final BusinessLocalIF1 b = getSessionBeanLocalBean();
        final String[] result = b.businessMethodLocal1(s);
        b.remove();
        return result;
    }

    // slsb only
    public String[] singleInterfaceLocalTimedObjectTest(String[] s) {
        final BusinessLocalIF1 b = getTimedObjectLocalBean();
        final String[] result = b.businessMethodLocal1(s);
        // no need to call remove, since it's for slsb only
        // b.remove();
        return result;

    }

    // sfsb only
    public String[] singleInterfaceLocalSessionSynchronizationTest(String[] s) {
        final BusinessLocalIF1 b = getSessionSynchronizationLocalBean();
        final String[] result = b.businessMethodLocal1(s);
        b.remove();
        return result;
    }

    // this method should be overridden by stateful bean with @Remove
    public void remove() {
    }

}
