/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*
 * $Id: StatefulCancelInterceptor.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.allowed.stateful;

import com.sun.ts.tests.ejb30.common.allowed.CancelInterceptor;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import javax.ejb.SessionContext;
import javax.interceptor.AroundInvoke;


public class StatefulCancelInterceptor extends CancelInterceptor {
    private static StatefulCancelInterceptor instance = 
            new StatefulCancelInterceptor();

    public StatefulCancelInterceptor() {
        super();
    }
    
    public static StatefulCancelInterceptor getInstance() {
        return instance;
    }
    
    @Override
    public void cancelTimers(SessionContext sctx) {
        TimerLocalIF timerBean = StatefulOperations.getInstance().getTimerBean();
        timerBean.findAndCancelTimer();
    }

    //@todo this interceptor method is not called since it overrides the one
    //in superclass.  Make sure this is what we want.
    @Override
    @AroundInvoke
    public Object intercept(javax.interceptor.InvocationContext inv) throws Exception {

        Object retValue;
        
        retValue = super.intercept(inv);
        return retValue;
    }
}
