/*
 * Copyright (c) 2007, 2009 Oracle and/or its affiliates. All rights reserved.
 * ORACLE/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: WSEJBVehicleRunner.java 62547 2011-04-15 17:05:00Z af70133 $
 */

package com.sun.ts.tests.common.vehicle.wsejb;

import java.io.*;
import java.util.*;
import javax.ejb.*;
import com.sun.ts.lib.harness.*;
import com.sun.javatest.*;
import com.sun.ts.lib.util.*;
import com.sun.ts.tests.common.vehicle.*;


public class WSEJBVehicleRunner implements VehicleRunnable {
    public Status run(String[] argv, Properties p) {
        String sVehicle = p.getProperty("vehicle");
        Status sTestStatus = Status.passed("");

        WSEJBVehicleHome home = null;
        String sEJBVehicleJndiName = "";
        WSEJBVehicleRemote ref = null;
        try {
            TSNamingContext jc= new TSNamingContext();
            sEJBVehicleJndiName = "java:comp/env/ejb/WSEJBVehicle";
            home = (WSEJBVehicleHome)jc.lookup(sEJBVehicleJndiName,
                 WSEJBVehicleHome.class);
            ref = (WSEJBVehicleRemote)home.create(argv, p);
            TestUtil.logTrace("in wsejbvehicle: home.create() ok; call runTest()");
            sTestStatus = (ref.runTest()).toStatus();
        } catch(Exception e) {
            TestUtil.logErr("Test failed", e);
            sTestStatus = Status.failed("Test run in wsejb vehicle failed");
        }
        finally
        {
            if(ref != null)
            {
                try
                {
                    ref.remove();
                }
                catch(Exception e2)
                {
                    TestUtil.logHarnessDebug("Exception while trying to remove the EJB Vehicle bean.");   
                }
            }
        }
        return sTestStatus;
    }
}

