/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.discriminatorValue;

import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name="PRODUCT_TABLE")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="PRODUCT_TYPE", discriminatorType=DiscriminatorType.STRING)
public class Product
implements Serializable {
    private String id;
    private String name;
    private int quantity;

    public Product() {
    }

    public Product(String id, String name, int quantity) {
        this.id = id;
        this.name = name;
        this.quantity = quantity;
    }

    @Id
    @Column(name="ID")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Column(name="NAME")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="QUANTITY")
    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int v) {
        this.quantity = v;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + this.getId());
        if (this.getName() != null) {
            result.append(", name: " + this.getName());
        } else {
            result.append(", name: null");
        }
        result.append(", quantity: " + this.getQuantity());
        result.append("]");
        return result.toString();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (!(o instanceof Product)) {
            return result;
        }
        Product other = (Product)o;
        if (this.getId().equals(other.getId()) && this.getName().equals(other.getName()) && this.getQuantity() == other.getQuantity()) {
            result = true;
        }
        return result;
    }
}

