/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.prepStmt.prepStmt3;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.csSchema;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import javax.sql.DataSource;

public class prepStmtClient3
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.prepStmt.prepStmt3";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private ResultSet rs = null;
    private Statement stmt = null;
    private DataSource ds1 = null;
    private PreparedStatement pstmt = null;
    private dbSchema dbSch = null;
    private rsSchema rsSch = null;
    private csSchema csSch = null;
    private String drManager = null;
    private transient DatabaseMetaData dbmd = null;
    private Properties sqlp = null;
    private Properties props = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        prepStmtClient3 theTests = new prepStmtClient3();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new EETest.Fault("Invalid DriverManager Name");
                }
                this.sqlp = p;
                this.props = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.stmt = this.conn.createStatement();
                this.rsSch = new rsSchema();
                this.csSch = new csSchema();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetString01() throws EETest.Fault {
        String maxStringVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Char_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Value of String to be Updated");
            maxStringVal = this.rsSch.extractVal("Char_Tab", 1, this.sqlp, this.conn);
            maxStringVal = maxStringVal.substring(1, maxStringVal.length() - 1);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setString(1, maxStringVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Char_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = this.rs.getString(1);
            rStringVal = rStringVal.trim();
            maxStringVal = maxStringVal.trim();
            this.msg.addOutputMsg(maxStringVal, rStringVal);
            if (rStringVal.equals(maxStringVal)) {
                this.msg.setMsg("setString Method sets the designated parameter to a String value ");
            } else {
                this.msg.printTestError("set String Method does not set the designated parameter to a String value ", "Call to setString is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setString is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setString Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetTime01() throws EETest.Fault {
        Time brkTimeVal = null;
        Time rTimeVal = null;
        String sbrkTimeVal = null;
        try {
            this.rsSch.createTab("Time_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Time_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Value of Break_Time to be Updated ");
            sbrkTimeVal = this.rsSch.extractVal("Time_Tab", 1, this.sqlp, this.conn);
            sbrkTimeVal = sbrkTimeVal.substring(sbrkTimeVal.indexOf(39) + 1, sbrkTimeVal.lastIndexOf(39));
            sbrkTimeVal = sbrkTimeVal.trim();
            brkTimeVal = Time.valueOf(sbrkTimeVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setTime(1, brkTimeVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Time_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rTimeVal = this.rs.getTime(1);
            this.msg.addOutputMsg("" + brkTimeVal, "" + rTimeVal);
            if (rTimeVal.equals(brkTimeVal)) {
                this.msg.setMsg("setTime Method sets the designated parameter to a Time value ");
            } else {
                this.msg.printTestError("setTime Method does not set the designated parameter to a Time value ", "Call to setTime is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setTime is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setTime is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Time_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetTime02() throws EETest.Fault {
        Time brkTimeVal = null;
        Time rTimeVal = null;
        String sbrkTimeVal = null;
        Calendar cal = null;
        try {
            this.rsSch.createTab("Time_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Time_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Value of Break_Time to be updated");
            sbrkTimeVal = this.rsSch.extractVal("Time_Tab", 1, this.sqlp, this.conn);
            sbrkTimeVal = sbrkTimeVal.substring(sbrkTimeVal.indexOf(39) + 1, sbrkTimeVal.lastIndexOf(39));
            sbrkTimeVal = sbrkTimeVal.trim();
            brkTimeVal = Time.valueOf(sbrkTimeVal);
            cal = Calendar.getInstance();
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setTime(1, brkTimeVal, cal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Time_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rTimeVal = this.rs.getTime(1, cal);
            this.msg.addOutputMsg("" + brkTimeVal, "" + rTimeVal);
            if (rTimeVal.toString().trim().equals(brkTimeVal.toString().trim())) {
                this.msg.setMsg("setTime Method sets the designated parameter to a Time value ");
            } else {
                this.msg.printTestError("setTime Method does not set the designated parameter to a Time value ", "Call to setTime is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setTime is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setTime is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Time_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetTimestamp01() throws EETest.Fault {
        Timestamp inTimeVal = null;
        Timestamp rTimestampVal = null;
        String sinTimeVal = null;
        try {
            this.rsSch.createTab("Timestamp_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Timestamp_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Value of InTime to be updated");
            sinTimeVal = this.rsSch.extractVal("Timestamp_Tab", 1, this.sqlp, this.conn);
            sinTimeVal = sinTimeVal.substring(sinTimeVal.indexOf(39) + 1, sinTimeVal.lastIndexOf(39));
            inTimeVal = Timestamp.valueOf(sinTimeVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setTimestamp(1, inTimeVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Timestamp_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rTimestampVal = this.rs.getTimestamp(1);
            this.msg.addOutputMsg("" + inTimeVal, "" + rTimestampVal);
            if (rTimestampVal.equals(inTimeVal)) {
                this.msg.setMsg("setTimestamp Method sets the designated parameter to a Timestamp value ");
            } else {
                this.msg.printTestError("setTimestamp Method does not set the designated parameter to a Timestamp value ", "Call to setTimestamp is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setTimestamp is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setTimestamp is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Timestamp_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetTimestamp02() throws EETest.Fault {
        Timestamp inTimeVal = null;
        Timestamp rTimestampVal = null;
        String sinTimeVal = null;
        Calendar cal = null;
        try {
            this.rsSch.createTab("Timestamp_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Timestamp_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Value of InTime to be Updated ");
            sinTimeVal = this.rsSch.extractVal("Timestamp_Tab", 1, this.sqlp, this.conn);
            sinTimeVal = sinTimeVal.substring(sinTimeVal.indexOf(39) + 1, sinTimeVal.lastIndexOf(39));
            inTimeVal = Timestamp.valueOf(sinTimeVal);
            cal = Calendar.getInstance();
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setTimestamp(1, inTimeVal, cal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Timestamp_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rTimestampVal = this.rs.getTimestamp(1, cal);
            this.msg.addOutputMsg("" + inTimeVal, "" + rTimestampVal);
            if (rTimestampVal.equals(inTimeVal)) {
                this.msg.setMsg("setTimestamp Method sets the designated parameter to a Timestamp value ");
            } else {
                this.msg.printTestError("setTimestamp Method does not set the designated parameter to a Timestamp value ", "Call to setTimestamp is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setTimestamp is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setTimestamp is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Timestamp_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetString02() throws EETest.Fault {
        String maxStringVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Varchar_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Value of String to be Updated ");
            maxStringVal = this.rsSch.extractVal("Varchar_Tab", 1, this.sqlp, this.conn);
            maxStringVal = maxStringVal.substring(1, maxStringVal.length() - 1);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setString(1, maxStringVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Varchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = this.rs.getString(1);
            rStringVal = rStringVal.trim();
            maxStringVal = maxStringVal.trim();
            this.msg.addOutputMsg(maxStringVal, rStringVal);
            if (rStringVal.equals(maxStringVal)) {
                this.msg.setMsg("setString Method sets the designated parameter to a String value ");
            } else {
                this.msg.printTestError("setString Method does not set the designated parameter to a String value ", "Call to setString is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setString is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setString is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetFloat01() throws EETest.Fault {
        float rFloatVal = 0.0f;
        float minFloatVal = 0.0f;
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Real_Tab_Max_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Value of Minimum value to be Updated");
            String sminFloatVal = this.rsSch.extractVal("Real_Tab", 2, this.sqlp, this.conn);
            minFloatVal = Float.parseFloat(sminFloatVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setFloat(1, minFloatVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Max_Val_Query = this.sqlp.getProperty("Real_Query_Max", "");
            this.msg.setMsg(Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            rFloatVal = this.rs.getFloat(1);
            this.msg.addOutputMsg("" + minFloatVal, "" + rFloatVal);
            if (rFloatVal == minFloatVal) {
                this.msg.setMsg("setFloat Method sets the designated parameter to a Float value ");
            } else {
                this.msg.printTestError("setFloat Method does not set the designated parameter to a Float value ", "Call to setFloat is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setFloat is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setFloat is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetFloat02() throws EETest.Fault {
        float maxFloatVal = 0.0f;
        float rFloatVal = 0.0f;
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Real_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Value of Maximum value to be Updated ");
            String smaxFloatVal = this.rsSch.extractVal("Real_Tab", 1, this.sqlp, this.conn);
            maxFloatVal = Float.parseFloat(smaxFloatVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setFloat(1, maxFloatVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Real_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rFloatVal = this.rs.getFloat(1);
            this.msg.addOutputMsg("" + maxFloatVal, "" + rFloatVal);
            if (rFloatVal == maxFloatVal) {
                this.msg.setMsg("setFloat Method sets the designated parameter to a Float value ");
            } else {
                this.msg.printTestError("setFloat Method does not set the designated parameter to a Float value ", "Call to setFloat is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setFloat is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setFloat is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetBytes01() throws EETest.Fault {
        String binarySize = null;
        try {
            binarySize = this.props.getProperty("binarySize");
            this.rsSch.createTab("Binary_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Binary_Tab_Val_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            int bytearrsize = Integer.parseInt(binarySize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setBytes(1, bytearr);
            this.pstmt.executeUpdate();
            String Binary_Val_Query = this.sqlp.getProperty("Binary_Query_Val", "");
            this.msg.setMsg("Query String: " + Binary_Val_Query);
            this.rs = this.stmt.executeQuery(Binary_Val_Query);
            this.rs.next();
            byte[] oRetVal = this.rs.getBytes(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(oRetVal[i]));
                if (oRetVal[i] == bytearr[i]) continue;
                this.msg.printTestError("setBytes did not set the proper byte array values", "Call to setBytes Failed!");
            }
            this.msg.setMsg("setBytes sets the proper byte array values");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setBytes is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setBytes is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                this.rsSch.dropTab("Binary_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetBytes02() throws EETest.Fault {
        String varbinarySize = null;
        try {
            this.rsSch.createTab("Varbinary_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Varbinary_Tab_Val_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            varbinarySize = this.props.getProperty("varbinarySize");
            int bytearrsize = Integer.parseInt(varbinarySize);
            this.msg.setMsg("Varbinary Size: " + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setBytes(1, bytearr);
            this.pstmt.executeUpdate();
            String Varbinary_Val_Query = this.sqlp.getProperty("Varbinary_Query_Val", "");
            this.msg.setMsg("Query String: " + Varbinary_Val_Query);
            this.rs = this.stmt.executeQuery(Varbinary_Val_Query);
            this.rs.next();
            byte[] oRetVal = this.rs.getBytes(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(oRetVal[i]));
                if (oRetVal[i] == bytearr[i]) continue;
                this.msg.printTestError("setBytes did not set the proper byte array values", "Call to setBytes is Failed!");
            }
            this.msg.setMsg("setBytes sets the proper byte array values");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setBytes is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setBytes is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                this.rsSch.dropTab("Varbinary_Tab", this.conn);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.msg.setMsg("Exception in finally block" + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetBytes03() throws EETest.Fault {
        byte[] retByteArr = null;
        try {
            this.rsSch.createTab("Longvarbinary_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Longvarbinary_Tab_Val_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            String binsize = this.props.getProperty("longvarbinarySize");
            int bytearrsize = Integer.parseInt(binsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setBytes(1, bytearr);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Longvarbinary_Val_Query = this.sqlp.getProperty("Longvarbinary_Query_Val", "");
            this.msg.setMsg(Longvarbinary_Val_Query);
            this.rs = this.stmt.executeQuery(Longvarbinary_Val_Query);
            this.rs.next();
            retByteArr = this.rs.getBytes(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(retByteArr[i]));
                if (retByteArr[i] == bytearr[i]) continue;
                this.msg.printTestError("setBytes Method does not set the designated parameter to a byte array", "Call to setBytes is Failed!");
            }
            this.msg.setMsg("setBytes Method sets the designated parameter to a Byte Array Value");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setBytes is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setBytes is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Longvarbinary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject01() throws EETest.Fault {
        String maxStringVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Char_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Value of String to be Updated ");
            maxStringVal = this.rsSch.extractVal("Char_Tab", 1, this.sqlp, this.conn);
            maxStringVal = maxStringVal.substring(1, maxStringVal.length() - 1);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, maxStringVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Char_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = this.rs.getObject(1).toString();
            rStringVal = rStringVal.trim();
            maxStringVal = maxStringVal.trim();
            this.msg.addOutputMsg(maxStringVal, rStringVal);
            if (rStringVal.equals(maxStringVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "Call to setObject is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject02() throws EETest.Fault {
        String maxStringVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Varchar_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Value of String to be Updated");
            maxStringVal = this.rsSch.extractVal("Varchar_Tab", 1, this.sqlp, this.conn);
            maxStringVal = maxStringVal.substring(1, maxStringVal.length() - 1);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, maxStringVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Varchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = this.rs.getObject(1).toString();
            rStringVal = rStringVal.trim();
            maxStringVal = maxStringVal.trim();
            this.msg.addOutputMsg(maxStringVal, rStringVal);
            if (rStringVal.equals(maxStringVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "Call to setObject is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject03() throws EETest.Fault {
        String maxStringVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Longvarcharnull_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Longvarchar_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Value of String to be Updated");
            maxStringVal = this.rsSch.extractVal("Longvarcharnull_Tab", 1, this.sqlp, this.conn);
            maxStringVal = maxStringVal.substring(1, maxStringVal.length() - 1);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, maxStringVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Longvarchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = this.rs.getObject(1).toString();
            rStringVal = rStringVal.trim();
            maxStringVal = maxStringVal.trim();
            this.msg.addOutputMsg(maxStringVal, rStringVal);
            if (rStringVal.equals(maxStringVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "Call to setObject is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Longvarcharnull_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject04() throws EETest.Fault {
        BigDecimal maxBigDecimalVal = null;
        BigDecimal rBigDecimalVal = null;
        String smaxBigDecimalVal = null;
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Numeric_Tab_Min_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Maximum Value of BigDecimal to be Updated");
            smaxBigDecimalVal = this.rsSch.extractVal("Numeric_Tab", 1, this.sqlp, this.conn);
            maxBigDecimalVal = new BigDecimal(smaxBigDecimalVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, maxBigDecimalVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Numeric_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            rBigDecimalVal = (BigDecimal)this.rs.getObject(1);
            this.msg.addOutputMsg("" + maxBigDecimalVal, "" + rBigDecimalVal);
            if (rBigDecimalVal.compareTo(maxBigDecimalVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "Call to setObject is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject05() throws EETest.Fault {
        BigDecimal minBigDecimalVal = null;
        BigDecimal rBigDecimalVal = null;
        String sminBigDecimalVal = null;
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Numeric_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Maximum Value of BigDecimal to be Updated");
            sminBigDecimalVal = this.rsSch.extractVal("Numeric_Tab", 2, this.sqlp, this.conn);
            minBigDecimalVal = new BigDecimal(sminBigDecimalVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, minBigDecimalVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Numeric_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rBigDecimalVal = (BigDecimal)this.rs.getObject(1);
            this.msg.addOutputMsg("" + minBigDecimalVal, "" + rBigDecimalVal);
            if (rBigDecimalVal.compareTo(minBigDecimalVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "Call to setObject is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject06() throws EETest.Fault {
        BigDecimal maxBigDecimalVal = null;
        BigDecimal rBigDecimalVal = null;
        String smaxBigDecimalVal = null;
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Decimal_Tab_Min_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Maximum Value of BigDecimal to be Updated ");
            smaxBigDecimalVal = this.rsSch.extractVal("Decimal_Tab", 1, this.sqlp, this.conn);
            maxBigDecimalVal = new BigDecimal(smaxBigDecimalVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, maxBigDecimalVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Decimal_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            rBigDecimalVal = (BigDecimal)this.rs.getObject(1);
            this.msg.addOutputMsg("" + maxBigDecimalVal, "" + rBigDecimalVal);
            if (rBigDecimalVal.compareTo(maxBigDecimalVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "Call to setObject is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject07() throws EETest.Fault {
        BigDecimal minBigDecimalVal = null;
        BigDecimal rBigDecimalVal = null;
        String sminBigDecimalVal = null;
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Decimal_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Maximum Value of BigDecimal to be Updated ");
            sminBigDecimalVal = this.rsSch.extractVal("Decimal_Tab", 2, this.sqlp, this.conn);
            minBigDecimalVal = new BigDecimal(sminBigDecimalVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, minBigDecimalVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Decimal_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rBigDecimalVal = (BigDecimal)this.rs.getObject(1);
            this.msg.addOutputMsg("" + minBigDecimalVal, "" + rBigDecimalVal);
            if (rBigDecimalVal.compareTo(minBigDecimalVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "Call to setObject is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject08() throws EETest.Fault {
        Boolean maxBooleanVal = null;
        Boolean rBooleanVal = null;
        try {
            this.rsSch.createTab("Bit_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Bit_Tab_Min_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt + "to extract the Maximum Value of Boolean to be Updated");
            maxBooleanVal = this.rsSch.extractValAsBoolObj("Bit_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, maxBooleanVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Bit_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            rBooleanVal = this.rs.getBoolean(1);
            this.msg.addOutputMsg("" + maxBooleanVal, "" + rBooleanVal);
            if (rBooleanVal.equals(maxBooleanVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "Call to setObject is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Bit_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject09() throws EETest.Fault {
        Boolean minBooleanVal = null;
        Boolean rBooleanVal = null;
        try {
            this.rsSch.createTab("Bit_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Bit_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt + " to extract the Minimum Value of Boolean to be Updated");
            minBooleanVal = this.rsSch.extractValAsBoolObj("Bit_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, minBooleanVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Bit_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rBooleanVal = this.rs.getBoolean(1);
            this.msg.addOutputMsg("" + minBooleanVal, "" + rBooleanVal);
            if (rBooleanVal.equals(minBooleanVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "Call to setObject is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Bit_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            if (this.pstmt != null) {
                this.pstmt.close();
                this.pstmt = null;
            }
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

