/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.override.manytomany;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.override.manytomany.Course;
import com.sun.ts.tests.jpa.core.override.manytomany.Student;
import java.util.HashSet;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final Integer COURSE1_ID = 203;
    private static final String COURSE1_NAME = "Math";
    private static final Integer COURSE2_ID = 275;
    private static final String COURSE2_NAME = "Science";
    private static final Integer STUDENT1_ID = 12345;
    private static final String STUDENT1_NAME = "Scott";
    private static final Integer STUDENT2_ID = 67890;
    private static final String STUDENT2_NAME = "Jonathan";
    private static final Integer STUDENT3_ID = 24680;
    private static final String STUDENT3_NAME = "Eliot";

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception:test failed ", (Throwable)e);
        }
    }

    public void testNoManyToManyAnnotation() throws EETest.Fault {
        this.getEntityTransaction().begin();
        Course mathCourse = this.createCourse(COURSE1_ID, COURSE1_NAME);
        Course scienceCourse = this.createCourse(COURSE2_ID, COURSE2_NAME);
        Student student1 = this.createStudent(STUDENT1_ID, STUDENT1_NAME);
        student1.addCourse(mathCourse);
        student1.addCourse(scienceCourse);
        Student student2 = this.createStudent(STUDENT2_ID, STUDENT2_NAME);
        student2.addCourse(mathCourse);
        Student student3 = this.createStudent(STUDENT3_ID, STUDENT3_NAME);
        student3.addCourse(scienceCourse);
        HashSet<Student> mathStudents = new HashSet<Student>();
        mathStudents.add(student1);
        mathStudents.add(student2);
        HashSet<Student> scienceStudents = new HashSet<Student>();
        scienceStudents.add(student3);
        scienceStudents.add(student1);
        mathCourse.setStudents(mathStudents);
        scienceCourse.setStudents(scienceStudents);
        this.getEntityManager().persist((Object)mathCourse);
        this.getEntityManager().persist((Object)scienceCourse);
        this.getEntityManager().persist((Object)student1);
        this.getEntityManager().persist((Object)student2);
        this.getEntityManager().persist((Object)student3);
        this.getEntityManager().flush();
        try {
            Course retrieveMath = (Course)this.getEntityManager().find(Course.class, (Object)COURSE1_ID);
            Course retrieveScience = (Course)this.getEntityManager().find(Course.class, (Object)COURSE2_ID);
            if (retrieveMath.getStudents().size() != 2 || retrieveScience.getStudents().size() != 2) {
                throw new EETest.Fault("Expected many to many relationship between course and student to have been set. Expected 2 students in Math and 2 in Science, Actual - " + retrieveMath.getStudents().size() + " - " + retrieveScience.getStudents().size());
            }
            TestUtil.logTrace((String)"Test Passed");
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            throw new EETest.Fault("Exception thrown while testing testNoManyToManyAnnotation" + e);
        }
    }

    private Student createStudent(int id, String name) {
        Student student = new Student();
        student.setId(Integer.valueOf(id));
        student.setName(name);
        return student;
    }

    private Course createCourse(int id, String courseName) {
        Course course = new Course();
        course.setId(Integer.valueOf(id));
        course.setName(courseName);
        return course;
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM COURSE_2").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM STUDENT_2").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

