/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.lib;

import com.sun.javatest.Script;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import java.io.File;
import java.io.PrintWriter;

public class APIScript
extends Script {
    private static final String TEST_COMPILE = "testCompile";
    private static final String TEST_EXECUTE = "testExecute";
    private String precompileClassDir;
    private static final String UNRECOGNIZED_ARG = "Unrecognized argument for script: ";

    @Override
    public Status run(String[] args, TestDescription td, TestEnvironment env) {
        Status compileStatus;
        PrintWriter trOut = this.getTestResult().getTestCommentWriter();
        Status status = this.decodeArgs(args);
        if (status != null) {
            return status;
        }
        File[] srcs = td.getSourceFiles();
        if (this.precompileClassDir == null) {
            trOut.println("Unconditionally compiling all sources");
            compileStatus = this.compileTogether(TEST_COMPILE, srcs);
        } else {
            trOut.println("Compiling sources only if necessary");
            compileStatus = this.compileIfNecessary(TEST_COMPILE, srcs, this.precompileClassDir);
        }
        if (!compileStatus.isPassed()) {
            return compileStatus;
        }
        String executeClass = td.getParameter("executeClass");
        String executeArgs = td.getParameter("executeArgs");
        Status executeStatus = this.execute(TEST_EXECUTE, executeClass, executeArgs);
        return executeStatus;
    }

    private Status decodeArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-precompileClassDir") || i + 1 >= args.length) {
                return Status.failed(UNRECOGNIZED_ARG + args[i]);
            }
            this.precompileClassDir = args[++i];
        }
        return null;
    }
}

