/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.sigfile;

import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.sigfile.FeaturesHolder;
import com.sun.tdk.signaturetest.sigfile.Format;
import com.sun.tdk.signaturetest.sigfile.Parser;
import com.sun.tdk.signaturetest.sigfile.Reader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class SignatureClassLoader
implements Reader {
    protected Format format;
    protected Set features = new HashSet();
    private BufferedReader in;
    private Parser parser;
    private final int BUFSIZE = 32768;
    protected String apiVersion = "";
    protected String signatureFileFormat = "";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$tdk$signaturetest$sigfile$SignatureClassLoader;

    protected SignatureClassLoader(Format format) {
        this.format = format;
        this.features = format.getSupportedFeatures();
        this.parser = this.getParser();
    }

    protected abstract Parser getParser();

    public boolean hasFeature(FeaturesHolder.Feature feature) {
        return this.features.contains(feature);
    }

    public Set getAllSupportedFeatures() {
        return this.features;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public ClassDescription readNextClass() throws IOException {
        String classDescr = null;
        List<String> definitions = new ArrayList();
        while (true) {
            this.in.mark(32768);
            String currentLine = this.in.readLine();
            if (currentLine == null) break;
            currentLine = currentLine.trim();
            if ((currentLine = this.preprocessLine(currentLine)).length() == 0 || currentLine.startsWith("#")) continue;
            MemberType type = MemberType.getItemType(currentLine);
            if (type == MemberType.CLASS) {
                if (classDescr != null) break;
                classDescr = currentLine;
                continue;
            }
            if (classDescr == null) {
                throw new Error();
            }
            definitions.add(currentLine);
        }
        this.in.reset();
        if (classDescr == null && definitions.size() == 0) {
            return null;
        }
        classDescr = this.convertClassDescr(classDescr);
        definitions = this.convertClassDefinitions(definitions);
        return this.parser.parseClassDescription(classDescr, definitions);
    }

    protected String preprocessLine(String currentLine) {
        return currentLine;
    }

    protected abstract String convertClassDescr(String var1);

    protected abstract List convertClassDefinitions(List var1);

    public boolean readSignatureFile(URL fileURL) throws IOException {
        this.in = new BufferedReader(new InputStreamReader(fileURL.openStream(), "UTF8"), 32768);
        if (!$assertionsDisabled && !this.in.markSupported()) {
            throw new AssertionError();
        }
        return this.readHeaders(this.in);
    }

    protected boolean readHeaders(BufferedReader in) throws IOException {
        String currentLine = in.readLine();
        if (currentLine == null) {
            return false;
        }
        this.signatureFileFormat = currentLine.trim();
        if (!this.signatureFileFormat.equals(this.format.getVersion())) {
            return false;
        }
        currentLine = in.readLine();
        if (currentLine == null) {
            return false;
        }
        if (!(currentLine = currentLine + ' ').startsWith("#Version ")) {
            return false;
        }
        this.apiVersion = currentLine.substring("#Version ".length()).trim();
        in.mark(32768);
        while ((currentLine = in.readLine()) != null && currentLine.startsWith("#")) {
            this.removeMissingFeature(currentLine);
        }
        in.reset();
        return true;
    }

    private void removeMissingFeature(String currentLine) {
        FeaturesHolder.Feature f = null;
        boolean remove = false;
        Iterator it = this.features.iterator();
        while (it.hasNext()) {
            f = (FeaturesHolder.Feature)it.next();
            if (!f.match(currentLine)) continue;
            remove = true;
            break;
        }
        if (f != null && remove) {
            this.features.remove(f);
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$tdk$signaturetest$sigfile$SignatureClassLoader == null ? (class$com$sun$tdk$signaturetest$sigfile$SignatureClassLoader = SignatureClassLoader.class$("com.sun.tdk.signaturetest.sigfile.SignatureClassLoader")) : class$com$sun$tdk$signaturetest$sigfile$SignatureClassLoader).desiredAssertionStatus();
    }
}

