/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.JLabel;

public class StringFitter {
    private String leftReplaceString = "...";
    private int leftRSWidth;
    private String rightReplaceString = "...";
    private int rightRSWidth;
    private String middleReplaceString = "...";
    private int middleRSWidth;
    private String splitString = "...";
    private int splitWidth;
    private static StringFitter defaultInstance;
    private FontMetrics fm;

    public StringFitter() {
        this(null, "...", "...", "");
    }

    public StringFitter(String replaceString, String splitString) {
        this(null, replaceString, replaceString, splitString);
    }

    public StringFitter(String leftReplaceString, String rightReplaceString, String splitString) {
        this(null, leftReplaceString, rightReplaceString, splitString);
    }

    public StringFitter(FontMetrics fm) {
        this(fm, "...", "...", "");
    }

    public StringFitter(FontMetrics fm, String replaceString, String splitString) {
        this(fm, replaceString, replaceString, splitString);
    }

    public StringFitter(FontMetrics fm, String leftReplaceString, String rightReplaceString, String splitString) {
        if (fm == null) {
            JLabel temp = new JLabel();
            fm = temp.getFontMetrics(temp.getFont());
            temp = null;
        }
        this.fm = fm;
        this.leftReplaceString = leftReplaceString;
        this.leftRSWidth = fm.stringWidth(leftReplaceString);
        this.rightReplaceString = rightReplaceString;
        this.rightRSWidth = fm.stringWidth(rightReplaceString);
        this.middleReplaceString = leftReplaceString.equals(rightReplaceString) ? leftReplaceString : leftReplaceString + rightReplaceString;
        this.middleRSWidth = fm.stringWidth(this.middleReplaceString);
        this.splitString = splitString;
        this.splitWidth = fm.stringWidth(splitString);
    }

    public static StringFitter getDefaultFitter() {
        if (defaultInstance == null) {
            defaultInstance = new StringFitter();
        }
        return defaultInstance;
    }

    public String getMiddleReplaceString() {
        return this.middleReplaceString;
    }

    public void setMiddleReplaceString(String s) {
        this.middleReplaceString = s;
        this.middleRSWidth = this.fm.stringWidth(s);
    }

    public String getLeftReplaceString() {
        return this.leftReplaceString;
    }

    public String getRightReplaceString() {
        return this.rightReplaceString;
    }

    public String getSplitString() {
        return this.splitString;
    }

    public FontMetrics getFontMetrics() {
        return this.fm;
    }

    public void setLeftReplaceString(String s) {
        this.leftReplaceString = s;
        this.leftRSWidth = this.fm.stringWidth(s);
    }

    public void setRightReplaceString(String s) {
        this.rightReplaceString = s;
        this.rightRSWidth = this.fm.stringWidth(s);
    }

    public void setSplitString(String s) {
        this.splitString = s;
        this.splitWidth = this.fm.stringWidth(s);
    }

    public void setFontMetrics(FontMetrics fm) {
        this.fm = fm;
        this.leftRSWidth = fm.stringWidth(this.leftReplaceString);
        this.rightRSWidth = fm.stringWidth(this.rightReplaceString);
        this.splitWidth = fm.stringWidth(this.splitString);
    }

    public void setFontMetrics(Component c) {
        this.fm = c.getFontMetrics(c.getFont());
        this.leftRSWidth = this.fm.stringWidth(this.leftReplaceString);
        this.rightRSWidth = this.fm.stringWidth(this.rightReplaceString);
        this.splitWidth = this.fm.stringWidth(this.splitString);
    }

    public String truncateBeginning(String s, Component c) {
        return this.truncateBeginning(s, c.getWidth());
    }

    public String truncateBeginning(String s, int width) {
        int i;
        int size = this.fm.stringWidth(s) + this.leftRSWidth;
        if (size <= width) {
            return s;
        }
        String[] parts = s.split(this.splitString, s.length() + 1);
        if (parts.length < 2) {
            return s;
        }
        size += this.splitWidth;
        for (i = 0; i < parts.length - 1 && size > width; size -= this.fm.stringWidth(parts[i]) + this.splitWidth, ++i) {
        }
        StringBuilder result = new StringBuilder(this.leftReplaceString);
        result.append(this.splitString).append(parts[i]);
        ++i;
        while (i < parts.length) {
            result.append(this.splitString).append(parts[i]);
            ++i;
        }
        return result.toString();
    }

    public String truncateEnding(String s, Component c) {
        return this.truncateEnding(s, c.getWidth());
    }

    public String truncateEnding(String s, int width) {
        int i;
        int size = this.fm.stringWidth(s) + this.rightRSWidth;
        if (size <= width) {
            return s;
        }
        String[] parts = s.split(this.splitString, s.length() + 1);
        if (parts.length < 2) {
            return s;
        }
        size += this.splitWidth;
        for (i = parts.length - 1; i > 0 && size >= width; size -= this.fm.stringWidth(parts[i]) + this.splitWidth, --i) {
        }
        StringBuilder result = new StringBuilder();
        for (int j = 0; j <= i; ++j) {
            result.append(parts[j]).append(this.splitString);
        }
        return result.append(this.rightReplaceString).toString();
    }

    public String truncateMiddle(String s, Component c) {
        return this.truncateMiddle(s, c.getWidth());
    }

    public String truncateMiddle(String s, int width) {
        if (this.fm.stringWidth(s) + this.middleRSWidth <= width) {
            return s;
        }
        String[] parts = s.split(this.splitString, s.length() + 1);
        if (parts.length < 2) {
            return s;
        }
        int begI = 0;
        int endI = parts.length - 1;
        int beg = this.fm.stringWidth(parts[begI]) + this.splitWidth;
        int end = this.fm.stringWidth(parts[endI]) + this.splitWidth;
        StringBuffer begS = new StringBuffer(parts[begI]).append(this.splitString);
        StringBuffer endS = new StringBuffer(this.splitString).append(parts[endI]);
        while (beg + end <= width) {
            while (beg <= end && beg + end <= width) {
                if ((beg += this.fm.stringWidth(parts[++begI]) + this.splitWidth) + end + this.middleRSWidth > width) continue;
                begS.append(parts[begI] + this.splitString);
            }
            while (end < beg && beg + end <= width) {
                if (beg + (end += this.fm.stringWidth(parts[--endI]) + this.splitWidth) + this.middleRSWidth > width) continue;
                endS.insert(0, this.splitString + parts[endI]);
            }
        }
        return begS.append(this.middleReplaceString).append(endS).toString();
    }
}

