/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaspic.tssv.config;

import com.sun.ts.tests.jaspic.tssv.config.TSAuthConfigProvider;
import com.sun.ts.tests.jaspic.tssv.config.TSAuthConfigProviderServlet;
import com.sun.ts.tests.jaspic.tssv.config.TSAuthConfigProviderStandalone;
import com.sun.ts.tests.jaspic.tssv.util.ProviderConfigurationEntry;
import com.sun.ts.tests.jaspic.tssv.util.ProviderConfigurationXMLFileProcessor;
import com.sun.ts.tests.jaspic.tssv.util.TSFileHandler;
import com.sun.ts.tests.jaspic.tssv.util.TSLogger;
import com.sun.ts.tests.jaspic.tssv.util.TSXMLFormatter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.RegistrationListener;

public class TSAuthConfigFactoryForStandalone
extends AuthConfigFactory {
    private static TSLogger logger = null;
    private static Map authConfigProviderMap = new Hashtable();
    private static Map registrationListenerMap = new Hashtable();
    private static Map registrationContextMap = new Hashtable();
    private static ProviderConfigurationXMLFileProcessor configFileProcessor = null;

    public TSAuthConfigFactoryForStandalone() {
        TSAuthConfigFactoryForStandalone.initializeTSLogger();
        logger.log(Level.INFO, "Initialized TSLogger");
        this.readProviderConfigurationXMLFile();
    }

    private void readProviderConfigurationXMLFile() {
        String providerConfigFileLocation = System.getProperty("provider.configuration.file");
        try {
            configFileProcessor = new ProviderConfigurationXMLFileProcessor(providerConfigFileLocation);
            Collection<ProviderConfigurationEntry> providerConfigurationEntriesCollection = configFileProcessor.getProviderConfigurationEntriesCollection();
            ProviderConfigurationEntry pce2 = null;
            for (ProviderConfigurationEntry pce2 : providerConfigurationEntriesCollection) {
                if (pce2 == null) continue;
                Properties newProps = this.getCleanACPProps(pce2.getProperties());
                this.registerConfigProvider(pce2.getProviderClassName(), newProps, pce2.getMessageLayer(), pce2.getApplicationContextId(), pce2.getRegistrationDescription());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e.getMessage() != null && !e.getMessage().equals("")) {
                logger.log(Level.SEVERE, e.getMessage());
            }
            logger.log(Level.SEVERE, "Error in readProviderConfigurationXMLFile()");
        }
    }

    private Properties getCleanACPProps(Properties origProps) {
        if (origProps == null) {
            return null;
        }
        Properties props = new Properties();
        Enumeration<Object> eProps = origProps.keys();
        while (eProps.hasMoreElements()) {
            String key = (String)eProps.nextElement();
            if (key == null) continue;
            Object val = origProps.get(key);
            if (val != null && val instanceof String) {
                props.put(key, (String)val);
                System.out.println("TSAuthConfigFactoryForStandalone:  added key=" + key + " with value = " + val);
                continue;
            }
            System.out.println("TSAuthConfigFactoryForStandalone: found non-string value for key=" + key);
        }
        return props;
    }

    public AuthConfigProvider getConfigProvider(String layer, String appContext, RegistrationListener listener) {
        AuthConfigProvider localACP = null;
        logger.log(Level.INFO, "getConfigProvider called for Layer : " + layer + " and AppContext :" + appContext);
        if (authConfigProviderMap != null) {
            localACP = (AuthConfigProvider)authConfigProviderMap.get(layer + appContext);
            if (listener != null && localACP != null) {
                registrationListenerMap.put(localACP, listener);
            }
            String logMsg = "getConfigProvider returned non-null provider for";
            logMsg = logMsg + " Layer : " + layer + " and AppContext :" + appContext;
            logger.log(Level.INFO, logMsg);
            return localACP;
        }
        String logMsg = "getConfigProvider returned null provider for";
        logMsg = logMsg + " Layer : " + layer + " and AppContext :" + appContext;
        logger.log(Level.INFO, logMsg);
        return null;
    }

    public AuthConfigFactory.RegistrationContext getRegistrationContext(String registrationID) {
        return (AuthConfigFactory.RegistrationContext)registrationContextMap.get(registrationID);
    }

    public String[] getRegistrationIDs(AuthConfigProvider provider) {
        Vector<Object> keyMatchVector = new Vector<Object>();
        if (provider != null) {
            Set entries = authConfigProviderMap.entrySet();
            for (Map.Entry entry : entries) {
                if (!entry.getValue().equals(provider)) continue;
                keyMatchVector.add(entry.getKey());
            }
        } else {
            Set authConfigProviderMapKeySet = authConfigProviderMap.keySet();
            Iterator iterator = authConfigProviderMapKeySet.iterator();
            while (iterator.hasNext()) {
                keyMatchVector.add(iterator.next());
            }
        }
        String[] result = new String[keyMatchVector.size()];
        int index = 0;
        Iterator keyMatchVectorIterator = keyMatchVector.iterator();
        while (keyMatchVectorIterator.hasNext()) {
            result[index++] = (String)keyMatchVectorIterator.next();
        }
        return result;
    }

    public String[] detachListener(RegistrationListener listener, String layer, String appContext) {
        return null;
    }

    public boolean removeRegistration(String registrationID) {
        registrationContextMap.remove(registrationID);
        return authConfigProviderMap.remove(registrationID) != null;
    }

    public String registerConfigProvider(String className, Map properties, String layer, String appContext, String description) {
        String result = null;
        Object acp = null;
        String theClass = "com.sun.ts.tests.jaspic.tssv.config.TSAuthConfigProviderStandalone";
        logger.log(Level.INFO, "registerConfigProvider() called for layer " + layer + " and appContext " + appContext);
        try {
            if (className.equals("com.sun.ts.tests.jaspic.tssv.config.TSAuthConfigProvider")) {
                acp = new TSAuthConfigProvider(properties, null, logger);
            } else if (className.equals("com.sun.ts.tests.jaspic.tssv.config.TSAuthConfigProviderServlet")) {
                acp = new TSAuthConfigProviderServlet(properties, logger, null);
            } else if (className.equals(theClass)) {
                acp = new TSAuthConfigProviderStandalone(properties, logger, null);
            } else {
                throw new RuntimeException("Unknown class : " + className);
            }
            AuthConfigFactory.RegistrationContext previousRC = null;
            AuthConfigProvider previousACP = null;
            previousACP = (AuthConfigProvider)authConfigProviderMap.get(layer + appContext);
            previousRC = (AuthConfigFactory.RegistrationContext)registrationContextMap.get(layer + appContext);
            if (previousACP == null) {
                authConfigProviderMap.put(layer + appContext, acp);
                registrationContextMap.put(layer + appContext, new RegistrationContextImpl(layer, appContext, description, true));
                ProviderConfigurationXMLFileProcessor.addProviderConfigEntry(className, properties, layer, appContext, description);
            } else if (previousACP != null && !previousRC.isPersistent()) {
                authConfigProviderMap.put(layer + appContext, acp);
                registrationContextMap.put(layer + appContext, new RegistrationContextImpl(layer, appContext, description, true));
                ProviderConfigurationXMLFileProcessor.addProviderConfigEntry(className, properties, layer, appContext, description);
            }
            result = layer + appContext;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Exception :" + e.getMessage());
        }
        return result;
    }

    public String registerConfigProvider(AuthConfigProvider provider, String layer, String appContext, String description) {
        String result = null;
        String providerClassName = null;
        logger.log(Level.INFO, "registerConfigProvider() called for layer " + layer + " and appContext " + appContext);
        if (provider == null) {
            return result;
        }
        try {
            AuthConfigFactory.RegistrationContext previousRC = null;
            AuthConfigProvider previousACP = null;
            previousACP = (AuthConfigProvider)authConfigProviderMap.get(layer + appContext);
            previousRC = (AuthConfigFactory.RegistrationContext)registrationContextMap.get(layer + appContext);
            if (previousACP == null) {
                authConfigProviderMap.put(layer + appContext, provider);
                registrationContextMap.put(layer + appContext, new RegistrationContextImpl(layer, appContext, description, false));
            } else if (previousACP != null && previousRC.isPersistent()) {
                registrationContextMap.put(layer + appContext, new RegistrationContextImpl(layer, appContext, description, false));
                if (provider != null) {
                    providerClassName = provider.getClass().getName();
                }
                ProviderConfigurationXMLFileProcessor.deleteProviderConfigEntry(providerClassName, layer, appContext, description);
            }
            result = layer + appContext;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Exception :" + e.getMessage());
        }
        return result;
    }

    public void refresh() {
    }

    private static void initializeTSLogger() {
        String logFileLocation = null;
        if (logger != null) {
            return;
        }
        try {
            logFileLocation = System.getProperty("log.file.location");
            System.out.println("logFileLocation = " + logFileLocation);
            if (logFileLocation == null) {
                throw new RuntimeException("log.file.location not set");
            }
            logger = TSLogger.getTSLogger("jsr196");
            boolean appendMode = true;
            TSFileHandler fileHandler = new TSFileHandler(logFileLocation + "/" + "TSSVLog.txt", appendMode);
            fileHandler.setFormatter(new TSXMLFormatter());
            logger.addHandler(fileHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("TSLogger Initialization failed", e);
        }
    }

    private String returnString(String[] array) {
        String output = "";
        for (int i = 0; i < array.length; ++i) {
            output = output + "|" + array[i];
        }
        return output;
    }

    private static class RegistrationContextImpl
    implements AuthConfigFactory.RegistrationContext {
        private String messageLayer;
        private String appContext;
        private String description;

        private RegistrationContextImpl(String messageLayer, String appContext, String description, boolean isPersistent) {
            this.messageLayer = messageLayer;
            this.appContext = appContext;
            this.description = description;
        }

        public String getMessageLayer() {
            return this.messageLayer;
        }

        public String getAppContext() {
            return this.appContext;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isPersistent() {
            return false;
        }
    }
}

