/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener.interceptor;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedSimpleBindRequest;
import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedSimpleBindResult;
import com.unboundid.ldap.listener.interceptor.InterceptedOperation;
import com.unboundid.ldap.protocol.BindRequestProtocolOp;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.util.Mutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
final class InterceptedSimpleBindOperation
extends InterceptedOperation
implements InMemoryInterceptedSimpleBindRequest,
InMemoryInterceptedSimpleBindResult {
    private BindResult bindResult;
    private SimpleBindRequest bindRequest;

    InterceptedSimpleBindOperation(LDAPListenerClientConnection clientConnection, int messageID, BindRequestProtocolOp requestOp, Control ... requestControls) {
        super(clientConnection, messageID);
        this.bindRequest = (SimpleBindRequest)requestOp.toBindRequest(requestControls);
        this.bindResult = null;
    }

    @Override
    public SimpleBindRequest getRequest() {
        return this.bindRequest;
    }

    @Override
    public void setRequest(SimpleBindRequest bindRequest) {
        this.bindRequest = bindRequest;
    }

    @Override
    public BindResult getResult() {
        return this.bindResult;
    }

    @Override
    public void setResult(BindResult bindResult) {
        this.bindResult = bindResult;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("InterceptedSimpleBindOperation(");
        this.appendCommonToString(buffer);
        buffer.append(", request=");
        buffer.append(this.bindRequest);
        buffer.append(", result=");
        buffer.append(this.bindResult);
        buffer.append(')');
    }
}

