/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.timer.spi;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import org.glassfish.pfl.basic.contain.Pair;
import org.glassfish.pfl.dynamic.codegen.impl.ASMUtil;
import org.glassfish.pfl.dynamic.codegen.spi.ClassGenerator;
import org.glassfish.pfl.dynamic.codegen.spi.Expression;
import org.glassfish.pfl.dynamic.codegen.spi.ImportList;
import org.glassfish.pfl.dynamic.codegen.spi.Type;
import org.glassfish.pfl.dynamic.codegen.spi.Wrapper;
import org.glassfish.pfl.tf.timer.spi.Controllable;
import org.glassfish.pfl.tf.timer.spi.Named;
import org.glassfish.pfl.tf.timer.spi.Timer;
import org.glassfish.pfl.tf.timer.spi.TimerEventController;
import org.glassfish.pfl.tf.timer.spi.TimerFactory;
import org.glassfish.pfl.tf.timer.spi.TimerGroup;

public class TimerPointSourceGenerator {
    private static final Comparator<Named> COMP = new Comparator<Named>(){

        @Override
        public int compare(Named o1, Named o2) {
            return o1.name().compareTo(o2.name());
        }
    };
    private static Type TimerFactory;
    private static Type Timer;
    private static Type TimerEventController;
    private static Type TimerGroup;
    private static ImportList standardImports;

    public static void generateFile(String dirName, Pair<String, TimerFactory> description) throws IOException {
        String packageName = (String)description.first();
        TimerFactory tf = (TimerFactory)description.second();
        TimerPointSourceGenerator.generateSingleClass(dirName, packageName, tf);
    }

    private static void generateSingleClass(String dirName, String packageName, TimerFactory tf) throws IOException {
        TimerPointSourceGenerator.startFile(packageName);
        Wrapper._class((int)1, (String)tf.name(), (Type)Wrapper._Object(), (Type[])new Type[0]);
        TimerPointSourceGenerator.generateFields(tf, false, true);
        TimerPointSourceGenerator.generateConstructor(tf, false);
        TimerPointSourceGenerator.generateAccessorMethods(tf, true);
        Wrapper._end();
        Type type = Type._classGenerator((ClassGenerator)Wrapper._classGenerator());
        TimerPointSourceGenerator.writeFile(dirName, type);
    }

    private static void startFile(String packageName) {
        Wrapper._clear();
        Wrapper._package((String)packageName);
        Wrapper._import((ImportList)standardImports);
    }

    private static void generateFields(TimerFactory tf, boolean generateController, boolean privateTimers) {
        if (generateController) {
            Wrapper._data((int)20, (Type)TimerEventController, (String)"controller");
        }
        int mod = 0x10 | (privateTimers ? 2 : 4);
        ArrayList<? extends Timer> timers = new ArrayList<Timer>(tf.timers().values());
        Collections.sort(timers, COMP);
        for (Timer timer : timers) {
            Wrapper._data((int)mod, (Type)Timer, (String)timer.name());
        }
        ArrayList<? extends TimerGroup> timerGroups = new ArrayList<TimerGroup>(tf.timerGroups().values());
        Collections.sort(timerGroups, COMP);
        for (TimerGroup timerGroup : timerGroups) {
            Wrapper._data((int)18, (Type)TimerGroup, (String)timerGroup.name());
        }
    }

    private static void generateConstructor(TimerFactory tf, boolean generateController) {
        Expression controller = null;
        Wrapper._constructor((int)1, (Type[])new Type[0]);
        Expression tfe = Wrapper._arg((Type)TimerFactory, (String)"tf");
        if (generateController) {
            controller = Wrapper._arg((Type)TimerEventController, (String)"controller");
        }
        Wrapper._body();
        if (generateController) {
            Wrapper._assign((Expression)Wrapper._field((Expression)Wrapper._this(), (String)"controller"), (Expression)controller);
        }
        for (Timer timer : tf.timers().values()) {
            Wrapper._assign((Expression)Wrapper._v((String)timer.name()), (Expression)Wrapper._call((Expression)tfe, (String)"makeTimer", (Expression[])new Expression[]{Wrapper._const((String)timer.name()), Wrapper._const((String)timer.description())}));
        }
        for (TimerGroup timerGroup : tf.timerGroups().values()) {
            Wrapper._assign((Expression)Wrapper._v((String)timerGroup.name()), (Expression)Wrapper._call((Expression)tfe, (String)"makeTimerGroup", (Expression[])new Expression[]{Wrapper._const((String)timerGroup.name()), Wrapper._const((String)timerGroup.description())}));
        }
        for (TimerGroup timerGroup : tf.timerGroups().values()) {
            for (Controllable controllable : timerGroup.contents()) {
                Wrapper._expr((Expression)Wrapper._call((Expression)Wrapper._v((String)timerGroup.name()), (String)"add", (Expression[])new Expression[]{Wrapper._v((String)controllable.name())}));
            }
        }
        Wrapper._end();
    }

    private static void generateAccessorMethods(TimerFactory tf, boolean isImpl) {
        int modifiers = isImpl ? 17 : 1025;
        ArrayList<? extends Timer> timers = new ArrayList<Timer>(tf.timers().values());
        Collections.sort(timers, COMP);
        for (Timer timer : timers) {
            Wrapper._method((int)modifiers, (Type)Timer, (String)timer.name(), (Type[])new Type[0]);
            if (isImpl) {
                Wrapper._body();
                Wrapper._return((Expression)Wrapper._field((Expression)Wrapper._this(), (String)timer.name()));
            }
            Wrapper._end();
        }
        ArrayList<? extends TimerGroup> timerGroups = new ArrayList<TimerGroup>(tf.timerGroups().values());
        Collections.sort(timerGroups, COMP);
        for (TimerGroup timerGroup : timerGroups) {
            Wrapper._method((int)modifiers, (Type)TimerGroup, (String)timerGroup.name(), (Type[])new Type[0]);
            if (isImpl) {
                Wrapper._body();
                Wrapper._return((Expression)Wrapper._field((Expression)Wrapper._this(), (String)timerGroup.name()));
            }
            Wrapper._end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(String dirName, Type type) throws IOException {
        File file = ASMUtil.getFile((String)dirName, (String)type.name(), (String)".java");
        try (PrintStream ps = new PrintStream(file);){
            Wrapper._sourceCode((PrintStream)ps, (Properties)new Properties());
        }
    }

    static {
        Wrapper._clear();
        Wrapper._package();
        TimerFactory = Wrapper._import((String)TimerFactory.class.getName());
        Timer = Wrapper._import((String)Timer.class.getName());
        TimerEventController = Wrapper._import((String)TimerEventController.class.getName());
        TimerGroup = Wrapper._import((String)TimerGroup.class.getName());
        standardImports = Wrapper._import();
    }
}

