/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.context.BaseContextMap;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SessionMap
extends BaseContextMap<Object> {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private final HttpServletRequest request;
    private final ProjectStage stage;

    public SessionMap(HttpServletRequest request, ProjectStage stage) {
        this.request = request;
        this.stage = stage;
    }

    @Override
    public void clear() {
        HttpSession session = this.getSession(false);
        if (session != null) {
            Enumeration e = session.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                session.removeAttribute(name);
            }
        }
    }

    @Override
    public void putAll(Map t) {
        HttpSession session = this.getSession(true);
        for (Map.Entry entry : t.entrySet()) {
            Object v = entry.getValue();
            Object k = entry.getKey();
            if (ProjectStage.Development.equals((Object)this.stage) && !(v instanceof Serializable) && LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.context.extcontext.sessionmap.nonserializable", new Object[]{k, v.getClass().getName()});
            }
            session.setAttribute((String)k, v);
        }
    }

    @Override
    public Object get(Object key) {
        Util.notNull("key", key);
        HttpSession session = this.getSession(false);
        return session != null ? session.getAttribute(key.toString()) : null;
    }

    @Override
    public Object put(String key, Object value) {
        Util.notNull("key", key);
        HttpSession session = this.getSession(true);
        Object result = session.getAttribute(key);
        if (value != null && ProjectStage.Development.equals((Object)this.stage) && !(value instanceof Serializable) && LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "jsf.context.extcontext.sessionmap.nonserializable", new Object[]{key, value.getClass().getName()});
        }
        boolean doSet = true;
        if (null != value && null != result) {
            int resultCode;
            int valCode = System.identityHashCode(value);
            boolean bl = doSet = valCode != (resultCode = System.identityHashCode(result));
        }
        if (doSet) {
            session.setAttribute(key, value);
        }
        return result;
    }

    @Override
    public Object remove(Object key) {
        if (key == null) {
            return null;
        }
        HttpSession session = this.getSession(false);
        if (session != null) {
            String keyString = key.toString();
            Object result = session.getAttribute(keyString);
            session.removeAttribute(keyString);
            return result;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        HttpSession session = this.getSession(false);
        return session != null && session.getAttribute(key.toString()) != null;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && obj instanceof SessionMap && super.equals(obj);
    }

    @Override
    public int hashCode() {
        HttpSession session = this.getSession(false);
        int hashCode = 7 * (session != null ? session.hashCode() : super.hashCode());
        if (session != null) {
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                hashCode += i.next().hashCode();
            }
        }
        return hashCode;
    }

    @Override
    protected Iterator<Map.Entry<String, Object>> getEntryIterator() {
        HttpSession session = this.getSession(false);
        if (session != null) {
            return new BaseContextMap.EntryIterator(session.getAttributeNames());
        }
        Map empty = Collections.emptyMap();
        return empty.entrySet().iterator();
    }

    @Override
    protected Iterator<String> getKeyIterator() {
        HttpSession session = this.getSession(false);
        if (session != null) {
            return new BaseContextMap.KeyIterator(session.getAttributeNames());
        }
        Map empty = Collections.emptyMap();
        return empty.keySet().iterator();
    }

    @Override
    protected Iterator<Object> getValueIterator() {
        HttpSession session = this.getSession(false);
        if (session != null) {
            return new BaseContextMap.ValueIterator(session.getAttributeNames());
        }
        Map empty = Collections.emptyMap();
        return empty.values().iterator();
    }

    protected HttpSession getSession(boolean createNew) {
        return this.request.getSession(createNew);
    }
}

