/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.admin.util.AdminLoggerInfo;
import com.sun.enterprise.util.StringUtils;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.glassfish.api.admin.AdminCommandEventBroker;

public class AdminCommandEventBrokerImpl<T>
implements AdminCommandEventBroker<T> {
    private final List<ListenerGroup> listenerGroups = new ArrayList<ListenerGroup>();
    private static final Logger logger = AdminLoggerInfo.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(String name, Object event) {
        if (event == null) {
            return;
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument name must be defined");
        }
        IdentityHashMap<AdminCommandEventBroker.AdminCommandListener, AdminCommandEventBroker.AdminCommandListener> deduplicated = new IdentityHashMap<AdminCommandEventBroker.AdminCommandListener, AdminCommandEventBroker.AdminCommandListener>();
        AdminCommandEventBrokerImpl adminCommandEventBrokerImpl = this;
        synchronized (adminCommandEventBrokerImpl) {
            for (ListenerGroup listenerGroup : this.listenerGroups) {
                if (!listenerGroup.matches(name)) continue;
                for (AdminCommandEventBroker.AdminCommandListener listener : listenerGroup.listeners) {
                    deduplicated.put(listener, listener);
                }
            }
        }
        for (AdminCommandEventBroker.AdminCommandListener listener : deduplicated.keySet()) {
            try {
                listener.onAdminCommandEvent(name, event);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "NCLS-ADMIN-00018", ex);
            }
        }
    }

    public synchronized void fireEvent(Object event) {
        if (event == null) {
            return;
        }
        this.fireEvent(event.getClass().getName(), event);
    }

    public synchronized void registerListener(String regexpForName, AdminCommandEventBroker.AdminCommandListener<T> listener) {
        if (regexpForName == null) {
            throw new IllegalArgumentException("Argument regexpForName must be defined");
        }
        if (listener == null) {
            return;
        }
        ListenerGroup lgrp = null;
        for (ListenerGroup listenerGroup : this.listenerGroups) {
            if (!regexpForName.equals(listenerGroup.getOriginalPattern())) continue;
            lgrp = listenerGroup;
            break;
        }
        if (lgrp == null) {
            lgrp = new ListenerGroup(regexpForName);
            this.listenerGroups.add(lgrp);
        }
        lgrp.add(listener);
        this.fireEvent("local/listener/register", new AdminCommandEventBroker.BrokerListenerRegEvent((AdminCommandEventBroker)this, listener));
    }

    public synchronized boolean listening(String eventName) {
        if (eventName == null) {
            for (ListenerGroup listenerGroup : this.listenerGroups) {
                if (listenerGroup.listeners.isEmpty()) continue;
                return true;
            }
        } else {
            for (ListenerGroup listenerGroup : this.listenerGroups) {
                if (!listenerGroup.matches(eventName) || listenerGroup.listeners.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized void unregisterListener(AdminCommandEventBroker.AdminCommandListener listener) {
        boolean removed = false;
        for (ListenerGroup listenerGroup : this.listenerGroups) {
            if (!listenerGroup.remove(listener)) continue;
            removed = true;
        }
        if (removed) {
            this.fireEvent("local/listener/unregister", new AdminCommandEventBroker.BrokerListenerRegEvent((AdminCommandEventBroker)this, listener));
        }
    }

    public AdminCommandEventBroker.EventBrokerUtils getUtils() {
        return new AdminCommandEventBroker.EventBrokerUtils(){

            public void sendMessage(String message) {
                if (StringUtils.ok((String)message)) {
                    AdminCommandEventBrokerImpl.this.fireEvent("usermessage", message);
                }
            }
        };
    }

    private static class ListenerGroup {
        private final Pattern pattern;
        private final List<AdminCommandEventBroker.AdminCommandListener> listeners = new ArrayList<AdminCommandEventBroker.AdminCommandListener>(1);

        private ListenerGroup(String pattern) {
            this.pattern = Pattern.compile(pattern);
        }

        public String getOriginalPattern() {
            return this.pattern.pattern();
        }

        public boolean matches(CharSequence name) {
            return this.pattern.matcher(name).matches();
        }

        public Iterator<AdminCommandEventBroker.AdminCommandListener> listeners() {
            return this.listeners.iterator();
        }

        public boolean add(AdminCommandEventBroker.AdminCommandListener listener) {
            return this.listeners.add(listener);
        }

        public boolean remove(AdminCommandEventBroker.AdminCommandListener listener) {
            return this.listeners.remove(listener);
        }
    }
}

