/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.jsp;

import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.web.WebModule;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.JspTag;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.jsp.api.ResourceInjector;
import org.glassfish.web.LogFacade;

public class ResourceInjectorImpl
implements ResourceInjector {
    protected static final Logger _logger = LogFacade.getLogger();
    protected static final ResourceBundle _rb = _logger.getResourceBundle();
    private InjectionManager injectionMgr;
    private JndiNameEnvironment desc;
    private WebModule webModule;

    public ResourceInjectorImpl(WebModule webModule) {
        this.webModule = webModule;
        this.desc = webModule.getWebBundleDescriptor();
        ServerContext serverContext = webModule.getServerContext();
        if (serverContext == null) {
            throw new IllegalStateException(_rb.getString("AS-WEB-GLUE-00095"));
        }
        this.injectionMgr = (InjectionManager)serverContext.getDefaultServices().getService(InjectionManager.class, new Annotation[0]);
    }

    public <T extends JspTag> T createTagHandlerInstance(Class<T> clazz) throws Exception {
        return this.webModule.getWebContainer().createTagHandlerInstance(this.webModule, clazz);
    }

    public void preDestroy(JspTag handler) {
        if (this.desc != null) {
            try {
                this.injectionMgr.invokeInstancePreDestroy((Object)handler, this.desc);
                this.injectionMgr.destroyManagedObject((Object)handler);
            }
            catch (Exception e) {
                String msg = _rb.getString("AS-WEB-GLUE-00094");
                msg = MessageFormat.format(msg, handler);
                _logger.log(Level.WARNING, msg, e);
            }
        }
    }
}

