/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.descriptors;

import com.sun.jsftemplating.component.ComponentUtil;
import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.descriptors.LayoutComposition;
import com.sun.jsftemplating.layout.descriptors.LayoutDefinition;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.LayoutInsert;
import com.sun.jsftemplating.layout.descriptors.handler.Handler;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContextImpl;
import com.sun.jsftemplating.layout.event.AfterEncodeEvent;
import com.sun.jsftemplating.layout.event.BeforeEncodeEvent;
import com.sun.jsftemplating.layout.event.EncodeEvent;
import com.sun.jsftemplating.util.LayoutElementUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public abstract class LayoutElementBase
implements LayoutElement {
    private List<LayoutElement> _layoutElements = new ArrayList<LayoutElement>();
    private LayoutElement _parent = null;
    private Map<String, List<Handler>> _handlersByType = new HashMap<String, List<Handler>>();
    private String _id = null;
    public static final String AFTER_ENCODE = "afterEncode";
    public static final String BEFORE_ENCODE = "beforeEncode";
    public static final String ENCODE = "encode";

    protected LayoutElementBase(LayoutElement parent, String id) {
        this.setParent(parent);
        this._id = id;
    }

    @Override
    public void addChildLayoutElement(LayoutElement element) {
        this._layoutElements.add(element);
    }

    @Override
    public List<LayoutElement> getChildLayoutElements() {
        return this._layoutElements;
    }

    @Override
    public LayoutElement getChildLayoutElement(String id) {
        Iterator<LayoutElement> it = this.getChildLayoutElements().iterator();
        LayoutElement elt = null;
        while (it.hasNext()) {
            elt = it.next();
            if (!id.equals(elt.getUnevaluatedId())) continue;
            return elt;
        }
        return null;
    }

    @Override
    public LayoutElement findLayoutElement(String id) {
        if (id == null) {
            return null;
        }
        List<LayoutElement> children = this.getChildLayoutElements();
        for (LayoutElement elt : children) {
            if (!id.equals(elt.getUnevaluatedId())) continue;
            return elt;
        }
        LayoutElement result = null;
        FacesContext context = FacesContext.getCurrentInstance();
        if (this instanceof LayoutComposition) {
            LayoutComposition.push(context, this);
            LayoutDefinition def = LayoutDefinitionManager.getLayoutDefinition(context, ((LayoutComposition)this).getTemplate());
            result = def.findLayoutElement(id);
            LayoutComposition.pop(context);
        }
        for (LayoutElement elt : children) {
            if (elt instanceof LayoutComposition && ((LayoutComposition)elt).getTemplate() != null) {
                LayoutComposition.push(context, elt);
                LayoutDefinition def = LayoutDefinitionManager.getLayoutDefinition(context, ((LayoutComposition)elt).getTemplate());
                result = def.findLayoutElement(id);
                LayoutComposition.pop(context);
            } else if (!(elt instanceof LayoutInsert)) {
                result = elt.findLayoutElement(id);
            }
            if (result == null) continue;
            break;
        }
        return result;
    }

    @Override
    public LayoutDefinition getLayoutDefinition() {
        LayoutElement cur = this;
        while (cur.getParent() != null) {
            cur = cur.getParent();
        }
        if (!(cur instanceof LayoutDefinition)) {
            cur = null;
        }
        return (LayoutDefinition)cur;
    }

    @Override
    public LayoutElement getParent() {
        return this._parent;
    }

    protected void setParent(LayoutElement parent) {
        this._parent = parent;
    }

    private String getId() {
        if (this._id == null || this._id == "") {
            this._id = LayoutElementUtil.getGeneratedId(null);
        }
        return this._id;
    }

    @Override
    public String getUnevaluatedId() {
        return this.getId();
    }

    @Override
    public String getId(FacesContext context, UIComponent parent) {
        Object value = this.resolveValue(context, parent, this.getId());
        return value == null ? "" : value.toString();
    }

    public Object resolveValue(FacesContext context, UIComponent parent, Object value) {
        return ComponentUtil.getInstance(context).resolveValue(context, this, parent, value);
    }

    protected abstract boolean encodeThis(FacesContext var1, UIComponent var2) throws IOException;

    @Override
    public void encode(FacesContext context, UIComponent component) throws IOException {
        Object result = this.dispatchHandlers(context, BEFORE_ENCODE, new BeforeEncodeEvent(component));
        if (result != null && result.toString().equals("false")) {
            return;
        }
        boolean renderChildren = this.encodeThis(context, component);
        if (renderChildren) {
            result = this.dispatchHandlers(context, ENCODE, new EncodeEvent(component));
            LayoutElement childElt2 = null;
            for (LayoutElement childElt2 : this.getChildLayoutElements()) {
                childElt2.encode(context, component);
            }
        }
        result = this.dispatchHandlers(context, AFTER_ENCODE, new AfterEncodeEvent(component));
    }

    @Override
    public Object dispatchHandlers(FacesContext context, String eventType, EventObject event) {
        List<Handler> handlers;
        Object eventObj = event.getSource();
        if (!(eventObj instanceof UIComponent)) {
            eventObj = null;
        }
        if ((handlers = this.getHandlers(eventType, (UIComponent)eventObj)) == null) {
            return null;
        }
        HandlerContext handlerContext = this.createHandlerContext(context, event, eventType);
        return this.dispatchHandlers(handlerContext, handlers);
    }

    @Override
    public Object dispatchHandlers(HandlerContext handlerCtx, List<Handler> handlers) {
        FacesContext ctx = handlerCtx.getFacesContext();
        Object retVal = null;
        Object result = null;
        boolean checkRenderResp = !ctx.getRenderResponse();
        for (Handler handler : handlers) {
            if (ctx.getResponseComplete() || checkRenderResp && ctx.getRenderResponse()) {
                return result;
            }
            handlerCtx.setHandler(handler);
            try {
                retVal = handler.invoke(handlerCtx);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getClass().getName() + " while attempting to process a '" + handlerCtx.getEventType() + "' event for '" + this.getId() + "'.", ex);
            }
            if (retVal == null) continue;
            result = retVal;
        }
        return result;
    }

    protected HandlerContext createHandlerContext(FacesContext context, EventObject event, String eventType) {
        return new HandlerContextImpl(context, this, event, eventType);
    }

    @Override
    public List<Handler> getHandlers(String type) {
        return this._handlersByType.get(type);
    }

    @Override
    public Map<String, List<Handler>> getHandlersByTypeMap() {
        return this._handlersByType;
    }

    public void setHandlersByTypeMap(Map<String, List<Handler>> map) {
        if (map != null) {
            this._handlersByType = map;
        }
    }

    @Override
    public List<Handler> getHandlers(String type, UIComponent comp) {
        List<Handler> handlers = this.getHandlers(type);
        return handlers;
    }

    @Override
    public void setHandlers(String type, List<Handler> handlers) {
        this._handlersByType.put(type, handlers);
    }

    public static void encodeChild(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        String id = component.getId();
        if (id != null) {
            component.setId(id);
        }
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            Iterator it = component.getChildren().iterator();
            while (it.hasNext()) {
                LayoutElementBase.encodeChild(context, (UIComponent)it.next());
            }
        }
        component.encodeEnd(context);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        LayoutElementUtil.dumpTree(this, buf, "");
        return buf.toString();
    }
}

