/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing.jpql;

import org.eclipse.persistence.internal.jpa.parsing.JPQLParseTree;
import org.eclipse.persistence.internal.jpa.parsing.jpql.JPQLParser;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;

public class JPQLParserFactory {
    public JPQLParser buildParserFor(String ejbqlString) {
        return JPQLParser.buildParserFor(ejbqlString);
    }

    public JPQLParser parseEJBQLString(String ejbqlString) {
        JPQLParser parser = this.buildParserFor(ejbqlString);
        parser.parse();
        return parser;
    }

    public void populateQuery(String jpqlString, ObjectLevelReadQuery query, AbstractSession session) {
        boolean isCacheable = query.isDefaultPropertiesQuery();
        DatabaseQuery cachedQuery = null;
        if (isCacheable) {
            cachedQuery = (DatabaseQuery)session.getProject().getJPQLParseCache().get(jpqlString);
        }
        if (cachedQuery == null || !cachedQuery.isPrepared() || cachedQuery.getClass() != query.getClass()) {
            JPQLParser parser = this.parseEJBQLString(jpqlString);
            JPQLParseTree parseTree = parser.getParseTree();
            parseTree.populateQuery(query, session);
            if (isCacheable) {
                session.getProject().getJPQLParseCache().put(jpqlString, query);
            }
        } else {
            query.prepareFromQuery(cachedQuery);
            query.setIsPrepared(true);
        }
    }
}

