/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import java.util.Collection;
import java.util.HashSet;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.deployment.common.RootDeploymentDescriptor;

public class WebServicesDescriptor
extends RootDeploymentDescriptor {
    private BundleDescriptor bundleDesc;
    private Collection<WebService> webServices = new HashSet<WebService>();

    public String getDefaultSpecVersion() {
        return "1.3";
    }

    public void setBundleDescriptor(BundleDescriptor module) {
        this.bundleDesc = module;
    }

    public BundleDescriptor getBundleDescriptor() {
        return this.bundleDesc;
    }

    public boolean hasWebServices() {
        return !this.webServices.isEmpty();
    }

    public boolean isEmpty() {
        return this.webServices.isEmpty();
    }

    public WebService getWebServiceByName(String webServiceName) {
        for (WebService webService : this.webServices) {
            if (!webService.getName().equals(webServiceName)) continue;
            return webService;
        }
        return null;
    }

    public void addWebService(WebService descriptor) {
        descriptor.setWebServicesDescriptor(this);
        this.webServices.add(descriptor);
    }

    public void removeWebService(WebService descriptor) {
        descriptor.setWebServicesDescriptor(null);
        this.webServices.remove((Object)descriptor);
    }

    public Collection<WebService> getWebServices() {
        return new HashSet<WebService>(this.webServices);
    }

    public WebServiceEndpoint getEndpointByName(String endpointName) {
        for (WebServiceEndpoint next : this.getEndpoints()) {
            if (!next.getEndpointName().equals(endpointName)) continue;
            return next;
        }
        return null;
    }

    public boolean hasEndpointsImplementedBy(EjbDescriptor ejb) {
        return !this.getEndpointsImplementedBy(ejb).isEmpty();
    }

    public Collection<WebServiceEndpoint> getEndpointsImplementedBy(EjbDescriptor ejb) {
        HashSet<WebServiceEndpoint> endpoints = new HashSet<WebServiceEndpoint>();
        if (ejb instanceof EjbSessionDescriptor) {
            for (WebServiceEndpoint next : this.getEndpoints()) {
                if (!next.implementedByEjbComponent(ejb)) continue;
                endpoints.add(next);
            }
        }
        return endpoints;
    }

    public boolean hasEndpointsImplementedBy(WebComponentDescriptor desc) {
        return !this.getEndpointsImplementedBy(desc).isEmpty();
    }

    public Collection<WebServiceEndpoint> getEndpointsImplementedBy(WebComponentDescriptor desc) {
        HashSet<WebServiceEndpoint> endpoints = new HashSet<WebServiceEndpoint>();
        for (WebServiceEndpoint next : this.getEndpoints()) {
            if (!next.implementedByWebComponent(desc)) continue;
            endpoints.add(next);
        }
        return endpoints;
    }

    public Collection<WebServiceEndpoint> getEndpoints() {
        HashSet<WebServiceEndpoint> allEndpoints = new HashSet<WebServiceEndpoint>();
        for (WebService webService : this.webServices) {
            allEndpoints.addAll(webService.getEndpoints());
        }
        return allEndpoints;
    }

    public ArchiveType getModuleType() {
        if (this.bundleDesc != null) {
            return this.bundleDesc.getModuleType();
        }
        return null;
    }

    public String getModuleID() {
        return "";
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public boolean isApplication() {
        return false;
    }

    public void print(StringBuffer toStringBuffer) {
        super.print(toStringBuffer);
        if (this.hasWebServices()) {
            for (WebService aWebService : this.getWebServices()) {
                toStringBuffer.append("\n Web Service : ");
                aWebService.print(toStringBuffer);
            }
        }
    }
}

