/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.AdminObject;
import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InboundResourceAdapter;
import com.sun.enterprise.deployment.LicenseDescriptor;
import com.sun.enterprise.deployment.MessageListener;
import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.SecurityPermission;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class DescriptorFactory {
    static Map descriptorClasses;

    protected DescriptorFactory() {
    }

    private static void initMapping() {
        descriptorClasses = new HashMap();
        DescriptorFactory.register(new XMLElement("application-param"), EnvironmentProperty.class);
        DescriptorFactory.register(new XMLElement("connector"), ConnectorDescriptor.class);
        DescriptorFactory.register(new XMLElement("outbound-resourceadapter"), OutboundResourceAdapter.class);
        DescriptorFactory.register(new XMLElement("inbound-resourceadapter"), InboundResourceAdapter.class);
        DescriptorFactory.register(new XMLElement("resourceadapter"), OutboundResourceAdapter.class);
        DescriptorFactory.register(new XMLElement("authentication-mechanism"), AuthMechanism.class);
        DescriptorFactory.register(new XMLElement("security-permission"), SecurityPermission.class);
        DescriptorFactory.register(new XMLElement("license"), LicenseDescriptor.class);
        DescriptorFactory.register(new XMLElement("config-property"), ConnectorConfigProperty.class);
        DescriptorFactory.register(new XMLElement("required-config-property"), ConnectorConfigProperty.class);
        DescriptorFactory.register(new XMLElement("messagelistener"), MessageListener.class);
        DescriptorFactory.register(new XMLElement("activationspec"), MessageListener.class);
        DescriptorFactory.register(new XMLElement("adminobject"), AdminObject.class);
        DescriptorFactory.register(new XMLElement("connection-definition"), ConnectionDefDescriptor.class);
        DescriptorFactory.register(new XMLElement("service-ref"), ServiceReferenceDescriptor.class);
        DescriptorFactory.register(new XMLElement("port-info"), ServiceRefPortInfo.class);
        DescriptorFactory.register(new XMLElement("stub-property"), NameValuePairDescriptor.class);
        DescriptorFactory.register(new XMLElement("call-property"), NameValuePairDescriptor.class);
        DescriptorFactory.register(new XMLElement("persistence-unit"), PersistenceUnitDescriptor.class);
        DescriptorFactory.register(new XMLElement("persistence-context-ref"), EntityManagerReferenceDescriptor.class);
        DescriptorFactory.register(new XMLElement("persistence-unit-ref"), EntityManagerFactoryReferenceDescriptor.class);
    }

    public static void register(XMLElement xmlPath, Class clazz) {
        if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
            DOLUtils.getDefaultLogger().fine("Register " + clazz + " to handle " + xmlPath.getQName());
        }
        descriptorClasses.put(xmlPath.getQName(), clazz);
    }

    public static Class getDescriptorClass(String xmlPath) {
        String s = xmlPath;
        do {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINER)) {
                DOLUtils.getDefaultLogger().finer("looking for " + xmlPath);
            }
            if (!descriptorClasses.containsKey(xmlPath)) continue;
            return (Class)descriptorClasses.get(xmlPath);
        } while ((xmlPath = xmlPath.indexOf(47) != -1 ? xmlPath.substring(xmlPath.indexOf(47) + 1) : null) != null);
        if (DOLUtils.getDefaultLogger().isLoggable(Level.SEVERE)) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "AS-DEPLOYMENT-00015", new Object[]{"No descriptor registered for " + s});
        }
        return null;
    }

    public static Object getDescriptor(String xmlPath) {
        try {
            Class c = DescriptorFactory.getDescriptorClass(xmlPath);
            if (c != null) {
                return c.newInstance();
            }
        }
        catch (Throwable t) {
            DOLUtils.getDefaultLogger().log(Level.WARNING, "Error occurred", t);
        }
        return null;
    }

    static {
        DescriptorFactory.initMapping();
    }
}

