/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.monitoring;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.webservices.monitoring.Endpoint;
import org.glassfish.webservices.monitoring.EndpointType;
import org.glassfish.webservices.monitoring.MessageListener;
import org.glassfish.webservices.monitoring.TransportType;

public class EndpointImpl
implements Endpoint {
    public static final String NAME = "MONITORING_ENDPOINT";
    public static final String MESSAGE_ID = "MONITORING_MESSAGE_ID";
    public static final String REQUEST_TRACE = "MONITORING_REQUEST_MESSAGE_TRACE";
    final String endpointSelector;
    final EndpointType type;
    WebServiceEndpoint endpointDesc;
    List<MessageListener> listeners = new ArrayList<MessageListener>();

    EndpointImpl(String endpointSelector, EndpointType type) {
        this.endpointSelector = endpointSelector;
        this.type = type;
    }

    @Override
    public String getEndpointSelector() {
        return this.endpointSelector;
    }

    @Override
    public EndpointType getEndpointType() {
        return this.type;
    }

    @Override
    public TransportType getTransport() {
        return TransportType.HTTP;
    }

    @Override
    public void addListener(MessageListener newListener) {
        this.listeners.add(newListener);
    }

    @Override
    public void removeListener(MessageListener listener) {
        this.listeners.remove(listener);
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    @Override
    public WebServiceEndpoint getDescriptor() {
        return this.endpointDesc;
    }

    public void setDescriptor(WebServiceEndpoint endpointDesc) {
        if (endpointDesc != null) {
            endpointDesc.addExtraAttribute(NAME, (Object)this);
        }
        this.endpointDesc = endpointDesc;
    }
}

