/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.cli.resources;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.RefContainer;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.inject.Inject;
import org.glassfish.admin.cli.resources.CLIUtil;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@TargetType(value={CommandTarget.CONFIG, CommandTarget.DAS, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.DELETE, path="delete-resource-ref", description="delete-resource-ref")})
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@Service(name="delete-resource-ref")
@PerLookup
@I18n(value="delete.resource.ref")
public class DeleteResourceRef
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteResourceRef.class);
    @Param(optional=true)
    private String target = "server";
    @Param(name="reference_name", primary=true)
    private String refName;
    @Inject
    private ConfigBeansUtilities configBeanUtilities;
    @Inject
    private ServiceLocator habitat;
    @Inject
    private Domain domain;
    @Inject
    private ConfigBeansUtilities configBeansUtilities;
    private RefContainer refContainer = null;
    @AccessRequired.To(value={"delete"})
    private ResourceRef resourceRef = null;

    public boolean preAuthorization(AdminCommandContext context) {
        this.refContainer = CLIUtil.chooseRefContainer(this.domain, this.target, this.configBeansUtilities);
        if (this.refContainer != null) {
            this.resourceRef = this.getResourceRef();
        }
        if (this.resourceRef == null) {
            this.setResourceRefDoNotExistMessage(context.getActionReport());
        }
        return this.resourceRef != null;
    }

    private ResourceRef getResourceRef() {
        for (ResourceRef rr : this.refContainer.getResourceRef()) {
            if (!rr.getRef().equals(this.refName)) continue;
            return rr;
        }
        return null;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            if (this.refName.equals("jdbc/__default")) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(localStrings.getLocalString("delete.resource.ref.jdbc.default", "Default JDBC resource ref cannot be deleted."));
                return;
            }
            if (this.refName.equals("jms/__defaultConnectionFactory")) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(localStrings.getLocalString("delete.resource.ref.jms.default", "Default JMS connection factory ref cannot be deleted."));
                return;
            }
            this.deleteResourceRef();
            if (this.refContainer instanceof Cluster) {
                Target tgt = (Target)this.habitat.getService(Target.class, new Annotation[0]);
                List instances = tgt.getInstances(this.target);
                for (Server svr : instances) {
                    svr.deleteResourceRef(this.refName);
                }
            }
        }
        catch (Exception e) {
            this.setFailureMessage(report, e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        report.setMessage(localStrings.getLocalString("delete.resource.ref.success", "resource-ref {0} deleted successfully from target {1}.", new Object[]{this.refName, this.target}));
    }

    private void deleteResourceRef() throws TransactionFailure {
        if (this.resourceRef != null) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<RefContainer>(){

                public Object run(RefContainer param) {
                    return param.getResourceRef().remove(DeleteResourceRef.this.resourceRef);
                }
            }, (ConfigBeanProxy)this.refContainer);
        }
    }

    private void setResourceRefDoNotExistMessage(ActionReport report) {
        report.setMessage(localStrings.getLocalString("delete.resource.ref.doesNotExist", "A resource ref named {0} does not exist for target {1}.", new Object[]{this.refName, this.target}));
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
    }

    private void setFailureMessage(ActionReport report, Exception e) {
        report.setMessage(localStrings.getLocalString("delete.resource.ref.failed", "Resource ref {0} deletion failed", new Object[]{this.refName}));
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        report.setFailureCause((Throwable)e);
    }
}

