package org.apache.jsp;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import java.io.IOException;
import javax.servlet.jsp.el.ExpressionEvaluator;
import com.sun.ts.tests.jsp.common.util.TSFunctionMapper;
import javax.servlet.jsp.el.Expression;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;
import java.io.PrintWriter;

public final class ExpressionEvaluatorTest_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


    private static final String PAGECONTEXT_ATTR =
        "com.sun.ts.tests.jsp.api.pageContext";
    private static final String QUAL_METHOD_EXPR =
        "${ns:lowerCase('STRING')}";
    private static final String UNQUAL_METHOD_EXPR =
        "${lowerCase('STRING')}";
    private static final String DEFAULT_PREFIX ="";
    private static final String METHOD_PREFIX = "ns";
    private static final String METHOD_NAME = "lowerCase";
    private static final String VARIABLE_EXPR =
        "${requestScope['com.sun.ts.tests.jsp.api.pageContext']}";


    public void expressionEvaluatorParseExpressionTest(HttpServletRequest req,
                                                       HttpServletResponse res,
                                                       JspWriter out)
    throws ServletException, IOException {
        PageContext pc = (PageContext) req.getAttribute(PAGECONTEXT_ATTR);
        if (pc != null) {
            TSFunctionMapper mapper = new TSFunctionMapper();
            ExpressionEvaluator eval = pc.getExpressionEvaluator();
            if (eval != null) {
                try {
                    Expression expr = eval.parseExpression(QUAL_METHOD_EXPR,
                        java.lang.String.class, mapper);
                    if (expr != null) {
                        try {
                            Expression expr2 = eval.parseExpression(VARIABLE_EXPR,
                                javax.servlet.jsp.PageContext.class, null);
                            if (expr2 != null) {
                                try {
                                    Expression expr3 = eval.parseExpression(UNQUAL_METHOD_EXPR,
                                        java.lang.String.class, mapper);
                                    if (expr3 != null) {
                                        out.println("Test PASSED");
                                    } else {
                                        out.println("Test FAILED. (l3) ExpressionEvaluator.parseExpression" +
                                            " returned null.");
                                    }
                                } catch (ELException ele) {
                                    JspTestUtil.handleThrowable(ele, out, "(l3)");
                                    return;
                                }
                        } else {
                            out.println("Test FAILED. (l2) ExpressionEvaluator.parseExpression" +
                                " returned null.");
                        }
                        } catch (Throwable t) {
                            JspTestUtil.handleThrowable(t, out, "(l2)");
                            return;
                        }

                    } else {
                        out.println("Test FAILED. (l1) ExpressionEvaluator.parseExpression" +
                            " returned null.");
                    }
                } catch (ELException ele) {
                    JspTestUtil.handleThrowable(ele, out, "(l1)");
                    return;
                }
            }
        } else {
            out.println("Test FAILED.  Unable to obtain PageContext.");
        }
    }


    public void expressionEvaluatorEvaluateTest(HttpServletRequest req,
                                                 HttpServletResponse res,
                                                 JspWriter out)
    throws ServletException, IOException {
        PageContext pc = (PageContext) req.getAttribute(PAGECONTEXT_ATTR);
        if (pc != null) {
            ExpressionEvaluator eval = pc.getExpressionEvaluator();
            VariableResolver resolver = pc.getVariableResolver();
            if (eval != null) {
                TSFunctionMapper mapper = new TSFunctionMapper();

                // first part of this test will validate that
                // the FunctionMapper is used property during
                // the evaluation of the expression.
                try {
                    Object o1 = eval.evaluate(QUAL_METHOD_EXPR,
                        java.lang.String.class, resolver, mapper);
                    if (!mapper.hasResolved()) {
                        out.println("Test FAILED.  FunctionMapper.resolveFunction" +
                            " was not called on the provided FunctionMapper (l1).");
                        return;
                    }
                    String prefix = mapper.getPrefixUsed();
                    String method = mapper.getMethodCalled();

                    if (prefix == null || !prefix.equals(METHOD_PREFIX)) {
                        out.println("Test FAILED.  FunctionMapper called with " +
                            "unexpected prefix: " + prefix + ".  Expected 'ns'.");
                        return;
                    }

                    if (method == null || !method.equals(METHOD_NAME)) {
                        out.println("Test FAILED.  FunctionMapper called with " +
                            "unexpected method: " + method + ".  Expected: lowerCase");
                        return;
                    }

                    if (o1 != null) {

                        if (!o1.equals("string")) {
                            out.println("Test FAILED.  (o1) Method return value was incorrect.");
                            out.println("Expected 'string', received: '" + o1.toString() +"'");
                            return;
                        }
                        // next verify that a null FunctionMapper can be
                        // passed without an Exception occuring.  This also
                        // validates that the VariableResolver is used properly.
                        try {
                            Object o2 = eval.evaluate(VARIABLE_EXPR,
                                javax.servlet.jsp.PageContext.class, resolver, null);
                            if (o2 != null) {
                                if (o2 != pc) {
                                    out.println("Test FAILED.  Variable resolution and thus expression evaluation failed.");
                                    out.println("The request scoped PageContext returned by expression was not correct.");
                                    return;
                                }
                                // next verify that the default namespace is used
                                // if no namespace is provided.
                                try {
                                    mapper.reset();
                                    Object o3 = eval.evaluate(UNQUAL_METHOD_EXPR,
                                        java.lang.String.class, resolver, mapper);
                                    if (!mapper.hasResolved()) {
                                        out.println("Test FAILED.  FunctionMapper.resolveFunction" +
                                            " was not called on the provided FunctionMapper (l2).");
                                        return;
                                    }

                                    prefix = mapper.getPrefixUsed();
                                    method = mapper.getMethodCalled();

                                    if (prefix == null || !prefix.equals(DEFAULT_PREFIX)) {
                                        out.println("Test FAILED.  FunctionMapper called with " +
                                            "unexpected prefix: '" + prefix + "'.  Expected ''.");
                                        return;
                                    }

                                    if (method == null || !method.equals(METHOD_NAME)) {
                                        out.println("Test FAILED.  FunctionMapper called with " +
                                            "unexpected method: '" + method + "'.  Expected 'lowerCase'.");
                                        return;
                                    }

                                    if (o3 != null) {
                                        if (o3.equals("string")) {
                                            out.println("Test PASSED");
                                        } else {
                                            out.println("Test FAILED.  (o3) Method return value was incorrect.");
                                            out.println("Expected 'meth', received: '" + o3.toString() + "'");
                                            return;
                                        }
                                    } else {
                                        out.println("Test FAILED.  Null expression (expr2) returned.");
                                    }
                                } catch (ELException ele) {
                                    JspTestUtil.handleThrowable(ele, out, "(l3)");
                                    return;
                                }
                            } else {
                                out.println("Test FAILED.  Null expression (expr1) returned.");
                            }
                        } catch (Throwable t) {
                            JspTestUtil.handleThrowable(t, out, "(l2)");
                            return;
                        }
                    } else {
                        out.println("Test FAILED.  Null expression (expr) returned.");
                    }
                } catch (ELException ele) {
                    JspTestUtil.handleThrowable(ele, out, "(l1)");
                    return;
                }
            } else {
                out.println("Test FAILED.  Unable to obtain ExpressionEvaluator.");
            }
        } else {
            out.println("Test FAILED.  Unable to obtain PageContext.");
        }
    }

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List<String> _jspx_dependants;

  private org.glassfish.jsp.api.ResourceInjector _jspx_resourceInjector;

  public java.util.List<String> getDependants() {
    return _jspx_dependants;
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;

    try {
      response.setContentType("text/plain");
      response.setHeader("X-Powered-By", "JSP/2.3");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;
      _jspx_resourceInjector = (org.glassfish.jsp.api.ResourceInjector) application.getAttribute("com.sun.appserv.jsp.resource.injector");

      out.write("\n");
      out.write("\n");
      out.write("\n");
      out.write("\n");
      out.write("\n");
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');

    request.setAttribute(PAGECONTEXT_ATTR, pageContext);
    JspTestUtil.invokeTest(this, request, response, out);

      out.write('\n');
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          out.clearBuffer();
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
        else throw new ServletException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
