/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.generator.database;

import com.sun.jdo.spi.persistence.generator.database.JDBCInfo;
import com.sun.jdo.spi.persistence.generator.database.MappingPolicy;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ColumnPairElement;
import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.IndexElement;
import org.netbeans.modules.dbschema.KeyElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.UniqueKeyElement;
import org.netbeans.modules.dbschema.jdbcimpl.ColumnElementImpl;
import org.netbeans.modules.dbschema.jdbcimpl.ColumnPairElementImpl;
import org.netbeans.modules.dbschema.jdbcimpl.ForeignKeyElementImpl;
import org.netbeans.modules.dbschema.jdbcimpl.IndexElementImpl;
import org.netbeans.modules.dbschema.jdbcimpl.SchemaElementImpl;
import org.netbeans.modules.dbschema.jdbcimpl.TableElementImpl;
import org.netbeans.modules.dbschema.jdbcimpl.UniqueKeyElementImpl;
import org.netbeans.modules.dbschema.util.NameUtil;

class DBElementFactory {
    private static final String TAGLINE = "generated schema version ";
    private static final String SIGNATURE = "$RCSfile: DBElementFactory.java,v $ $Revision: 1.3 $";
    private static final String UNKNOWN_FIELD_TYPE = "java.lang.Long";
    private static final String DEFAULT_FIELD_TYPE = "java.lang.Object";

    private DBElementFactory() {
    }

    static SchemaElement createSchema(String schemaName) throws DBException {
        SchemaElementImpl schemaImpl = new SchemaElementImpl();
        SchemaElement schema = new SchemaElement((SchemaElement.Impl)schemaImpl);
        schema.setName(DBIdentifier.create((String)schemaName));
        schema.setDatabaseProductVersion("generated schema version $RCSfile: DBElementFactory.java,v $ $Revision: 1.3 $");
        return schema;
    }

    static TableElement createAndAttachTable(SchemaElement schema, String tableName) throws DBException {
        String fullName = NameUtil.getAbsoluteTableName((String)schema.getName().getName(), (String)tableName);
        TableElementImpl tableImpl = new TableElementImpl(tableName);
        TableElement table = new TableElement((TableElement.Impl)tableImpl, schema);
        table.setName(DBIdentifier.create((String)fullName));
        table.setTableOrView(true);
        schema.addTable(table);
        return table;
    }

    static ColumnElement createAndAttachColumn(String columnName, TableElement table, JDBCInfo ji) throws DBException {
        String fullName = NameUtil.getAbsoluteMemberName((String)table.getName().getName(), (String)columnName);
        DBIdentifier columnId = DBIdentifier.create((String)columnName);
        ColumnElementImpl columnImpl = new ColumnElementImpl();
        ColumnElement column = new ColumnElement((ColumnElement.Impl)columnImpl, table);
        column.setName(columnId);
        column.setType(ji.getJdbcType());
        column.setNullable(ji.getNullable());
        column.setPrecision(ji.getPrecision());
        column.setScale(ji.getScale());
        column.setLength(ji.getLength());
        table.addColumn(column);
        return column;
    }

    static ColumnPairElement createColumnPair(ColumnElement column, ColumnElement refColumn, TableElement declaringTbl) throws DBException {
        ColumnPairElementImpl pairImpl = new ColumnPairElementImpl();
        ColumnPairElement pair = new ColumnPairElement((ColumnPairElement.Impl)pairImpl, column, refColumn, declaringTbl);
        return pair;
    }

    static UniqueKeyElement createAndAttachPrimaryKey(TableElement table, String pKeyName) throws DBException {
        String tableName = table.getName().getName();
        String fullName = NameUtil.getAbsoluteMemberName((String)tableName, (String)pKeyName);
        TableElementImpl tableImpl = (TableElementImpl)table.getElementImpl();
        IndexElementImpl indexImpl = new IndexElementImpl(tableImpl, fullName, true);
        IndexElement index = new IndexElement((IndexElement.Impl)indexImpl, table);
        index.setUnique(true);
        UniqueKeyElementImpl pKeyImpl = new UniqueKeyElementImpl();
        UniqueKeyElement pKey = new UniqueKeyElement((UniqueKeyElement.Impl)pKeyImpl, table, index);
        pKey.setName(DBIdentifier.create((String)fullName));
        pKey.setPrimaryKey(true);
        table.addKey((KeyElement)pKey);
        table.addIndex(pKey.getAssociatedIndex());
        return pKey;
    }

    static ForeignKeyElement createAndAttachForeignKey(TableElement declaringTbl, TableElement refTbl, String keyName, MappingPolicy mappingPolicy, String uniqueId) throws DBException {
        String fkeyName = mappingPolicy.getConstraintName(keyName, uniqueId);
        TableElementImpl tableImpl = (TableElementImpl)declaringTbl.getElementImpl();
        ForeignKeyElementImpl fkeyImpl = new ForeignKeyElementImpl(tableImpl, fkeyName);
        ForeignKeyElement fkey = new ForeignKeyElement((ForeignKeyElement.Impl)fkeyImpl, declaringTbl);
        UniqueKeyElement pk = refTbl.getPrimaryKey();
        ColumnElement[] pkColumns = pk.getColumns();
        String refTblName = refTbl.getName().getName();
        if (pkColumns != null) {
            for (int i = 0; i < pkColumns.length; ++i) {
                ColumnElement refColumn = pkColumns[i];
                String columnName = mappingPolicy.getConstraintColumnName(refTblName, refColumn.getName().getName());
                JDBCInfo ji = new JDBCInfo(refColumn.getType(), refColumn.getPrecision(), refColumn.getScale(), refColumn.getLength(), true);
                ColumnElement column = DBElementFactory.createAndAttachColumn(columnName, declaringTbl, ji);
                ColumnPairElement pair = DBElementFactory.createColumnPair(column, refColumn, declaringTbl);
                fkey.addColumnPair(pair);
            }
        }
        declaringTbl.addKey((KeyElement)fkey);
        return fkey;
    }

    static JDBCInfo getColumnType(String fieldName, String fieldType, MappingPolicy mappingPolicy) {
        JDBCInfo rc;
        if (fieldType == null) {
            fieldType = UNKNOWN_FIELD_TYPE;
        }
        if (null == (rc = mappingPolicy.getJDBCInfo(fieldName, fieldType))) {
            rc = mappingPolicy.getJDBCInfo(null, DEFAULT_FIELD_TYPE);
        }
        return rc;
    }
}

