/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.protocol;

import com.sun.corba.ee.impl.corba.RequestImpl;
import com.sun.corba.ee.impl.encoding.BufferManagerWrite;
import com.sun.corba.ee.impl.encoding.CDRInputObject;
import com.sun.corba.ee.impl.encoding.CDROutputObject;
import com.sun.corba.ee.impl.encoding.EncapsOutputStream;
import com.sun.corba.ee.impl.encoding.OutputStreamFactory;
import com.sun.corba.ee.impl.misc.ORBUtility;
import com.sun.corba.ee.impl.protocol.AddressingDispositionException;
import com.sun.corba.ee.impl.protocol.RequestCanceledException;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.AddressingDispositionHelper;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.CancelRequestMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.FragmentMessage_1_1;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.FragmentMessage_1_2;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.LocateReplyMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.LocateReplyMessage_1_0;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.LocateReplyMessage_1_1;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.LocateReplyMessage_1_2;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.LocateReplyOrReplyMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.LocateRequestMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.LocateRequestMessage_1_0;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.LocateRequestMessage_1_1;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.LocateRequestMessage_1_2;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.MessageHandler;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message_1_2;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.ReplyMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.ReplyMessage_1_0;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.ReplyMessage_1_1;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.ReplyMessage_1_2;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.RequestMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.RequestMessage_1_0;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.RequestMessage_1_1;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.RequestMessage_1_2;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.ObjectKey;
import com.sun.corba.ee.spi.ior.TaggedComponent;
import com.sun.corba.ee.spi.ior.Writeable;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.ior.iiop.MaxStreamFormatVersionComponent;
import com.sun.corba.ee.spi.logging.InterceptorsSystemException;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.oa.OAInvocationInfo;
import com.sun.corba.ee.spi.oa.ObjectAdapter;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ObjectKeyCacheEntry;
import com.sun.corba.ee.spi.protocol.ForwardException;
import com.sun.corba.ee.spi.protocol.MessageMediator;
import com.sun.corba.ee.spi.protocol.ProtocolHandler;
import com.sun.corba.ee.spi.protocol.RequestId;
import com.sun.corba.ee.spi.protocol.ServerRequestDispatcher;
import com.sun.corba.ee.spi.servicecontext.MaxStreamFormatVersionServiceContext;
import com.sun.corba.ee.spi.servicecontext.ORBVersionServiceContext;
import com.sun.corba.ee.spi.servicecontext.SendingContextServiceContext;
import com.sun.corba.ee.spi.servicecontext.ServiceContextDefaults;
import com.sun.corba.ee.spi.servicecontext.ServiceContexts;
import com.sun.corba.ee.spi.servicecontext.ServiceContextsCache;
import com.sun.corba.ee.spi.servicecontext.UEInfoServiceContext;
import com.sun.corba.ee.spi.servicecontext.UnknownServiceContext;
import com.sun.corba.ee.spi.threadpool.NoSuchThreadPoolException;
import com.sun.corba.ee.spi.threadpool.NoSuchWorkQueueException;
import com.sun.corba.ee.spi.threadpool.Work;
import com.sun.corba.ee.spi.trace.Subcontract;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.Connection;
import com.sun.corba.ee.spi.transport.ContactInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.Queue;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.Request;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UnknownUserException;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.UnknownException;
import org.omg.CORBA_2_3.portable.InputStream;

@Subcontract
@Transport
public class MessageMediatorImpl
implements MessageMediator,
ProtocolHandler,
MessageHandler,
Work {
    protected static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    protected static final InterceptorsSystemException interceptorWrapper = InterceptorsSystemException.self;
    protected ORB orb;
    protected ContactInfo contactInfo;
    protected Connection connection;
    protected short addrDisposition;
    protected CDROutputObject outputObject;
    protected CDRInputObject inputObject;
    protected Message messageHeader;
    protected RequestMessage requestHeader;
    protected LocateReplyOrReplyMessage replyHeader;
    protected String replyExceptionDetailMessage;
    protected IOR replyIOR;
    protected Message dispatchHeader;
    protected ByteBuffer dispatchByteBuffer;
    protected byte streamFormatVersion;
    protected boolean streamFormatVersionSet = false;
    protected Request diiRequest;
    protected boolean cancelRequestAlreadySent = false;
    protected ProtocolHandler protocolHandler;
    protected boolean _executeReturnServantInResponseConstructor = false;
    protected boolean _executeRemoveThreadInfoInResponseConstructor = false;
    protected boolean _executePIInResponseConstructor = false;
    private static byte localMaxVersion = ORBUtility.getMaxStreamFormatVersion();
    private long enqueueTime;
    protected boolean isThreadDone = false;

    public MessageMediatorImpl(ORB orb, ContactInfo contactInfo, Connection connection, GIOPVersion giopVersion, IOR ior, int requestId, short addrDisposition, String operationName, boolean isOneWay) {
        this(orb, connection);
        this.contactInfo = contactInfo;
        this.addrDisposition = addrDisposition;
        this.streamFormatVersion = this.getStreamFormatVersionForThisRequest(this.contactInfo.getEffectiveTargetIOR(), giopVersion);
        this.streamFormatVersionSet = true;
        byte encodingVersion = ORBUtility.chooseEncodingVersion(orb, ior, giopVersion);
        ORBUtility.pushEncVersionToThreadLocalState(encodingVersion);
        this.requestHeader = MessageBase.createRequest(this.orb, giopVersion, encodingVersion, requestId, !isOneWay, this.contactInfo.getEffectiveTargetIOR(), this.addrDisposition, operationName, ServiceContextDefaults.makeServiceContexts(orb), null);
    }

    private MessageMediatorImpl(ORB orb, Connection connection) {
        this.orb = orb;
        this.connection = connection;
    }

    public MessageMediatorImpl(ORB orb, Connection connection, Message dispatchHeader, ByteBuffer byteBuffer) {
        this(orb, connection);
        this.dispatchHeader = dispatchHeader;
        this.dispatchByteBuffer = byteBuffer;
    }

    @Override
    public RequestId getRequestIdFromRawBytes() {
        return MessageBase.getRequestIdFromMessageBytes(this.getDispatchHeader(), this.dispatchByteBuffer);
    }

    @Override
    public ORB getBroker() {
        return this.orb;
    }

    @Override
    public ContactInfo getContactInfo() {
        return this.contactInfo;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void initializeMessage() {
        this.getRequestHeader().write((OutputStream)this.outputObject);
    }

    @Override
    public void finishSendingRequest() {
        this.outputObject.finishSendingMessage();
    }

    @Override
    public CDRInputObject waitForResponse() {
        if (this.getRequestHeader().isResponseExpected()) {
            return this.connection.waitForResponse(this);
        }
        return null;
    }

    @Override
    public void setOutputObject(CDROutputObject outputObject) {
        this.outputObject = outputObject;
    }

    @Override
    public CDROutputObject getOutputObject() {
        return this.outputObject;
    }

    @Override
    public void setInputObject(CDRInputObject inputObject) {
        this.inputObject = inputObject;
    }

    @Override
    public CDRInputObject getInputObject() {
        return this.inputObject;
    }

    @Override
    public void setReplyHeader(LocateReplyOrReplyMessage header) {
        this.replyHeader = header;
        this.replyIOR = header.getIOR();
    }

    @Override
    public LocateReplyMessage getLocateReplyHeader() {
        return (LocateReplyMessage)this.replyHeader;
    }

    @Override
    public ReplyMessage getReplyHeader() {
        return (ReplyMessage)this.replyHeader;
    }

    @Override
    public void setReplyExceptionDetailMessage(String message) {
        this.replyExceptionDetailMessage = message;
    }

    @Override
    public RequestMessage getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    public GIOPVersion getGIOPVersion() {
        if (this.messageHeader != null) {
            return this.messageHeader.getGIOPVersion();
        }
        if (this.getRequestHeader() == null) {
            return GIOPVersion.V1_2;
        }
        return this.getRequestHeader().getGIOPVersion();
    }

    @Override
    public byte getEncodingVersion() {
        if (this.messageHeader != null) {
            return this.messageHeader.getEncodingVersion();
        }
        if (this.getRequestHeader() == null) {
            return 0;
        }
        return this.getRequestHeader().getEncodingVersion();
    }

    @Override
    public int getRequestId() {
        if (this.getRequestHeader() == null) {
            return -1;
        }
        return this.getRequestHeader().getRequestId();
    }

    @Override
    public boolean isOneWay() {
        if (this.getRequestHeader() == null) {
            return false;
        }
        return !this.getRequestHeader().isResponseExpected();
    }

    @Override
    public String getOperationName() {
        if (this.getRequestHeader() == null) {
            return "UNKNOWN";
        }
        return this.getRequestHeader().getOperation();
    }

    @Override
    public ServiceContexts getRequestServiceContexts() {
        if (this.getRequestHeader() == null) {
            return null;
        }
        return this.getRequestHeader().getServiceContexts();
    }

    @Override
    public void setRequestServiceContexts(ServiceContexts sc) {
        this.getRequestHeader().setServiceContexts(sc);
    }

    @Override
    public ServiceContexts getReplyServiceContexts() {
        return this.getReplyHeader().getServiceContexts();
    }

    @Override
    @Subcontract
    public void sendCancelRequestIfFinalFragmentNotSent() {
        if (!this.sentFullMessage() && this.sentFragment() && !this.cancelRequestAlreadySent && !this.connection.isClosed()) {
            try {
                this.connection.sendCancelRequestWithLock(this.getGIOPVersion(), this.getRequestId());
                this.cancelRequestAlreadySent = true;
            }
            catch (SystemException se) {
                if (se.minor == ORBUtilSystemException.CONNECTION_REBIND) {
                    this.connection.purgeCalls(se, true, false);
                }
                throw se;
            }
            catch (IOException e) {
                throw interceptorWrapper.ioexceptionDuringCancelRequest(e);
            }
        }
    }

    @Subcontract
    public boolean sentFullMessage() {
        if (this.outputObject == null) {
            return false;
        }
        return this.outputObject.getBufferManager().sentFullMessage();
    }

    @Subcontract
    public boolean sentFragment() {
        BufferManagerWrite buffMan;
        if (this.outputObject != null && (buffMan = this.outputObject.getBufferManager()) != null) {
            return this.outputObject.getBufferManager().sentFragment();
        }
        return false;
    }

    @Override
    public void setDIIInfo(Request diiRequest) {
        this.diiRequest = diiRequest;
    }

    @Override
    public boolean isDIIRequest() {
        return this.diiRequest != null;
    }

    @Override
    @Subcontract
    public Exception unmarshalDIIUserException(String repoId, InputStream is) {
        if (!this.isDIIRequest()) {
            return null;
        }
        ExceptionList _exceptions = this.diiRequest.exceptions();
        try {
            for (int i = 0; i < _exceptions.count(); ++i) {
                TypeCode tc = _exceptions.item(i);
                if (!tc.id().equals(repoId)) continue;
                Any eany = this.orb.create_any();
                eany.read_value((org.omg.CORBA.portable.InputStream)is, tc);
                return new UnknownUserException(eany);
            }
        }
        catch (Exception b) {
            throw wrapper.unexpectedDiiException(b);
        }
        return wrapper.unknownCorbaExc();
    }

    @Override
    public void setDIIException(Exception exception) {
        this.diiRequest.env().exception(exception);
    }

    @Override
    public void handleDIIReply(InputStream inputStream) {
        if (!this.isDIIRequest()) {
            return;
        }
        ((RequestImpl)this.diiRequest).unmarshalReply((org.omg.CORBA.portable.InputStream)inputStream);
    }

    @Override
    public Message getDispatchHeader() {
        return this.dispatchHeader;
    }

    @Override
    public int getThreadPoolToUse() {
        int poolToUse = 0;
        Message msg = this.dispatchHeader;
        if (msg != null) {
            poolToUse = msg.getThreadPoolToUse();
        }
        return poolToUse;
    }

    @InfoMethod
    private void reportException(String msg, Throwable thr) {
    }

    @InfoMethod
    private void reportConnection(Connection conn) {
    }

    @Override
    @Transport
    public boolean dispatch() {
        this.reportConnection(this.connection);
        try {
            boolean result = this.getProtocolHandler().handleRequest(this);
            return result;
        }
        catch (ThreadDeath td) {
            try {
                this.connection.purgeCalls((SystemException)wrapper.connectionAbort(td), false, false);
            }
            catch (Throwable t) {
                this.reportException("ThreadDeatch exception in dispatch", t);
            }
            throw td;
        }
        catch (Throwable ex) {
            this.reportException("Exception in dispatch", ex);
            try {
                if (ex instanceof INTERNAL) {
                    this.connection.sendMessageError(GIOPVersion.DEFAULT_VERSION);
                }
            }
            catch (IOException e) {
                this.reportException("Exception in sendMessageError", ex);
            }
            this.connection.purgeCalls((SystemException)wrapper.connectionAbort(ex), false, false);
            return true;
        }
    }

    @Override
    public byte getStreamFormatVersion() {
        if (this.streamFormatVersionSet) {
            return this.streamFormatVersion;
        }
        return this.getStreamFormatVersionForReply();
    }

    @Override
    @Transport
    public byte getStreamFormatVersionForReply() {
        ServiceContexts svc = this.getRequestServiceContexts();
        MaxStreamFormatVersionServiceContext msfvsc = (MaxStreamFormatVersionServiceContext)svc.get(17);
        if (msfvsc != null) {
            byte remoteMaxVersion = msfvsc.getMaximumStreamFormatVersion();
            return (byte)Math.min(localMaxVersion, remoteMaxVersion);
        }
        if (this.getGIOPVersion().lessThan(GIOPVersion.V1_3)) {
            return 1;
        }
        return 2;
    }

    @Override
    public boolean isSystemExceptionReply() {
        return this.replyHeader.getReplyStatus() == 2;
    }

    @Override
    public boolean isUserExceptionReply() {
        return this.replyHeader.getReplyStatus() == 1;
    }

    @Override
    public boolean isLocationForwardReply() {
        return this.replyHeader.getReplyStatus() == 3 || this.replyHeader.getReplyStatus() == 4;
    }

    @Override
    public boolean isDifferentAddrDispositionRequestedReply() {
        return this.replyHeader.getReplyStatus() == 5;
    }

    @Override
    public short getAddrDispositionReply() {
        return this.replyHeader.getAddrDisposition();
    }

    @Override
    public IOR getForwardedIOR() {
        return this.replyHeader.getIOR();
    }

    @Override
    public SystemException getSystemExceptionReply() {
        return this.replyHeader.getSystemException(this.replyExceptionDetailMessage);
    }

    @Override
    public ObjectKeyCacheEntry getObjectKeyCacheEntry() {
        return this.getRequestHeader().getObjectKeyCacheEntry();
    }

    @Override
    public ProtocolHandler getProtocolHandler() {
        return this;
    }

    @Override
    public OutputStream createReply() {
        this.getProtocolHandler().createResponse(this, null);
        return this.getOutputObject();
    }

    @Override
    public OutputStream createExceptionReply() {
        this.getProtocolHandler().createUserExceptionResponse(this, null);
        return this.getOutputObject();
    }

    @Override
    public boolean executeReturnServantInResponseConstructor() {
        return this._executeReturnServantInResponseConstructor;
    }

    @Override
    public void setExecuteReturnServantInResponseConstructor(boolean b) {
        this._executeReturnServantInResponseConstructor = b;
    }

    @Override
    public boolean executeRemoveThreadInfoInResponseConstructor() {
        return this._executeRemoveThreadInfoInResponseConstructor;
    }

    @Override
    public void setExecuteRemoveThreadInfoInResponseConstructor(boolean b) {
        this._executeRemoveThreadInfoInResponseConstructor = b;
    }

    @Override
    public boolean executePIInResponseConstructor() {
        return this._executePIInResponseConstructor;
    }

    @Override
    public void setExecutePIInResponseConstructor(boolean b) {
        this._executePIInResponseConstructor = b;
    }

    @Transport
    private byte getStreamFormatVersionForThisRequest(IOR ior, GIOPVersion giopVersion) {
        IOR effectiveTargetIOR = this.contactInfo.getEffectiveTargetIOR();
        IIOPProfileTemplate temp = (IIOPProfileTemplate)effectiveTargetIOR.getProfile().getTaggedProfileTemplate();
        Iterator<TaggedComponent> iter = temp.iteratorById(38);
        if (!iter.hasNext()) {
            if (giopVersion.lessThan(GIOPVersion.V1_3)) {
                return 1;
            }
            return 2;
        }
        byte remoteMaxVersion = ((MaxStreamFormatVersionComponent)iter.next()).getMaxStreamFormatVersion();
        return (byte)Math.min(localMaxVersion, remoteMaxVersion);
    }

    @Override
    @Transport
    public boolean handleRequest(MessageMediator messageMediator) {
        try {
            byte encodingVersion = this.dispatchHeader.getEncodingVersion();
            ORBUtility.pushEncVersionToThreadLocalState(encodingVersion);
            this.dispatchHeader.callback(this);
        }
        catch (IOException iOException) {
        }
        finally {
            ORBUtility.popEncVersionFromThreadLocalState();
        }
        return this.isThreadDone;
    }

    @InfoMethod
    private void messageInfo(Message msg, RequestId rid) {
    }

    @InfoMethod
    private void connectionInfo(Connection conn) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transport
    private void resumeOptimizedReadProcessing(Message message) {
        this.messageInfo(message, message.getCorbaRequestId());
        this.connectionInfo(this.connection);
        if (message.moreFragmentsToFollow()) {
            Queue<MessageMediator> queue;
            this.generalMessage("getting next fragment");
            MessageMediator messageMediator = null;
            RequestId requestId = message.getCorbaRequestId();
            Queue<MessageMediator> queue2 = queue = this.connection.getFragmentList(requestId);
            synchronized (queue2) {
                while (messageMediator == null) {
                    if (queue.size() > 0) {
                        messageMediator = queue.poll();
                        continue;
                    }
                    try {
                        queue.wait();
                    }
                    catch (InterruptedException ex) {
                        wrapper.resumeOptimizedReadThreadInterrupted(ex);
                    }
                }
            }
            this.addMessageMediatorToWorkQueue(messageMediator);
        } else if (message.getType() == 7 || message.getType() == 2) {
            RequestId requestId = message.getCorbaRequestId();
            this.generalMessage("done processing fragments (removing fragment list)");
            this.connection.removeFragmentList(requestId);
        }
    }

    @InfoMethod
    private void poolToUseInfo(int id) {
    }

    @Transport
    private void addMessageMediatorToWorkQueue(MessageMediator messageMediator) {
        Throwable throwable = null;
        int poolToUse = -1;
        try {
            poolToUse = messageMediator.getThreadPoolToUse();
            this.poolToUseInfo(poolToUse);
            this.orb.getThreadPoolManager().getThreadPool(poolToUse).getWorkQueue(0).addWork((Work)((MessageMediatorImpl)messageMediator));
        }
        catch (NoSuchThreadPoolException e) {
            throwable = e;
        }
        catch (NoSuchWorkQueueException e) {
            throwable = e;
        }
        if (throwable != null) {
            this.reportException("exception from thread pool", throwable);
            throw wrapper.noSuchThreadpoolOrQueue(throwable, poolToUse);
        }
    }

    @Transport
    private void setWorkThenPoolOrResumeOptimizedRead(Message header) {
        if (this.getConnection().getEventHandler().shouldUseSelectThreadToWait()) {
            this.resumeOptimizedReadProcessing(header);
        } else {
            this.isThreadDone = true;
            this.orb.getTransportManager().getSelector(0).unregisterForEvent(this.getConnection().getEventHandler());
            this.orb.getTransportManager().getSelector(0).registerForEvent(this.getConnection().getEventHandler());
        }
    }

    @Transport
    private void setWorkThenReadOrResumeOptimizedRead(Message header) {
        if (this.getConnection().getEventHandler().shouldUseSelectThreadToWait()) {
            this.resumeOptimizedReadProcessing(header);
        } else {
            this.isThreadDone = false;
        }
    }

    private void setInputObject() {
        this.inputObject = new CDRInputObject(this.orb, this.getConnection(), this.dispatchByteBuffer, this.dispatchHeader);
        this.inputObject.setMessageMediator(this);
    }

    private void signalResponseReceived() {
        this.connection.getResponseWaitingRoom().responseReceived(this.inputObject);
    }

    @Override
    @Transport
    public void handleInput(Message header) throws IOException {
        this.messageHeader = header;
        this.setWorkThenReadOrResumeOptimizedRead(header);
        switch (header.getType()) {
            case 5: {
                this.generalMessage("close connection");
                this.connection.purgeCalls((SystemException)wrapper.connectionRebind(), true, false);
                break;
            }
            case 6: {
                this.generalMessage("message error");
                this.connection.purgeCalls((SystemException)wrapper.recvMsgError(), true, false);
                break;
            }
            default: {
                this.generalMessage("default");
                throw wrapper.badGiopRequestType();
            }
        }
        this.releaseByteBufferToPool();
    }

    @Override
    @Transport
    public void handleInput(RequestMessage_1_0 header) throws IOException {
        this.generalMessage("GIOP Request 1.0");
        try {
            try {
                this.requestHeader = header;
                this.messageHeader = this.requestHeader;
                this.setInputObject();
            }
            finally {
                this.setWorkThenPoolOrResumeOptimizedRead(header);
            }
            this.getProtocolHandler().handleRequest(header, (MessageMediator)this);
        }
        catch (Throwable t) {
            this.reportException("", t);
        }
    }

    @Override
    @Transport
    public void handleInput(RequestMessage_1_1 header) throws IOException {
        this.generalMessage("GIOP Request 1.1");
        try {
            try {
                this.requestHeader = header;
                this.messageHeader = this.requestHeader;
                this.setInputObject();
                this.connection.serverRequest_1_1_Put(this);
            }
            finally {
                this.setWorkThenPoolOrResumeOptimizedRead(header);
            }
            this.getProtocolHandler().handleRequest(header, (MessageMediator)this);
        }
        catch (Throwable t) {
            this.reportException("", t);
        }
    }

    @InfoMethod
    private void requestIdInfo(int id) {
    }

    @Override
    @Transport
    public void handleInput(RequestMessage_1_2 header) throws IOException {
        this.generalMessage("GIOP Request 1.2");
        try {
            try {
                this.requestHeader = header;
                this.messageHeader = this.requestHeader;
                this.unmarshalRequestID(header);
                this.requestIdInfo(header.getRequestId());
                this.setInputObject();
                this.connection.serverRequestMapPut(header.getRequestId(), this);
            }
            finally {
                this.setWorkThenPoolOrResumeOptimizedRead(header);
            }
            this.getProtocolHandler().handleRequest(header, (MessageMediator)this);
        }
        catch (Throwable t) {
            this.reportException("", t);
        }
        finally {
            this.connection.serverRequestMapRemove(header.getRequestId());
        }
    }

    private void unmarshalRequestID(Message_1_2 message) {
        message.unmarshalRequestID(this.dispatchByteBuffer);
    }

    @Override
    @Transport
    public void handleInput(ReplyMessage_1_0 header) throws IOException {
        this.generalMessage("GIOP ReplyMessage 1.0");
        try {
            try {
                this.replyHeader = header;
                this.messageHeader = this.replyHeader;
                this.setInputObject();
                this.inputObject.unmarshalHeader();
                this.signalResponseReceived();
            }
            finally {
                this.setWorkThenReadOrResumeOptimizedRead(header);
            }
        }
        catch (Throwable t) {
            this.reportException("", t);
        }
    }

    @Override
    @Transport
    public void handleInput(ReplyMessage_1_1 header) throws IOException {
        this.generalMessage("GIOP ReplyMessage 1.1");
        try {
            this.replyHeader = header;
            this.messageHeader = this.replyHeader;
            this.setInputObject();
            if (header.moreFragmentsToFollow()) {
                this.connection.clientReply_1_1_Put(this);
                this.setWorkThenPoolOrResumeOptimizedRead(header);
                this.inputObject.unmarshalHeader();
                this.signalResponseReceived();
            } else {
                this.inputObject.unmarshalHeader();
                this.signalResponseReceived();
                this.setWorkThenReadOrResumeOptimizedRead(header);
            }
        }
        catch (Throwable t) {
            this.reportException("", t);
        }
    }

    @InfoMethod
    private void moreFragmentsInfo(boolean moreFragments) {
    }

    @Override
    @Transport
    public void handleInput(ReplyMessage_1_2 header) throws IOException {
        this.generalMessage("GIOP ReplyMessage 1.2");
        try {
            try {
                this.replyHeader = header;
                this.messageHeader = this.replyHeader;
                this.unmarshalRequestID(header);
                this.requestIdInfo(header.getRequestId());
                this.moreFragmentsInfo(header.moreFragmentsToFollow());
                this.setInputObject();
                this.signalResponseReceived();
            }
            finally {
                this.setWorkThenReadOrResumeOptimizedRead(header);
            }
        }
        catch (Throwable t) {
            this.reportException("", t);
        }
    }

    @Override
    @Transport
    public void handleInput(LocateRequestMessage_1_0 header) throws IOException {
        this.generalMessage("GIOP LocateRequestMessage 1.0");
        try {
            try {
                this.messageHeader = header;
                this.setInputObject();
            }
            finally {
                this.setWorkThenPoolOrResumeOptimizedRead(header);
            }
            this.getProtocolHandler().handleRequest(header, (MessageMediator)this);
        }
        catch (Throwable t) {
            this.reportException("", t);
        }
    }

    @Override
    @Transport
    public void handleInput(LocateRequestMessage_1_1 header) throws IOException {
        this.generalMessage("GIOP LocateRequestMessage 1.1");
        try {
            try {
                this.messageHeader = header;
                this.setInputObject();
            }
            finally {
                this.setWorkThenPoolOrResumeOptimizedRead(header);
            }
            this.getProtocolHandler().handleRequest(header, (MessageMediator)this);
        }
        catch (Throwable t) {
            this.reportException("", t);
        }
    }

    @Override
    @Transport
    public void handleInput(LocateRequestMessage_1_2 header) throws IOException {
        this.generalMessage("GIOP LocateRequestMessage 1.2");
        try {
            try {
                this.messageHeader = header;
                this.unmarshalRequestID(header);
                this.setInputObject();
                this.requestIdInfo(header.getRequestId());
                this.moreFragmentsInfo(header.moreFragmentsToFollow());
                if (header.moreFragmentsToFollow()) {
                    this.connection.serverRequestMapPut(header.getRequestId(), this);
                }
            }
            finally {
                this.setWorkThenPoolOrResumeOptimizedRead(header);
            }
            this.getProtocolHandler().handleRequest(header, (MessageMediator)this);
        }
        catch (Throwable t) {
            this.reportException("", t);
        }
    }

    @Override
    @Transport
    public void handleInput(LocateReplyMessage_1_0 header) throws IOException {
        this.generalMessage("GIOP LocateReplyMessage 1.0");
        try {
            try {
                this.messageHeader = header;
                this.setInputObject();
                this.inputObject.unmarshalHeader();
                this.signalResponseReceived();
            }
            finally {
                this.setWorkThenReadOrResumeOptimizedRead(header);
            }
        }
        catch (Throwable t) {
            this.reportException("", t);
        }
    }

    @Override
    @Transport
    public void handleInput(LocateReplyMessage_1_1 header) throws IOException {
        this.generalMessage("GIOP LocateReplyMessage 1.1");
        try {
            try {
                this.messageHeader = header;
                this.setInputObject();
                this.inputObject.unmarshalHeader();
                this.signalResponseReceived();
            }
            finally {
                this.setWorkThenReadOrResumeOptimizedRead(header);
            }
        }
        catch (Throwable t) {
            this.reportException("", t);
        }
    }

    @Override
    @Transport
    public void handleInput(LocateReplyMessage_1_2 header) throws IOException {
        this.generalMessage("GIOP LocateReplyMessage 1.2");
        try {
            try {
                this.messageHeader = header;
                this.unmarshalRequestID(header);
                this.setInputObject();
                this.requestIdInfo(header.getRequestId());
                this.signalResponseReceived();
            }
            finally {
                this.setWorkThenPoolOrResumeOptimizedRead(header);
            }
        }
        catch (Throwable t) {
            this.reportException("", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public void handleInput(FragmentMessage_1_1 header) throws IOException {
        this.generalMessage("GIOP FragmentMessage 1.1");
        try {
            this.moreFragmentsInfo(header.moreFragmentsToFollow());
            try {
                this.messageHeader = header;
                MessageMediator mediator = null;
                CDRInputObject inObj = null;
                mediator = this.connection.isServer() ? this.connection.serverRequest_1_1_Get() : this.connection.clientReply_1_1_Get();
                if (mediator != null) {
                    inObj = mediator.getInputObject();
                }
                if (inObj == null) {
                    this.generalMessage("No input stream: discarding fragment");
                    this.releaseByteBufferToPool();
                    return;
                }
                inObj.addFragment(header, this.dispatchByteBuffer);
                if (!header.moreFragmentsToFollow()) {
                    if (this.connection.isServer()) {
                        this.connection.serverRequest_1_1_Remove();
                    } else {
                        this.connection.clientReply_1_1_Remove();
                    }
                }
            }
            finally {
                this.setWorkThenReadOrResumeOptimizedRead(header);
            }
        }
        catch (Throwable t) {
            this.reportException("", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public void handleInput(FragmentMessage_1_2 header) throws IOException {
        this.generalMessage("GIOP FragmentMessage 1.1");
        try {
            try {
                this.messageHeader = header;
                this.unmarshalRequestID(header);
                this.requestIdInfo(header.getRequestId());
                this.moreFragmentsInfo(header.moreFragmentsToFollow());
                MessageMediator mediator = null;
                CDRInputObject inObj = null;
                mediator = this.connection.isServer() ? this.connection.serverRequestMapGet(header.getRequestId()) : this.connection.clientRequestMapGet(header.getRequestId());
                if (mediator != null) {
                    inObj = mediator.getInputObject();
                }
                if (inObj == null) {
                    this.generalMessage("No input stream: discarding fragment");
                    this.releaseByteBufferToPool();
                    return;
                }
                inObj.addFragment(header, this.dispatchByteBuffer);
                if (!this.connection.isServer()) {
                    // empty if block
                }
            }
            finally {
                this.setWorkThenReadOrResumeOptimizedRead(header);
            }
        }
        catch (Throwable t) {
            this.reportException("", t);
        }
    }

    @InfoMethod
    private void reportGIOPVersion(GIOPVersion vers) {
    }

    @Override
    @Transport
    public void handleInput(CancelRequestMessage header) throws IOException {
        this.generalMessage("GIOP CancelRequestMessage");
        try {
            try {
                this.messageHeader = header;
                this.setInputObject();
                this.inputObject.unmarshalHeader();
                this.requestIdInfo(header.getRequestId());
                this.reportGIOPVersion(header.getGIOPVersion());
                this.processCancelRequest(header.getRequestId());
                this.releaseByteBufferToPool();
            }
            finally {
                this.setWorkThenReadOrResumeOptimizedRead(header);
            }
        }
        catch (Throwable t) {
            this.reportException("", t);
        }
    }

    private void throwNotImplemented(String msg) {
        throw new RuntimeException("CorbaMessageMediatorImpl: not implemented " + msg);
    }

    @Transport
    private void processCancelRequest(int cancelReqId) {
        RequestMessage msg;
        if (!this.connection.isServer()) {
            return;
        }
        MessageMediator mediator = this.connection.serverRequestMapGet(cancelReqId);
        if (mediator == null) {
            mediator = this.connection.serverRequest_1_1_Get();
            if (mediator == null) {
                wrapper.badCancelRequest();
                return;
            }
            int requestId = mediator.getRequestId();
            if (requestId != cancelReqId) {
                wrapper.bad1_1CancelRequestReceived();
                return;
            }
            if (requestId == 0) {
                wrapper.cancelRequestWithId0();
                return;
            }
        } else {
            int requestId = mediator.getRequestId();
        }
        if ((msg = mediator.getRequestHeader()).getType() != 0) {
            wrapper.badMessageTypeForCancel();
        }
        mediator.getInputObject().cancelProcessing(cancelReqId);
    }

    /*
     * Exception decompiling
     */
    @Override
    @Transport
    public void handleRequest(RequestMessage msg, MessageMediator messageMediator) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public void handleRequest(LocateRequestMessage msg, MessageMediator messageMediator) {
        try {
            this.beginRequest(messageMediator);
            try {
                this.handleLocateRequest(messageMediator);
            }
            catch (Throwable t) {
                this.handleThrowableDuringServerDispatch(messageMediator, t, CompletionStatus.COMPLETED_MAYBE);
            }
            this.sendResponse(messageMediator);
        }
        catch (Throwable t) {
            wrapper.exceptionInHandleRequestForLocateRequest(t);
            this.dispatchError(messageMediator, "LocateRequestMessage", t);
        }
        finally {
            this.endRequest(messageMediator);
        }
    }

    @Subcontract
    private void beginRequest(MessageMediator messageMediator) {
        ORB myOrb = messageMediator.getBroker();
        this.connection.serverRequestProcessingBegins();
    }

    @Subcontract
    private void dispatchError(MessageMediator messageMediator, String msg, Throwable t) {
    }

    @Subcontract
    private void sendResponse(MessageMediator messageMediator) {
        if (this.orb.orbIsShutdown()) {
            return;
        }
        CDROutputObject outObj = messageMediator.getOutputObject();
        if (outObj != null) {
            outObj.finishSendingMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subcontract
    private void endRequest(MessageMediator messageMediator) {
        ORB myOrb = messageMediator.getBroker();
        if (myOrb.orbIsShutdown()) {
            return;
        }
        try {
            CDRInputObject inputObj;
            CDROutputObject outputObj = messageMediator.getOutputObject();
            if (outputObj != null) {
                outputObj.close();
            }
            if ((inputObj = messageMediator.getInputObject()) != null) {
                inputObj.close();
            }
        }
        catch (IOException ex) {
            this.reportException("", ex);
        }
        finally {
            messageMediator.getConnection().serverRequestProcessingEnds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subcontract
    protected void handleRequestRequest(MessageMediator messageMediator) {
        messageMediator.getInputObject().unmarshalHeader();
        ORB myOrb = messageMediator.getBroker();
        if (myOrb.orbIsShutdown()) {
            return;
        }
        ObjectKey okey = messageMediator.getObjectKeyCacheEntry().getObjectKey();
        ServerRequestDispatcher sc = okey.getServerRequestDispatcher();
        if (sc == null) {
            throw wrapper.noServerScInDispatch();
        }
        try {
            myOrb.startingDispatch();
            sc.dispatch(messageMediator);
        }
        finally {
            myOrb.finishedDispatch();
        }
    }

    @Subcontract
    protected void handleLocateRequest(MessageMediator messageMediator) {
        ORB myOrb = messageMediator.getBroker();
        LocateRequestMessage msg = (LocateRequestMessage)messageMediator.getDispatchHeader();
        IOR ior = null;
        LocateReplyMessage reply = null;
        short addrDisp = -1;
        try {
            messageMediator.getInputObject().unmarshalHeader();
            ObjectKey okey = msg.getObjectKeyCacheEntry().getObjectKey();
            ServerRequestDispatcher sc = okey.getServerRequestDispatcher();
            if (sc == null) {
                return;
            }
            ior = sc.locate(okey);
            reply = ior == null ? MessageBase.createLocateReply(myOrb, msg.getGIOPVersion(), msg.getEncodingVersion(), msg.getRequestId(), 1, null) : MessageBase.createLocateReply(myOrb, msg.getGIOPVersion(), msg.getEncodingVersion(), msg.getRequestId(), 2, ior);
        }
        catch (AddressingDispositionException ex) {
            reply = MessageBase.createLocateReply(myOrb, msg.getGIOPVersion(), msg.getEncodingVersion(), msg.getRequestId(), 5, null);
            addrDisp = ex.expectedAddrDisp();
        }
        catch (RequestCanceledException ex) {
            return;
        }
        catch (Exception ex) {
            reply = MessageBase.createLocateReply(myOrb, msg.getGIOPVersion(), msg.getEncodingVersion(), msg.getRequestId(), 0, null);
        }
        CDROutputObject outObj = this.createAppropriateOutputObject(messageMediator, msg, reply);
        messageMediator.setOutputObject(outObj);
        outObj.setMessageMediator(messageMediator);
        reply.write((OutputStream)outObj);
        if (ior != null) {
            ior.write(outObj);
        }
        if (addrDisp != -1) {
            AddressingDispositionHelper.write((OutputStream)outObj, addrDisp);
        }
    }

    @Subcontract
    private CDROutputObject createAppropriateOutputObject(MessageMediator messageMediator, Message msg, LocateReplyMessage reply) {
        CDROutputObject outObj = msg.getGIOPVersion().lessThan(GIOPVersion.V1_2) ? OutputStreamFactory.newCDROutputObject(messageMediator.getBroker(), this, GIOPVersion.V1_0, messageMediator.getConnection(), reply, (byte)1) : OutputStreamFactory.newCDROutputObject(messageMediator.getBroker(), messageMediator, reply, (byte)1);
        return outObj;
    }

    @Override
    @Subcontract
    public void handleThrowableDuringServerDispatch(MessageMediator messageMediator, Throwable throwable, CompletionStatus completionStatus) {
        this.handleThrowableDuringServerDispatch(messageMediator, throwable, completionStatus, 1);
    }

    @Subcontract
    protected void handleThrowableDuringServerDispatch(MessageMediator messageMediator, Throwable throwable, CompletionStatus completionStatus, int iteration) {
        if (iteration > 10) {
            throw new RuntimeException("handleThrowableDuringServerDispatch: cannot create response.", throwable);
        }
        try {
            if (throwable instanceof ForwardException) {
                ForwardException fex = (ForwardException)throwable;
                this.createLocationForward(messageMediator, fex.getIOR(), null);
                return;
            }
            if (throwable instanceof AddressingDispositionException) {
                this.handleAddressingDisposition(messageMediator, (AddressingDispositionException)throwable);
                return;
            }
            SystemException sex = this.convertThrowableToSystemException(throwable, completionStatus);
            this.createSystemExceptionResponse(messageMediator, sex, null);
            return;
        }
        catch (Throwable throwable2) {
            this.handleThrowableDuringServerDispatch(messageMediator, throwable2, completionStatus, iteration + 1);
            return;
        }
    }

    @Subcontract
    protected SystemException convertThrowableToSystemException(Throwable throwable, CompletionStatus completionStatus) {
        if (throwable instanceof SystemException) {
            return (SystemException)throwable;
        }
        if (throwable instanceof RequestCanceledException) {
            return wrapper.requestCanceled(throwable);
        }
        return wrapper.runtimeexception(throwable, throwable.getClass().getName(), throwable.getMessage());
    }

    @Subcontract
    protected void handleAddressingDisposition(MessageMediator messageMediator, AddressingDispositionException ex) {
        short addrDisp = -1;
        switch (messageMediator.getRequestHeader().getType()) {
            case 0: {
                ORB myOrb = messageMediator.getBroker();
                ReplyMessage repHdr = MessageBase.createReply(myOrb, messageMediator.getGIOPVersion(), messageMediator.getEncodingVersion(), messageMediator.getRequestId(), 5, ServiceContextDefaults.makeServiceContexts(myOrb), null);
                CDROutputObject outObj = OutputStreamFactory.newCDROutputObject(messageMediator.getBroker(), this, messageMediator.getGIOPVersion(), messageMediator.getConnection(), repHdr, (byte)1);
                messageMediator.setOutputObject(outObj);
                outObj.setMessageMediator(messageMediator);
                repHdr.write((OutputStream)outObj);
                AddressingDispositionHelper.write((OutputStream)outObj, ex.expectedAddrDisp());
                return;
            }
            case 3: {
                LocateReplyMessage locateReplyHeader = MessageBase.createLocateReply(messageMediator.getBroker(), messageMediator.getGIOPVersion(), messageMediator.getEncodingVersion(), messageMediator.getRequestId(), 5, null);
                addrDisp = ex.expectedAddrDisp();
                CDROutputObject outObj = this.createAppropriateOutputObject(messageMediator, messageMediator.getRequestHeader(), locateReplyHeader);
                messageMediator.setOutputObject(outObj);
                outObj.setMessageMediator(messageMediator);
                locateReplyHeader.write((OutputStream)outObj);
                Writeable ior = null;
                if (ior != null) {
                    ior.write(outObj);
                }
                if (addrDisp != -1) {
                    AddressingDispositionHelper.write((OutputStream)outObj, addrDisp);
                }
                return;
            }
        }
    }

    @Override
    @Subcontract
    public MessageMediator createResponse(MessageMediator messageMediator, ServiceContexts svc) {
        return this.createResponseHelper(messageMediator, this.getServiceContextsForReply(messageMediator, null));
    }

    @Override
    @Subcontract
    public MessageMediator createUserExceptionResponse(MessageMediator messageMediator, ServiceContexts svc) {
        return this.createResponseHelper(messageMediator, this.getServiceContextsForReply(messageMediator, null), true);
    }

    @Override
    @Subcontract
    public MessageMediator createUnknownExceptionResponse(MessageMediator messageMediator, UnknownException ex) {
        ServiceContexts contexts = null;
        UNKNOWN sys = new UNKNOWN(0, CompletionStatus.COMPLETED_MAYBE);
        contexts = ServiceContextDefaults.makeServiceContexts(messageMediator.getBroker());
        UEInfoServiceContext uei = ServiceContextDefaults.makeUEInfoServiceContext(sys);
        contexts.put(uei);
        return this.createSystemExceptionResponse(messageMediator, (SystemException)((Object)sys), contexts);
    }

    @Override
    @Subcontract
    public MessageMediator createSystemExceptionResponse(MessageMediator messageMediator, SystemException ex, ServiceContexts svc) {
        if (messageMediator.getConnection() != null) {
            MessageMediatorImpl mediator = (MessageMediatorImpl)messageMediator.getConnection().serverRequestMapGet(messageMediator.getRequestId());
            CDROutputObject existingOutputObject = null;
            if (mediator != null) {
                existingOutputObject = mediator.getOutputObject();
            }
            if (existingOutputObject != null && mediator.sentFragment() && !mediator.sentFullMessage()) {
                return mediator;
            }
        }
        if (messageMediator.executePIInResponseConstructor()) {
            messageMediator.getBroker().getPIHandler().setServerPIInfo((Exception)((Object)ex));
        }
        if (ex != null) {
            this.reportException("Creating system exception response for", ex);
        }
        ServiceContexts serviceContexts = this.getServiceContextsForReply(messageMediator, svc);
        this.addExceptionDetailMessage(messageMediator, ex, serviceContexts);
        MessageMediator response = this.createResponseHelper(messageMediator, serviceContexts, false);
        ORBUtility.writeSystemException(ex, (OutputStream)response.getOutputObject());
        return response;
    }

    @Subcontract
    private void addExceptionDetailMessage(MessageMediator mediator, SystemException ex, ServiceContexts serviceContexts) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        ex.printStackTrace(pw);
        pw.flush();
        EncapsOutputStream encapsOutputStream = OutputStreamFactory.newEncapsOutputStream(mediator.getBroker());
        encapsOutputStream.putEndian();
        encapsOutputStream.write_wstring(baos.toString());
        UnknownServiceContext serviceContext = ServiceContextDefaults.makeUnknownServiceContext(14, encapsOutputStream.toByteArray());
        serviceContexts.put(serviceContext);
    }

    @Override
    @Subcontract
    public MessageMediator createLocationForward(MessageMediator messageMediator, IOR ior, ServiceContexts svc) {
        ReplyMessage reply = MessageBase.createReply(messageMediator.getBroker(), messageMediator.getGIOPVersion(), messageMediator.getEncodingVersion(), messageMediator.getRequestId(), 3, this.getServiceContextsForReply(messageMediator, svc), ior);
        return this.createResponseHelper(messageMediator, reply, ior);
    }

    @Subcontract
    protected MessageMediator createResponseHelper(MessageMediator messageMediator, ServiceContexts svc) {
        ReplyMessage message = MessageBase.createReply(messageMediator.getBroker(), messageMediator.getGIOPVersion(), messageMediator.getEncodingVersion(), messageMediator.getRequestId(), 0, svc, null);
        return this.createResponseHelper(messageMediator, message, null);
    }

    @Subcontract
    protected MessageMediator createResponseHelper(MessageMediator messageMediator, ServiceContexts svc, boolean user) {
        ReplyMessage message = MessageBase.createReply(messageMediator.getBroker(), messageMediator.getGIOPVersion(), messageMediator.getEncodingVersion(), messageMediator.getRequestId(), user ? 1 : 2, svc, null);
        return this.createResponseHelper(messageMediator, message, null);
    }

    @InfoMethod
    private void createResponseHelperInfo(ReplyMessage reply) {
    }

    @Subcontract
    protected MessageMediator createResponseHelper(MessageMediator messageMediator, ReplyMessage reply, IOR ior) {
        this.runServantPostInvoke(messageMediator);
        this.runInterceptors(messageMediator, reply);
        this.runRemoveThreadInfo(messageMediator);
        this.createResponseHelperInfo(reply);
        messageMediator.setReplyHeader(reply);
        CDROutputObject replyOutputObject = messageMediator.getConnection() == null ? OutputStreamFactory.newCDROutputObject(this.orb, messageMediator, messageMediator.getReplyHeader(), messageMediator.getStreamFormatVersion(), 0) : messageMediator.getConnection().getAcceptor().createOutputObject(messageMediator.getBroker(), messageMediator);
        messageMediator.setOutputObject(replyOutputObject);
        messageMediator.getOutputObject().setMessageMediator(messageMediator);
        reply.write((OutputStream)messageMediator.getOutputObject());
        if (reply.getIOR() != null) {
            reply.getIOR().write(messageMediator.getOutputObject());
        }
        return messageMediator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subcontract
    protected void runServantPostInvoke(MessageMediator messageMediator) {
        ORB myOrb = null;
        if (messageMediator.executeReturnServantInResponseConstructor()) {
            messageMediator.setExecuteReturnServantInResponseConstructor(false);
            messageMediator.setExecuteRemoveThreadInfoInResponseConstructor(true);
            try {
                myOrb = messageMediator.getBroker();
                OAInvocationInfo info = myOrb.peekInvocationInfo();
                ObjectAdapter oa = info.oa();
                try {
                    oa.returnServant();
                }
                catch (Throwable thr) {
                    wrapper.unexpectedException(thr);
                    if (thr instanceof Error) {
                        throw (Error)thr;
                    }
                    if (thr instanceof RuntimeException) {
                        throw (RuntimeException)thr;
                    }
                }
                finally {
                    oa.exit();
                }
            }
            catch (EmptyStackException ese) {
                throw wrapper.emptyStackRunServantPostInvoke(ese);
            }
        }
    }

    @Subcontract
    protected void runInterceptors(MessageMediator messageMediator, ReplyMessage reply) {
        if (messageMediator.executePIInResponseConstructor()) {
            messageMediator.getBroker().getPIHandler().invokeServerPIEndingPoint(reply);
            messageMediator.getBroker().getPIHandler().cleanupServerPIRequest();
            messageMediator.setExecutePIInResponseConstructor(false);
        }
    }

    @Subcontract
    protected void runRemoveThreadInfo(MessageMediator messageMediator) {
        if (messageMediator.executeRemoveThreadInfoInResponseConstructor()) {
            messageMediator.setExecuteRemoveThreadInfoInResponseConstructor(false);
            messageMediator.getBroker().popInvocationInfo();
        }
    }

    @InfoMethod
    private void generalMessage(String msg) {
    }

    @Subcontract
    protected ServiceContexts getServiceContextsForReply(MessageMediator messageMediator, ServiceContexts contexts) {
        ORBVersionServiceContext ovsc;
        Connection c = messageMediator.getConnection();
        if (contexts == null) {
            if (this.getGIOPVersion().equals(GIOPVersion.V1_2) && c != null && c.getBroker().getORBData().alwaysSendCodeSetServiceContext() && this.getEncodingVersion() == 0) {
                if (!c.isPostInitialContexts()) {
                    c.setPostInitialContexts();
                    contexts = messageMediator.getBroker().getServiceContextsCache().get(ServiceContextsCache.CASE.SERVER_INITIAL);
                } else {
                    contexts = messageMediator.getBroker().getServiceContextsCache().get(ServiceContextsCache.CASE.SERVER_SUBSEQUENT);
                }
                return contexts;
            }
            contexts = ServiceContextDefaults.makeServiceContexts(messageMediator.getBroker());
        }
        if (c != null && !c.isPostInitialContexts() && this.getEncodingVersion() == 0) {
            c.setPostInitialContexts();
            SendingContextServiceContext scsc = ServiceContextDefaults.makeSendingContextServiceContext(messageMediator.getBroker().getFVDCodeBaseIOR());
            if (contexts.get(scsc.getId()) != null) {
                throw wrapper.duplicateSendingContextServiceContext();
            }
            contexts.put(scsc);
            this.generalMessage("Added SendingContextServiceContext");
        }
        if (contexts.get((ovsc = ServiceContextDefaults.makeORBVersionServiceContext()).getId()) != null) {
            throw wrapper.duplicateOrbVersionServiceContext();
        }
        contexts.put(ovsc);
        this.generalMessage("Added ORB version service context");
        return contexts;
    }

    @Transport
    private void releaseByteBufferToPool() {
        if (this.dispatchByteBuffer != null) {
            this.orb.getByteBufferPool().releaseByteBuffer(this.dispatchByteBuffer);
        }
    }

    @Override
    @Subcontract
    public void cancelRequest() {
        CDRInputObject inObj = this.getInputObject();
        if (inObj != null) {
            inObj.cancelProcessing(this.getRequestId());
        }
    }

    @InfoMethod
    private void ignoringThrowable(Throwable thr) {
    }

    @Subcontract
    public void doWork() {
        try {
            this.dispatch();
        }
        catch (Throwable t) {
            this.ignoringThrowable(t);
        }
    }

    public void setEnqueueTime(long timeInMillis) {
        this.enqueueTime = timeInMillis;
    }

    public long getEnqueueTime() {
        return this.enqueueTime;
    }

    public String getName() {
        return this.toString();
    }
}

