/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaVersion {
    private long major;
    private long minor;
    private long micro;
    private long update;
    private long build;

    public static JavaVersion getVersion(String string) {
        Matcher matcher;
        if (string.matches("[0-9]+\\.[0-9]+\\.[0-9]+-b[0-9]+")) {
            string = string.replace("-b", ".0.");
        }
        if (string.matches("[0-9]+\\.[0-9]+\\.[0-9]+_[0-9]+-b[0-9]+")) {
            string = string.replace("-b", ".");
        }
        if (string.matches("[0-9]+\\.[0-9]+\\.[0-9]+_[0-9]+-ea")) {
            string = string.replace("-ea", ".");
        }
        if ((matcher = Pattern.compile("[0-9]+\\.[0-9]+[0-9_\\.\\-]+").matcher(string)).find()) {
            return new JavaVersion(matcher.group());
        }
        return null;
    }

    public JavaVersion(String string) {
        String[] split = string.split("[\\._\\-]+");
        if (split.length > 0) {
            this.major = Long.parseLong(split[0]);
        }
        if (split.length > 1) {
            this.minor = Long.parseLong(split[1]);
        }
        if (split.length > 2) {
            this.micro = Long.parseLong(split[2]);
        }
        if (split.length > 3) {
            this.update = Long.parseLong(split[3]);
        }
        if (split.length > 4) {
            this.build = Long.parseLong(split[4]);
        }
    }

    public boolean newerThan(JavaVersion version) {
        if (this.getMajor() > version.getMajor()) {
            return true;
        }
        if (this.getMajor() < version.getMajor()) {
            return false;
        }
        if (this.getMinor() > version.getMinor()) {
            return true;
        }
        if (this.getMinor() < version.getMinor()) {
            return false;
        }
        if (this.getMicro() > version.getMicro()) {
            return true;
        }
        if (this.getMicro() < version.getMicro()) {
            return false;
        }
        if (this.getUpdate() > version.getUpdate()) {
            return true;
        }
        if (this.getUpdate() < version.getUpdate()) {
            return false;
        }
        if (this.getBuild() > version.getBuild()) {
            return true;
        }
        return this.getBuild() < version.getBuild();
    }

    public boolean newerOrEquals(JavaVersion version) {
        return this.newerThan(version) || this.equals(version);
    }

    public boolean olderThan(JavaVersion version) {
        return !this.newerOrEquals(version);
    }

    public boolean olderOrEquals(JavaVersion version) {
        return !this.newerThan(version);
    }

    public long getMajor() {
        return this.major;
    }

    public long getMinor() {
        return this.minor;
    }

    public long getMicro() {
        return this.micro;
    }

    public long getUpdate() {
        return this.update;
    }

    public long getBuild() {
        return this.build;
    }

    public String toMinor() {
        return "" + this.major + "." + this.minor;
    }

    public String toJdkStyle() {
        return "" + this.major + "." + this.minor + "." + this.micro + (this.update != 0L ? "_" + (this.update < 10L ? "0" + this.update : Long.valueOf(this.update)) : "");
    }
}

