/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.wsdl.document;

import com.sun.xml.rpc.wsdl.document.Documentation;
import com.sun.xml.rpc.wsdl.document.Kinds;
import com.sun.xml.rpc.wsdl.document.Operation;
import com.sun.xml.rpc.wsdl.document.WSDLConstants;
import com.sun.xml.rpc.wsdl.document.WSDLDocumentVisitor;
import com.sun.xml.rpc.wsdl.framework.Defining;
import com.sun.xml.rpc.wsdl.framework.Entity;
import com.sun.xml.rpc.wsdl.framework.EntityAction;
import com.sun.xml.rpc.wsdl.framework.GlobalEntity;
import com.sun.xml.rpc.wsdl.framework.Kind;
import com.sun.xml.rpc.wsdl.framework.ValidationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;

public class PortType
extends GlobalEntity {
    private Documentation _documentation;
    private List _operations = new ArrayList();
    private Set _operationKeys = new HashSet();

    public PortType(Defining defining) {
        super(defining);
    }

    public void add(Operation operation) {
        String key = operation.getUniqueKey();
        if (this._operationKeys.contains(key)) {
            throw new ValidationException("validation.ambiguousName", operation.getName());
        }
        this._operationKeys.add(key);
        this._operations.add(operation);
    }

    public Iterator operations() {
        return this._operations.iterator();
    }

    public Set getOperationsNamed(String s) {
        HashSet<Operation> result = new HashSet<Operation>();
        for (Operation operation : this._operations) {
            if (!operation.getName().equals(s)) continue;
            result.add(operation);
        }
        return result;
    }

    @Override
    public Kind getKind() {
        return Kinds.PORT_TYPE;
    }

    @Override
    public QName getElementName() {
        return WSDLConstants.QNAME_PORT_TYPE;
    }

    public Documentation getDocumentation() {
        return this._documentation;
    }

    public void setDocumentation(Documentation d) {
        this._documentation = d;
    }

    @Override
    public void withAllSubEntitiesDo(EntityAction action) {
        super.withAllSubEntitiesDo(action);
        Iterator iter = this._operations.iterator();
        while (iter.hasNext()) {
            action.perform((Entity)iter.next());
        }
    }

    public void accept(WSDLDocumentVisitor visitor) throws Exception {
        visitor.preVisit(this);
        Iterator iter = this._operations.iterator();
        while (iter.hasNext()) {
            ((Operation)iter.next()).accept(visitor);
        }
        visitor.postVisit(this);
    }

    @Override
    public void validateThis() {
        if (this.getName() == null) {
            this.failValidation("validation.missingRequiredAttribute", "name");
        }
    }
}

