/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.simpletype;

import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDDateTimeDateEncoder;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.util.VersionUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class XSDDateTimeCalendarEncoder
extends XSDDateTimeDateEncoder {
    private static final SimpleTypeEncoder encoder = new XSDDateTimeCalendarEncoder();
    private static final ThreadLocal zoneFormatter = new ThreadLocal();
    private static final ThreadLocal calendarFormatter = new ThreadLocal();

    private XSDDateTimeCalendarEncoder() {
    }

    public static SimpleTypeEncoder getInstance() {
        return encoder;
    }

    @Override
    public String objectToString(Object obj, XMLWriter writer) throws Exception {
        if (obj == null) {
            return null;
        }
        Calendar c = (Calendar)obj;
        StringBuffer resultBuf = new StringBuffer();
        if (c.get(0) == 0) {
            resultBuf.append('-');
        }
        SimpleDateFormat calendarFormat = this.getCalendarFormat();
        SimpleDateFormat zoneFormat = this.getZoneFormat();
        zoneFormat.setTimeZone(c.getTimeZone());
        String zone = zoneFormat.format(c.getTime());
        calendarFormat.setTimeZone(c.getTimeZone());
        resultBuf.append(calendarFormat.format(c.getTime()));
        String offsetStr = zone.substring(0, 3) + ":" + zone.substring(3, 5);
        resultBuf.append(offsetStr);
        return resultBuf.toString();
    }

    public SimpleDateFormat getCalendarFormat() {
        SimpleDateFormat format = (SimpleDateFormat)calendarFormatter.get();
        if (format == null) {
            format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", locale);
            format.setTimeZone(gmtTimeZone);
            calendarFormatter.set(format);
        }
        return format;
    }

    public SimpleDateFormat getZoneFormat() {
        SimpleDateFormat format = (SimpleDateFormat)zoneFormatter.get();
        if (format == null) {
            format = new SimpleDateFormat("Z", locale);
            zoneFormatter.set(format);
        }
        return format;
    }

    @Override
    public Object stringToObject(String str, XMLReader reader) throws Exception {
        if (str == null) {
            return null;
        }
        boolean isNeg = str.charAt(0) == '-';
        StringBuffer zone = new StringBuffer(10);
        Date date = XSDDateTimeCalendarEncoder.decodeDateUtil(str, zone);
        String zoneStr = zone.toString();
        Calendar cal = Calendar.getInstance(gmtTimeZone);
        cal.setTime(date);
        if (zoneStr.length() != 0) {
            TimeZone tz = TimeZone.getTimeZone("GMT" + zoneStr);
            if (isNeg) {
                cal.set(0, 0);
                cal.setTime(date);
            }
            cal.setTimeZone(tz);
        } else if (isNeg) {
            cal.set(0, 0);
        } else {
            cal.set(0, 1);
        }
        return cal;
    }

    private int getDSTSavings(TimeZone tz) {
        if (VersionUtil.isJavaVersionGreaterThan1_3()) {
            return tz.getDSTSavings();
        }
        return ((SimpleTimeZone)tz).getDSTSavings();
    }

    @Override
    public void writeAdditionalNamespaceDeclarations(Object obj, XMLWriter writer) throws Exception {
    }
}

