/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.Utility;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.config.support.Strings;

class DomainXmlPreParser {
    private XMLStreamReader reader;
    private List<ClusterData> clusters = new LinkedList<ClusterData>();
    private List<String> configNames = new LinkedList<String>();
    private ClusterData cluster;
    private String instanceName;
    private String serverConfigRef;
    private boolean valid = false;
    private static final boolean debug = Boolean.parseBoolean(Utility.getEnvOrProp((String)"AS_DEBUG"));

    DomainXmlPreParser(URL domainXml, XMLInputFactory xif, String instanceNameIn) throws DomainXmlPreParserException {
        if (domainXml == null || xif == null || !StringUtils.ok((String)instanceNameIn)) {
            throw new IllegalArgumentException();
        }
        this.instanceName = instanceNameIn;
        try (InputStream in = domainXml.openStream();
             InputStreamReader isr = new InputStreamReader(in, Charset.defaultCharset().toString());){
            this.reader = xif.createXMLStreamReader(domainXml.toExternalForm(), isr);
            this.parse();
            this.postProcess();
            this.validate();
        }
        catch (DomainXmlPreParserException e) {
            throw e;
        }
        catch (Exception e2) {
            throw new DomainXmlPreParserException(e2);
        }
        finally {
            this.cleanup();
        }
    }

    final String getClusterName() {
        if (!this.valid) {
            return null;
        }
        return this.cluster.name;
    }

    final List<String> getServerNames() {
        if (!this.valid) {
            return null;
        }
        return this.cluster.serverRefs;
    }

    final String getConfigName() {
        if (!this.valid) {
            return null;
        }
        return this.cluster.configRef;
    }

    private void parse() throws XMLStreamException {
        while (this.reader.hasNext()) {
            if (this.reader.next() != 1) continue;
            this.handleElement();
        }
    }

    private void cleanup() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            this.reader = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void postProcess() {
        for (ClusterData cd : this.clusters) {
            for (String serverName : cd.serverRefs) {
                if (!this.instanceName.equals(serverName)) continue;
                this.cluster = cd;
                return;
            }
        }
        this.cluster = new ClusterData();
        this.cluster.configRef = this.serverConfigRef;
        this.cluster.serverRefs.add(this.instanceName);
    }

    private void validate() throws DomainXmlPreParserException {
        if (this.serverConfigRef == null) {
            throw new DomainXmlPreParserException(Strings.get("dxpp.serverNotFound", this.instanceName));
        }
        if (!this.serverConfigRef.equals(this.cluster.configRef)) {
            throw new DomainXmlPreParserException(Strings.get("dxpp.configrefnotmatch", this.instanceName, this.cluster.name));
        }
        if (!this.configNames.contains(this.serverConfigRef)) {
            throw new DomainXmlPreParserException(Strings.get("dxpp.confignotfound", this.instanceName, this.serverConfigRef));
        }
        this.valid = true;
    }

    private void handleElement() throws XMLStreamException {
        String name = this.reader.getLocalName();
        if (!StringUtils.ok((String)name)) {
            return;
        }
        if (name.equals("servers")) {
            this.handleServers();
        } else if (name.equals("clusters")) {
            this.handleClusters();
        } else if (name.equals("configs")) {
            this.handleConfigs();
        }
    }

    private void handleServers() throws XMLStreamException {
        DomainXmlPreParser.printf("FOUND SERVERS");
        while (this.skipToStartButNotPast("server", "servers")) {
            this.handleServer();
        }
    }

    private void handleServer() {
        String name = this.getName();
        String configRef = this.getConfigRef();
        DomainXmlPreParser.printf("SERVER: " + name + ", ref= " + configRef);
        if (this.instanceName.equals(name)) {
            this.serverConfigRef = configRef;
        }
    }

    private void handleClusters() throws XMLStreamException {
        DomainXmlPreParser.printf("FOUND CLUSTERS");
        while (this.skipToStartButNotPast("cluster", "clusters")) {
            this.handleCluster();
        }
    }

    private void handleCluster() throws XMLStreamException {
        ClusterData cd = new ClusterData();
        cd.name = this.getName();
        cd.configRef = this.getConfigRef();
        this.handleServerRefs(cd);
        this.clusters.add(cd);
        DomainXmlPreParser.printf(cd.toString());
    }

    private void handleServerRefs(ClusterData cd) throws XMLStreamException {
        while (this.skipToStartButNotPast("server-ref", "cluster")) {
            cd.serverRefs.add(this.reader.getAttributeValue(null, "ref"));
        }
    }

    private void handleConfigs() throws XMLStreamException {
        DomainXmlPreParser.printf("FOUND CONFIGS");
        while (this.skipToStartButNotPast("config", "configs")) {
            this.handleConfig();
        }
    }

    private void handleConfig() {
        String name = this.reader.getAttributeValue(null, "name");
        DomainXmlPreParser.printf("CONFIG: " + name);
        this.configNames.add(name);
    }

    private boolean skipToStartButNotPast(String startName, String stopName) throws XMLStreamException {
        if (!StringUtils.ok((String)startName) || !StringUtils.ok((String)stopName)) {
            throw new IllegalArgumentException();
        }
        while (this.reader.hasNext()) {
            this.reader.next();
            if (this.reader.isStartElement() && startName.equals(this.reader.getLocalName())) {
                return true;
            }
            if (!this.reader.isEndElement() || !stopName.equals(this.reader.getLocalName())) continue;
            return false;
        }
        return false;
    }

    private String getName() {
        return this.reader.getAttributeValue(null, "name");
    }

    private String getConfigRef() {
        return this.reader.getAttributeValue(null, "config-ref");
    }

    private static void printf(String s) {
        if (debug) {
            System.out.println(s);
        }
    }

    private static class ClusterData {
        String name;
        String configRef;
        List<String> serverRefs = new ArrayList<String>();

        private ClusterData() {
        }

        public String toString() {
            return "Cluster:name=" + this.name + ", config-ref=" + this.configRef + ", server-refs = " + this.serverRefs;
        }
    }

    static class DomainXmlPreParserException
    extends Exception {
        DomainXmlPreParserException(Throwable t) {
            super(t);
        }

        private DomainXmlPreParserException(String s) {
            super(s);
        }
    }
}

