/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.services;

import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.jboss.weld.serialization.spi.ProxyServices;

public class ProxyServicesImpl
implements ProxyServices {
    ClassLoaderHierarchy clh;

    public ProxyServicesImpl(ServiceLocator services) {
        this.clh = (ClassLoaderHierarchy)services.getService(ClassLoaderHierarchy.class, new Annotation[0]);
    }

    public ClassLoader getClassLoader(final Class<?> proxiedBeanType) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return ProxyServicesImpl.this.getClassLoaderforBean(proxiedBeanType);
                }
            });
        }
        return this.getClassLoaderforBean(proxiedBeanType);
    }

    private ClassLoader getClassLoaderforBean(Class<?> proxiedBeanType) {
        ClassLoader prxCL = proxiedBeanType.getClassLoader();
        boolean isAppCL = this.isApplicationClassLoader(prxCL);
        if (!isAppCL) {
            prxCL = this._getClassLoader();
        }
        return prxCL;
    }

    private boolean isApplicationClassLoader(ClassLoader prxCL) {
        boolean isAppCL = false;
        while (prxCL != null) {
            if (prxCL.equals(this.clh.getCommonClassLoader())) {
                isAppCL = true;
                break;
            }
            prxCL = prxCL.getParent();
        }
        return isAppCL;
    }

    private ClassLoader _getClassLoader() {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        return tcl;
    }

    public Class<?> loadBeanClass(final String className) {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        ClassLoader cl = ProxyServicesImpl.this._getClassLoader();
                        return Class.forName(className, true, cl);
                    }
                });
            }
            ClassLoader cl = this._getClassLoader();
            return Class.forName(className, true, cl);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public void cleanup() {
    }
}

