/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws.servedcontent;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.net.URI;
import java.util.Properties;
import org.glassfish.appclient.server.core.AppClientDeployerHelper;
import org.glassfish.appclient.server.core.NestedAppClientDeployerHelper;
import org.glassfish.appclient.server.core.StandaloneAppClientDeployerHelper;
import org.glassfish.appclient.server.core.jws.JWSAdapterManager;
import org.glassfish.appclient.server.core.jws.JavaWebStartInfo;
import org.glassfish.appclient.server.core.jws.NamingConventions;
import org.glassfish.appclient.server.core.jws.servedcontent.NestedClientTokenHelper;
import org.glassfish.appclient.server.core.jws.servedcontent.StandAloneClientTokenHelper;

public abstract class TokenHelper {
    private static final String AGENT_JAR = "gf-client.jar";
    private static final String DYN_PREFIX = "___dyn/";
    private static final String GROUP_JAR_ELEMENT_PROPERTY_NAME = "group.facade.jar.element";
    private Properties tokens;
    protected final AppClientDeployerHelper dHelper;
    private final LocalStringsImpl localStrings = new LocalStringsImpl(TokenHelper.class);
    private JavaWebStartInfo.VendorInfo vendorInfo = null;
    private String signingAlias;

    public static TokenHelper newInstance(AppClientDeployerHelper dHelper, JavaWebStartInfo.VendorInfo vendorInfo) {
        TokenHelper tHelper;
        if (dHelper instanceof StandaloneAppClientDeployerHelper) {
            tHelper = new StandAloneClientTokenHelper(dHelper);
        } else if (dHelper instanceof NestedAppClientDeployerHelper) {
            tHelper = new NestedClientTokenHelper((NestedAppClientDeployerHelper)dHelper);
        } else {
            throw new RuntimeException("dHelper.getClass() = " + dHelper.getClass().getName() + " != NestedAppClientDeployerHelper");
        }
        tHelper.vendorInfo = vendorInfo;
        tHelper.signingAlias = JWSAdapterManager.signingAlias(dHelper.dc());
        tHelper.tokens = super.buildTokens();
        return tHelper;
    }

    public Properties tokens() {
        return this.tokens;
    }

    public Object setProperty(String propName, String propValue) {
        return this.tokens.setProperty(propName, propValue);
    }

    public String imageURIFromDescriptor() {
        return this.vendorInfo.getImageURI();
    }

    public String splashScreenURIFromDescriptor() {
        return this.vendorInfo.getSplashImageURI();
    }

    protected TokenHelper(AppClientDeployerHelper dHelper) {
        this.dHelper = dHelper;
    }

    public String appCodebasePath() {
        return NamingConventions.contextRootForAppAdapter(this.dHelper.appName());
    }

    public String systemContextRoot() {
        return "/___JWSappclient/___system";
    }

    public String agentJar() {
        return AGENT_JAR;
    }

    public String systemJNLP() {
        return NamingConventions.systemJNLPURI(this.signingAlias);
    }

    public abstract String appLibraryExtensions();

    protected abstract String anchorSubpath();

    public String mainJNLP() {
        return this.dyn() + this.anchorSubpath() + "___main.jnlp";
    }

    public String clientJNLP() {
        return this.dyn() + this.anchorSubpath() + "___client.jnlp";
    }

    public String clientFacadeJNLP() {
        return this.dyn() + this.anchorSubpath() + "___clientFacade.jnlp";
    }

    public String dyn() {
        return DYN_PREFIX;
    }

    protected AppClientDeployerHelper dHelper() {
        return this.dHelper;
    }

    public String clientFacadeJARPath() {
        return this.anchorSubpath() + this.dHelper.clientName();
    }

    private Properties buildTokens() {
        Properties t = new Properties();
        t.setProperty("app.codebase.path", this.appCodebasePath());
        t.setProperty("main.jnlp.path", this.mainJNLP());
        t.setProperty("system.context.root", this.systemContextRoot());
        t.setProperty("agent.jar", this.agentJar());
        t.setProperty("system.jnlp", this.systemJNLP());
        t.setProperty("client.jnlp.path", this.clientJNLP());
        t.setProperty("app.library.extension", this.appLibraryExtensions());
        t.setProperty("anchor.subpath", this.anchorSubpath());
        t.setProperty("dyn", this.dyn());
        t.setProperty("client.facade.jar.path", this.clientFacadeJARPath());
        t.setProperty("client.security", "<all-permissions/>");
        ApplicationClientDescriptor acDesc = this.dHelper.appClientDesc();
        String displayName = acDesc.getDisplayName();
        String jnlpInformationTitle = displayName != null && displayName.length() > 0 ? displayName : this.localStrings.get("jws.information.title.prefix") + " " + this.dHelper.appName();
        t.setProperty("appclient.main.information.title", jnlpInformationTitle);
        t.setProperty("appclient.client.information.title", jnlpInformationTitle);
        t.setProperty("appclient.main.information.description.one-line", jnlpInformationTitle);
        t.setProperty("appclient.client.information.description.one-line", jnlpInformationTitle);
        String description = acDesc.getDescription();
        String jnlpInformationShortDescription = description != null && description.length() > 0 ? description : jnlpInformationTitle;
        t.setProperty("appclient.main.information.description.short", jnlpInformationShortDescription);
        t.setProperty("appclient.client.information.description.short", jnlpInformationShortDescription);
        t.setProperty("appclient.vendor", this.vendorInfo.getVendor());
        t.setProperty("appclient.main.information.images", this.iconElements(this.vendorInfo));
        URI groupFacadeUserURI = this.dHelper.groupFacadeUserURI(this.dHelper.dc());
        t.setProperty(GROUP_JAR_ELEMENT_PROPERTY_NAME, groupFacadeUserURI == null ? "" : "<jar href=\"" + groupFacadeUserURI.toASCIIString() + "\"/>");
        this.setSystemJNLPTokens(t);
        return t;
    }

    private String iconElements(JavaWebStartInfo.VendorInfo vendorInfo) {
        String splashImageURI;
        StringBuilder result = new StringBuilder();
        String imageURI = vendorInfo.JNLPImageURI();
        if (imageURI.length() > 0) {
            result.append("<icon href=\"" + imageURI + "\"/>");
        }
        if ((splashImageURI = vendorInfo.JNLPSplashImageURI()).length() > 0) {
            result.append("<icon kind=\"splash\" href=\"" + splashImageURI + "\"/>");
        }
        return result.toString();
    }

    private void setSystemJNLPTokens(Properties props) {
        String[] tokenNames;
        for (String tokenName : tokenNames = new String[]{"jws.appserver.information.title", "jws.appserver.information.vendor", "jws.appserver.information.description.one-line", "jws.appserver.information.description.short"}) {
            String value = this.localStrings.get(tokenName);
            props.setProperty(tokenName, value);
        }
    }
}

