/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.ArraySerializerHelper;
import com.sun.xml.rpc.encoding.soap.SOAPConstants;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.streaming.XMLWriterUtil;
import javax.xml.namespace.QName;

class SOAP11ArraySerializerHelper
implements ArraySerializerHelper {
    SOAP11ArraySerializerHelper() {
    }

    @Override
    public void serializeArray(QName elemType, String encodedDims, XMLWriter writer) {
        String attrVal = XMLWriterUtil.encodeQName(writer, elemType) + encodedDims;
        writer.writeAttributeUnquoted(SOAPConstants.QNAME_ENCODING_ARRAYTYPE, attrVal);
    }

    @Override
    public String encodeArrayDimensions(int[] dims) {
        StringBuffer buf = new StringBuffer("[");
        for (int i = 0; i < dims.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(dims[i]);
        }
        buf.append(']');
        return buf.toString();
    }

    @Override
    public String getArrayType(Attributes attrs) {
        return attrs.getValue("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
    }

    @Override
    public String getElemTypeStr(String arrayType) {
        int idx = arrayType.indexOf(91);
        if (idx >= 0) {
            return arrayType.substring(0, idx).trim();
        }
        return null;
    }

    @Override
    public QName getArrayQnameEncoding() {
        return SOAPConstants.QNAME_ENCODING_ARRAY;
    }

    @Override
    public void whatAmI() {
        System.out.println("I am SOAP11");
    }
}

