/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.saml.assertion.saml20.jaxb20;

import com.sun.xml.wss.logging.LogStringsMessages;
import com.sun.xml.wss.saml.SAMLException;
import com.sun.xml.wss.saml.assertion.saml20.jaxb20.AuthnContext;
import com.sun.xml.wss.saml.assertion.saml20.jaxb20.SubjectLocality;
import com.sun.xml.wss.saml.internal.saml20.jaxb20.AuthnStatementType;
import com.sun.xml.wss.saml.util.SAML20JAXBUtil;
import com.sun.xml.wss.util.DateUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AuthnStatement
extends AuthnStatementType
implements com.sun.xml.wss.saml.AuthnStatement {
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    private Date authnInstantDate = null;
    private Date sessionDate = null;

    protected AuthnStatement() {
    }

    public static AuthnStatementType fromElement(Element element) throws SAMLException {
        try {
            JAXBContext jc = SAML20JAXBUtil.getJAXBContext();
            Unmarshaller u = jc.createUnmarshaller();
            return (AuthnStatementType)u.unmarshal((Node)element);
        }
        catch (Exception ex) {
            throw new SAMLException(ex.getMessage());
        }
    }

    public AuthnStatement(GregorianCalendar authInstant, SubjectLocality subjectLocality, AuthnContext authnContext, String sessionIndex, GregorianCalendar sessionNotOnOrAfter) {
        DatatypeFactory factory2;
        if (authInstant != null) {
            try {
                factory2 = DatatypeFactory.newInstance();
                this.setAuthnInstant(factory2.newXMLGregorianCalendar(authInstant));
            }
            catch (DatatypeConfigurationException factory2) {
                // empty catch block
            }
        }
        if (subjectLocality != null) {
            this.setSubjectLocality(subjectLocality);
        }
        if (authnContext != null) {
            this.setAuthnContext(authnContext);
        }
        if (sessionIndex != null) {
            this.setSessionIndex(sessionIndex);
        }
        if (sessionNotOnOrAfter != null) {
            try {
                factory2 = DatatypeFactory.newInstance();
                this.setSessionNotOnOrAfter(factory2.newXMLGregorianCalendar(sessionNotOnOrAfter));
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                // empty catch block
            }
        }
    }

    public AuthnStatement(AuthnStatementType authStmtType) {
        this.setAuthnInstant(authStmtType.getAuthnInstant());
        this.setAuthnContext(authStmtType.getAuthnContext());
        this.setSubjectLocality(authStmtType.getSubjectLocality());
        this.setSessionIndex(authStmtType.getSessionIndex());
        this.setSessionNotOnOrAfter(authStmtType.getSessionNotOnOrAfter());
    }

    @Override
    public Date getAuthnInstantDate() {
        if (this.authnInstantDate != null) {
            return this.authnInstantDate;
        }
        try {
            if (super.getAuthnInstant() != null) {
                this.authnInstantDate = DateUtils.stringToDate(super.getAuthnInstant().toString());
            }
        }
        catch (ParseException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0429_SAML_AUTH_INSTANT_OR_SESSION_PARSE_FAILED(), ex);
        }
        return this.authnInstantDate;
    }

    @Override
    public Date getSessionNotOnOrAfterDate() {
        if (this.sessionDate != null) {
            return this.sessionDate;
        }
        try {
            if (super.getSessionNotOnOrAfter() != null) {
                this.sessionDate = DateUtils.stringToDate(super.getSessionNotOnOrAfter().toString());
            }
        }
        catch (ParseException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0429_SAML_AUTH_INSTANT_OR_SESSION_PARSE_FAILED(), ex);
        }
        return this.sessionDate;
    }

    @Override
    public String getSubjectLocalityAddress() {
        if (super.getSubjectLocality() != null) {
            return super.getSubjectLocality().getAddress();
        }
        return null;
    }

    @Override
    public String getSubjectLocalityDNSName() {
        if (super.getSubjectLocality() != null) {
            return super.getSubjectLocality().getDNSName();
        }
        return null;
    }

    @Override
    public String getAuthnContextClassRef() {
        for (JAXBElement<?> obj : super.getAuthnContext().getContent()) {
            JAXBElement<?> element;
            if (!(obj instanceof JAXBElement) || !(element = obj).getName().getLocalPart().equalsIgnoreCase("AuthnContextClassRef")) continue;
            return element.getValue().toString();
        }
        return null;
    }

    @Override
    public String getAuthenticatingAuthority() {
        for (JAXBElement<?> obj : super.getAuthnContext().getContent()) {
            JAXBElement<?> element;
            if (!(obj instanceof JAXBElement) || !(element = obj).getName().getLocalPart().equalsIgnoreCase("AuthenticatingAuthority")) continue;
            return element.getValue().toString();
        }
        return null;
    }

    @Override
    public String getSessionIndex() {
        if (super.getSessionIndex() != null) {
            return super.getSessionIndex();
        }
        return null;
    }
}

