/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JExportsDirective;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JModuleDirective;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JRequiresDirective;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class JModule {
    private static final String FILE_NAME = "module-info.java";
    private final String name;
    private final Set<JModuleDirective> directives;

    JModule(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Value of name is null");
        }
        this.name = name;
        this.directives = new HashSet<JModuleDirective>();
    }

    public String name() {
        return this.name;
    }

    Set<JModuleDirective> getDirectives() {
        return this.directives;
    }

    public void _exports(JPackage pkg) {
        this.directives.add(new JExportsDirective(pkg.name()));
    }

    public void _exports(Collection<JPackage> pkgs, boolean addEmpty) {
        for (JPackage pkg : pkgs) {
            if (!addEmpty && !pkg.hasClasses()) continue;
            this._exports(pkg);
        }
    }

    public void _requires(String name, boolean isPublic, boolean isStatic) {
        this.directives.add(new JRequiresDirective(name, isPublic, isStatic));
    }

    public void _requires(String name) {
        this.directives.add(new JRequiresDirective(name, false, false));
    }

    public void _requires(boolean isPublic, boolean isStatic, String ... names) {
        if (names != null) {
            for (String reqName : names) {
                this._requires(reqName, isPublic, isStatic);
            }
        }
    }

    public void _requires(String ... names) {
        this._requires(false, false, names);
    }

    public JFormatter generate(JFormatter f) {
        f.p("module").p(this.name);
        f.p('{').nl();
        if (!this.directives.isEmpty()) {
            f.i();
            for (JModuleDirective directive : this.directives) {
                directive.generate(f);
            }
            f.o();
        }
        f.p('}').nl();
        return f;
    }

    private JFormatter createModuleInfoSourceFileWriter(CodeWriter src) throws IOException {
        BufferedWriter bw = new BufferedWriter(src.openSource(null, FILE_NAME));
        return new JFormatter(new PrintWriter(bw));
    }

    void build(CodeWriter src) throws IOException {
        JFormatter f = this.createModuleInfoSourceFileWriter(src);
        this.generate(f);
        f.close();
    }
}

