/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.jms.system;

import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.jms.JMSLoggerInfo;
import com.sun.enterprise.transaction.config.TransactionService;
import com.sun.enterprise.transaction.spi.RecoveryResourceHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.xa.XAResource;
import org.glassfish.api.logging.LogHelper;
import org.glassfish.resources.config.ExternalJndiResource;
import org.jvnet.hk2.annotations.Service;

@Service
public class LegacyJmsRecoveryResourceHandler
implements RecoveryResourceHandler {
    @Inject
    @Named(value="default-instance-name")
    private TransactionService txService;
    @Inject
    private Resources resources;
    static final String JMS_QUEUE_CONNECTION_FACTORY = "javax.jms.QueueConnectionFactory";
    static final String JMS_TOPIC_CONNECTION_FACTORY = "javax.jms.TopicConnectionFactory";
    private static final Logger _logger = JMSLoggerInfo.getLogger();
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(LegacyJmsRecoveryResourceHandler.class);
    private Object jmsAdmin = null;

    public void loadXAResourcesAndItsConnections(List xaresList, List connList) {
        block6: {
            try {
                Collection jndiResources = this.resources.getResources(ExternalJndiResource.class);
                InitialContext ic = new InitialContext();
                for (ExternalJndiResource jndiResource : jndiResources) {
                    if (!this.isEnabled(jndiResource)) continue;
                    try {
                        ic.lookup(jndiResource.getJndiName());
                        if (!this.isJMSConnectionFactory(jndiResource)) continue;
                        String jndiName = jndiResource.getJndiName();
                        Object objext = ic.lookup(jndiName);
                        if (!this.instanceOf(objext, "ConnectionFactory")) {
                            throw new NamingException(localStrings.getLocalString("recovery.unexpected_objtype", "Unexpected object type " + objext.getClass().getName() + " for " + jndiName, new Object[]{objext.getClass().getName(), jndiName}));
                        }
                        Object jmsXAConnectionFactory = this.wrapJMSConnectionFactoryObject(objext);
                        boolean isQueue = this.instanceOf(objext, "QueueConnectionFactory");
                        this.recoverJMSXAResource(xaresList, connList, jmsXAConnectionFactory, isQueue);
                    }
                    catch (Exception ex) {
                        _logger.log(Level.SEVERE, "AS-JMS-CORE-00022", new Object[]{jndiResource.getJndiName()});
                        if (!_logger.isLoggable(Level.FINE)) continue;
                        _logger.log(Level.FINE, ex.toString(), ex);
                    }
                }
            }
            catch (NamingException ne) {
                _logger.log(Level.SEVERE, "AS-JMS-CORE-00022", new Object[]{ne.getMessage()});
                if (!_logger.isLoggable(Level.FINE)) break block6;
                _logger.log(Level.FINE, ne.toString(), ne);
            }
        }
    }

    public void closeConnections(List connList) {
        for (Object obj : connList) {
            try {
                this.closeXAConnection(obj);
            }
            catch (Exception ex) {
                LogHelper.log((Logger)_logger, (Level)Level.WARNING, (String)"AS-JMS-CORE-00013", (Throwable)ex, (Object[])new Object[0]);
            }
        }
    }

    private boolean isEnabled(ExternalJndiResource resource) {
        return Boolean.valueOf(resource.getEnabled());
    }

    public boolean isJMSConnectionFactory(ExternalJndiResource resType_) {
        if (resType_ == null) {
            return false;
        }
        return JMS_QUEUE_CONNECTION_FACTORY.equals(resType_.getResType()) || JMS_TOPIC_CONNECTION_FACTORY.equals(resType_.getResType());
    }

    private boolean instanceOf(Object obj, String interfaceName) {
        Class<?>[] classes;
        if (obj == null) {
            return false;
        }
        for (Class<?> aClass : classes = obj.getClass().getInterfaces()) {
            String aClassName = aClass.getName();
            if (aClassName.indexOf(interfaceName) == -1) continue;
            return true;
        }
        return false;
    }

    private void recoverJMSXAResource(List xaresList, List connList, Object jmsXAConnectionFactory, boolean isQueue) throws Exception {
        if (isQueue) {
            Object jmsXAQueueConnection = this.getXAConnection(jmsXAConnectionFactory, "createXAQueueConnection");
            connList.add(jmsXAQueueConnection);
            XAResource xares = this.getXAResource(jmsXAQueueConnection, "createXAQueueSession");
            xaresList.add(xares);
        } else {
            Object jmsXATopicConnection = this.getXAConnection(jmsXAConnectionFactory, "createXATopicConnection");
            connList.add(jmsXATopicConnection);
            XAResource xares = this.getXAResource(jmsXATopicConnection, "createXATopicSession");
            xaresList.add(xares);
        }
    }

    private Object getJmsAdmin() {
        if (this.jmsAdmin != null) {
            return this.jmsAdmin;
        }
        try {
            Class<?> jmsAdminFactoryClass = Class.forName("com.sun.messaging.jmq.admin.jmsspi.JMSAdminFactoryImpl");
            Object jmsAdminFactory = jmsAdminFactoryClass.newInstance();
            Method m = jmsAdminFactoryClass.getMethod("getJMSAdmin", null);
            this.jmsAdmin = m.invoke(jmsAdminFactory, null);
            return this.jmsAdmin;
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to create an JmsAdmin object. Cause - " + ex.getMessage(), ex);
        }
    }

    private Object wrapJMSConnectionFactoryObject(Object obj) throws Exception {
        Method m = this.getJmsAdmin().getClass().getMethod("wrapJMSConnectionFactoryObject", obj.getClass());
        return m.invoke(this.getJmsAdmin(), obj);
    }

    private Object getXAConnection(Object XAconnectionFactory, String methodName) {
        try {
            Class<?> connectionFactoryClass = XAconnectionFactory.getClass();
            Method m = connectionFactoryClass.getMethod(methodName, null);
            return m.invoke(XAconnectionFactory, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private XAResource getXAResource(Object XAConnection, String methodName) {
        try {
            Class<?> connectionClass = XAConnection.getClass();
            Class[] paramtypes = new Class[]{Boolean.TYPE, Integer.TYPE};
            Method m = connectionClass.getMethod(methodName, paramtypes);
            Object jmsXASession = m.invoke(XAConnection, true, 1);
            Class<?> xaSessionClass = jmsXASession.getClass();
            Method m1 = xaSessionClass.getMethod("getXAResource", null);
            return (XAResource)m1.invoke(jmsXASession, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void closeXAConnection(Object jmsXAConnection) {
        try {
            Class<?> jmsXAConnectionClass = jmsXAConnection.getClass();
            Method m = jmsXAConnectionClass.getMethod("close", null);
            m.invoke(jmsXAConnection, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

