/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.bean.proxy.CombinedInterceptorAndDecoratorStackMethodHandler;
import org.jboss.weld.bean.proxy.DecorationHelper;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.bean.proxy.ProxyObject;
import org.jboss.weld.bean.proxy.TargetBeanInstance;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.injection.producer.ForwardingInstantiator;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.serialization.spi.ContextualStore;

public abstract class AbstractDecoratorApplyingInstantiator<T>
extends ForwardingInstantiator<T> {
    private final Bean<T> bean;
    private final Class<T> proxyClass;
    private final List<Decorator<?>> decorators;

    public AbstractDecoratorApplyingInstantiator(String contextId, Instantiator<T> delegate, Bean<T> bean, List<Decorator<?>> decorators, Class<? extends T> implementationClass) {
        super(delegate);
        this.bean = bean;
        this.decorators = decorators;
        ProxyFactory factory = new ProxyFactory(contextId, implementationClass, (Set<? extends Type>)bean.getTypes(), bean, true);
        this.proxyClass = factory.getProxyClass();
    }

    @Override
    public T newInstance(CreationalContext<T> ctx, BeanManagerImpl manager) {
        InjectionPoint originalInjectionPoint = (InjectionPoint)manager.getServices().get(CurrentInjectionPoint.class).peek();
        return this.applyDecorators(this.delegate().newInstance(ctx, manager), ctx, originalInjectionPoint, manager);
    }

    protected abstract T applyDecorators(T var1, CreationalContext<T> var2, InjectionPoint var3, BeanManagerImpl var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T getOuterDelegate(T instance, CreationalContext<T> creationalContext, InjectionPoint originalInjectionPoint, BeanManagerImpl manager) {
        TargetBeanInstance beanInstance = new TargetBeanInstance(this.bean, instance);
        DecorationHelper<T> decorationHelper = new DecorationHelper<T>(beanInstance, this.bean, this.proxyClass, manager, manager.getServices().get(ContextualStore.class), this.decorators);
        DecorationHelper.push(decorationHelper);
        try {
            T outerDelegate = decorationHelper.getNextDelegate(originalInjectionPoint, creationalContext);
            if (outerDelegate == null) {
                throw new WeldException(BeanLogger.LOG.proxyInstantiationFailed(this));
            }
            T t = outerDelegate;
            return t;
        }
        finally {
            DecorationHelper.pop();
        }
    }

    protected void registerOuterDecorator(ProxyObject instance, T outerDelegate) {
        CombinedInterceptorAndDecoratorStackMethodHandler wrapperMethodHandler = (CombinedInterceptorAndDecoratorStackMethodHandler)instance.getHandler();
        wrapperMethodHandler.setOuterDecorator(outerDelegate);
    }

    public Bean<T> getBean() {
        return this.bean;
    }

    public Class<T> getProxyClass() {
        return this.proxyClass;
    }

    public List<Decorator<?>> getDecorators() {
        return this.decorators;
    }

    @Override
    public boolean hasDecoratorSupport() {
        return true;
    }
}

