/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.felix.eventadmin.impl.tasks.HandlerTask;
import org.apache.felix.eventadmin.impl.util.LogWrapper;

public class BlacklistLatch {
    private final Semaphore internalSemaphore;
    private final int count;
    private final long timeout;
    private final List<HandlerTask> handlerTasks;

    public BlacklistLatch(int count, long timeout) {
        this.handlerTasks = new ArrayList<HandlerTask>(count);
        this.count = count;
        this.timeout = timeout;
        this.internalSemaphore = new Semaphore(count);
        this.internalSemaphore.drainPermits();
    }

    public void countDown() {
        this.internalSemaphore.release();
    }

    public void addToBlacklistCheck(HandlerTask task) {
        this.handlerTasks.add(task);
    }

    public void awaitAndBlacklistCheck() {
        try {
            while (!this.internalSemaphore.tryAcquire(this.count, this.timeout, TimeUnit.MILLISECONDS)) {
                for (HandlerTask currentTask : this.handlerTasks) {
                    currentTask.checkForBlacklist();
                }
            }
        }
        catch (InterruptedException e) {
            LogWrapper.getLogger().log(2, "Event Task Processing Interrupted. Events may not be recieved in proper order.");
        }
    }
}

