/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.parser;

import com.sun.enterprise.server.logging.LogFacade;
import com.sun.enterprise.server.logging.parser.LogParser;
import com.sun.enterprise.server.logging.parser.LogParserException;
import com.sun.enterprise.server.logging.parser.LogParserFactory;
import com.sun.enterprise.server.logging.parser.LogParserListener;
import com.sun.enterprise.server.logging.parser.ParsedLogRecord;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

final class UniformLogParser
implements LogParser {
    private static final LocalStringManagerImpl LOCAL_STRINGS = new LocalStringManagerImpl(UniformLogParser.class);
    static final String FIELD_SEPARATOR = "\\|";
    static final String LOG_RECORD_BEGIN_MARKER = "[#|";
    static final String LOG_RECORD_END_MARKER = "|#]";
    private static final int ULF_FIELD_COUNT = 6;
    private static final Map<String, String> FIELD_NAME_ALIASES = new HashMap<String, String>(){
        private static final long serialVersionUID = -2041470292369513712L;
        {
            this.put("_ThreadID", "threadId");
            this.put("_TimeMillis", "timeMillis");
            this.put("_LevelValue", "levelValue");
            this.put("_UserID", "user");
            this.put("_ECID", "ecid");
            this.put("_MessageID", "msgId");
        }
    };
    private String streamName;

    public UniformLogParser(String name) {
        this.streamName = name;
    }

    @Override
    public void parseLog(BufferedReader reader, LogParserListener listener) throws LogParserException {
        try {
            String logRecord;
            String line = null;
            StringBuffer buffer = new StringBuffer();
            long position = 0L;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(LOG_RECORD_BEGIN_MARKER)) {
                    logRecord = buffer.toString();
                    this.parseLogRecord(position, logRecord, listener);
                    position += (long)logRecord.length();
                    buffer = new StringBuffer();
                }
                buffer.append(line);
                buffer.append(LogParserFactory.NEWLINE);
            }
            logRecord = buffer.toString();
            this.parseLogRecord(position, logRecord, listener);
        }
        catch (IOException e) {
            throw new LogParserException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LogFacade.LOGGING_LOGGER.log(Level.FINE, "Got exception while clsoing reader " + this.streamName, e);
                }
            }
        }
    }

    private void parseLogRecord(long position, String logRecord, LogParserListener listener) {
        ParsedLogRecord parsedLogRecord = new ParsedLogRecord();
        if (this.initializeUniformFormatLogRecord(parsedLogRecord, logRecord)) {
            listener.foundLogRecord(position, parsedLogRecord);
        }
    }

    private boolean initializeUniformFormatLogRecord(ParsedLogRecord parsedLogRecord, String logRecord) {
        parsedLogRecord.setFormattedLogRecord(logRecord);
        int beginIndex = logRecord.indexOf(LOG_RECORD_BEGIN_MARKER);
        if (beginIndex < 0) {
            return false;
        }
        int endIndex = logRecord.lastIndexOf(LOG_RECORD_END_MARKER);
        if (endIndex < 0) {
            return false;
        }
        if (logRecord.length() < LOG_RECORD_BEGIN_MARKER.length() + LOG_RECORD_END_MARKER.length()) {
            return false;
        }
        String logData = logRecord.substring(beginIndex + LOG_RECORD_BEGIN_MARKER.length(), endIndex);
        String[] fieldValues = logData.split(FIELD_SEPARATOR);
        if (fieldValues.length < 6) {
            String msg = LOCAL_STRINGS.getLocalString("parser.illegal.ulf.record", "Illegal Uniform format log record {0} found", new Object[]{logRecord});
            throw new IllegalArgumentException(msg);
        }
        for (int i = 0; i < 6; ++i) {
            this.populateLogRecordFields(i, fieldValues[i], parsedLogRecord);
        }
        if (fieldValues.length > 6) {
            StringBuffer buf = new StringBuffer();
            buf.append(parsedLogRecord.getFieldValue("message"));
            for (int i = 6; i < fieldValues.length; ++i) {
                buf.append("|");
                buf.append(fieldValues[i]);
            }
            parsedLogRecord.setFieldValue("message", buf.toString());
        }
        return true;
    }

    private void populateLogRecordFields(int index, String fieldData, ParsedLogRecord parsedLogRecord) {
        switch (index) {
            case 0: {
                parsedLogRecord.setFieldValue("timestamp", fieldData);
                break;
            }
            case 1: {
                parsedLogRecord.setFieldValue("level", fieldData);
                break;
            }
            case 2: {
                parsedLogRecord.setFieldValue("productId", fieldData);
                break;
            }
            case 3: {
                parsedLogRecord.setFieldValue("logger", fieldData);
                break;
            }
            case 4: {
                String[] nv_pairs;
                for (String pair : nv_pairs = fieldData.split(";")) {
                    String[] nameValue = pair.split("=");
                    if (nameValue.length != 2) continue;
                    String name = nameValue[0];
                    String value = nameValue[1];
                    if (FIELD_NAME_ALIASES.containsKey(name)) {
                        name = FIELD_NAME_ALIASES.get(name);
                        parsedLogRecord.setFieldValue(name, value);
                        continue;
                    }
                    Properties props = (Properties)parsedLogRecord.getFieldValue("suppAttrs");
                    props.put(name, value);
                }
                break;
            }
            case 5: {
                parsedLogRecord.setFieldValue("message", fieldData);
                break;
            }
        }
    }
}

