/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events.configurator;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.inject.Qualifier;
import org.jboss.weld.util.collections.ImmutableSet;

class Configurators {
    private Configurators() {
    }

    static Set<Annotation> getQualifiers(Annotated annotated) {
        return (Set)annotated.getAnnotations().stream().filter(a -> a.annotationType().isAnnotationPresent(Qualifier.class)).collect(ImmutableSet.collector());
    }

    static Set<Annotation> getQualifiers(AnnotatedElement annotatedElement) {
        Annotation[] annotations;
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        for (Annotation annotation : annotations = annotatedElement.getDeclaredAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            qualifiers.add(annotation);
        }
        return qualifiers;
    }

    @SafeVarargs
    static Set<Parameter> getAnnotatedParameters(Method method, Class<? extends Annotation> ... annotationClasses) {
        Parameter[] parameters;
        if (method.getParameterCount() == 0) {
            return Collections.emptySet();
        }
        HashSet<Parameter> annotatedParameters = new HashSet<Parameter>();
        block0: for (Parameter parameter : parameters = method.getParameters()) {
            for (Class<? extends Annotation> annotationClass : annotationClasses) {
                if (!parameter.isAnnotationPresent(annotationClass)) continue;
                annotatedParameters.add(parameter);
                continue block0;
            }
        }
        return annotatedParameters;
    }
}

