/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets.rfc6455;

import java.net.URI;
import java.util.Locale;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.FrameType;
import org.glassfish.grizzly.websockets.HandShake;
import org.glassfish.grizzly.websockets.Masker;
import org.glassfish.grizzly.websockets.ProtocolError;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.frametypes.BinaryFrameType;
import org.glassfish.grizzly.websockets.frametypes.ClosingFrameType;
import org.glassfish.grizzly.websockets.frametypes.ContinuationFrameType;
import org.glassfish.grizzly.websockets.frametypes.PingFrameType;
import org.glassfish.grizzly.websockets.frametypes.PongFrameType;
import org.glassfish.grizzly.websockets.frametypes.TextFrameType;
import org.glassfish.grizzly.websockets.rfc6455.RFC6455HandShake;

public class RFC6455Handler
extends ProtocolHandler {
    private final ParsingState state = new ParsingState();

    public RFC6455Handler(boolean mask) {
        super(mask);
    }

    @Override
    public HandShake createClientHandShake(URI uri) {
        return new RFC6455HandShake(uri);
    }

    @Override
    public HandShake createServerHandShake(HttpContent requestContent) {
        return new RFC6455HandShake((HttpRequestPacket)requestContent.getHttpHeader());
    }

    @Override
    public byte[] frame(DataFrame frame) {
        byte opcode = this.checkForLastFrame(frame, this.getOpcode(frame.getType()));
        byte[] bytes = frame.getType().getBytes(frame);
        byte[] lengthBytes = this.encodeLength(bytes.length);
        int length = 1 + lengthBytes.length + bytes.length + (this.maskData ? 4 : 0);
        int payloadStart = 1 + lengthBytes.length + (this.maskData ? 4 : 0);
        byte[] packet = new byte[length];
        packet[0] = opcode;
        System.arraycopy(lengthBytes, 0, packet, 1, lengthBytes.length);
        if (this.maskData) {
            Masker masker = new Masker();
            packet[1] = (byte)(packet[1] | 0x80);
            masker.mask(packet, payloadStart, bytes);
            System.arraycopy(masker.getMask(), 0, packet, payloadStart - 4, 4);
        } else {
            System.arraycopy(bytes, 0, packet, payloadStart, bytes.length);
        }
        return packet;
    }

    @Override
    public DataFrame parse(Buffer buffer) {
        DataFrame dataFrame;
        try {
            switch (this.state.state) {
                case 0: {
                    byte lengthCode;
                    boolean rsvBitSet;
                    if (buffer.remaining() < 2) {
                        return null;
                    }
                    byte opcode = buffer.get();
                    boolean bl = rsvBitSet = this.isBitSet(opcode, 6) || this.isBitSet(opcode, 5) || this.isBitSet(opcode, 4);
                    if (rsvBitSet) {
                        throw new ProtocolError("RSV bit(s) incorrectly set.");
                    }
                    this.state.finalFragment = this.isBitSet(opcode, 7);
                    this.state.controlFrame = this.isControlFrame(opcode);
                    this.state.opcode = (byte)(opcode & 0x7F);
                    this.state.frameType = this.valueOf(this.inFragmentedType, this.state.opcode);
                    if (!this.state.finalFragment && this.state.controlFrame) {
                        throw new ProtocolError("Fragmented control frame");
                    }
                    if (!this.state.controlFrame) {
                        if (this.isContinuationFrame(this.state.opcode) && !this.processingFragment) {
                            throw new ProtocolError("End fragment sent, but wasn't processing any previous fragments");
                        }
                        if (this.processingFragment && !this.isContinuationFrame(this.state.opcode)) {
                            throw new ProtocolError("Fragment sent but opcode was not 0");
                        }
                        if (!this.state.finalFragment && !this.isContinuationFrame(this.state.opcode)) {
                            this.processingFragment = true;
                        }
                        if (!this.state.finalFragment && this.inFragmentedType == 0) {
                            this.inFragmentedType = this.state.opcode;
                        }
                    }
                    this.state.masked = ((lengthCode = buffer.get()) & 0x80) == 128;
                    this.state.masker = new Masker(buffer);
                    if (this.state.masked) {
                        lengthCode = (byte)(lengthCode ^ 0x80);
                    }
                    this.state.lengthCode = lengthCode;
                    ++this.state.state;
                }
                case 1: {
                    if (this.state.lengthCode <= 125) {
                        this.state.length = this.state.lengthCode;
                    } else {
                        int lengthBytes;
                        if (this.state.controlFrame) {
                            throw new ProtocolError("Control frame payloads must be no greater than 125 bytes.");
                        }
                        int n = lengthBytes = this.state.lengthCode == 126 ? 2 : 8;
                        if (buffer.remaining() < lengthBytes) {
                            return null;
                        }
                        this.state.masker.setBuffer(buffer);
                        this.state.length = this.decodeLength(this.state.masker.unmask(lengthBytes));
                    }
                    ++this.state.state;
                }
                case 2: {
                    if (this.state.masked) {
                        if (buffer.remaining() < 4) {
                            return null;
                        }
                        this.state.masker.setBuffer(buffer);
                        this.state.masker.readMask();
                    }
                    ++this.state.state;
                }
                case 3: {
                    if ((long)buffer.remaining() < this.state.length) {
                        return null;
                    }
                    this.state.masker.setBuffer(buffer);
                    byte[] data = this.state.masker.unmask((int)this.state.length);
                    if ((long)data.length != this.state.length) {
                        throw new ProtocolError(String.format("Data read (%s) is not the expected size (%s)", data.length, this.state.length));
                    }
                    dataFrame = this.state.frameType.create(this.state.finalFragment, data);
                    if (!this.state.controlFrame && (this.isTextFrame(this.state.opcode) || this.inFragmentedType == 1)) {
                        this.utf8Decode(this.state.finalFragment, data, dataFrame);
                    }
                    if (!this.state.controlFrame && this.state.finalFragment) {
                        this.inFragmentedType = 0;
                        this.processingFragment = false;
                    }
                    this.state.recycle();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected state: " + this.state.state);
                }
            }
        }
        catch (Exception e) {
            this.state.recycle();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return dataFrame;
    }

    @Override
    protected boolean isControlFrame(byte opcode) {
        return (opcode & 8) == 8;
    }

    private boolean isBitSet(byte b, int bit) {
        return (b >> bit & 1) != 0;
    }

    private boolean isContinuationFrame(byte opcode) {
        return opcode == 0;
    }

    private boolean isTextFrame(byte opcode) {
        return opcode == 1;
    }

    private byte getOpcode(FrameType type) {
        if (type instanceof TextFrameType) {
            return 1;
        }
        if (type instanceof BinaryFrameType) {
            return 2;
        }
        if (type instanceof ClosingFrameType) {
            return 8;
        }
        if (type instanceof PingFrameType) {
            return 9;
        }
        if (type instanceof PongFrameType) {
            return 10;
        }
        throw new ProtocolError("Unknown frame type: " + type.getClass().getName());
    }

    private FrameType valueOf(byte fragmentType, byte value) {
        int opcode = value & 0xF;
        switch (opcode) {
            case 0: {
                return new ContinuationFrameType((fragmentType & 1) == 1);
            }
            case 1: {
                return new TextFrameType();
            }
            case 2: {
                return new BinaryFrameType();
            }
            case 8: {
                return new ClosingFrameType();
            }
            case 9: {
                return new PingFrameType();
            }
            case 10: {
                return new PongFrameType();
            }
        }
        throw new ProtocolError(String.format("Unknown frame type: %s, %s", Integer.toHexString(opcode & 0xFF).toUpperCase(Locale.US), this.connection));
    }

    private static class ParsingState {
        int state = 0;
        byte opcode = (byte)-1;
        long length = -1L;
        FrameType frameType;
        boolean masked;
        Masker masker;
        boolean finalFragment;
        boolean controlFrame;
        private byte lengthCode = (byte)-1;

        private ParsingState() {
        }

        void recycle() {
            this.state = 0;
            this.opcode = (byte)-1;
            this.length = -1L;
            this.lengthCode = (byte)-1;
            this.masked = false;
            this.masker = null;
            this.finalFragment = false;
            this.controlFrame = false;
            this.frameType = null;
        }
    }
}

