/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.connectors.config.PrincipalMap;
import org.glassfish.connectors.config.WorkSecurityMap;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-connector-work-security-maps")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.connector.work.security.maps")
@RestEndpoints(value={@RestEndpoint(configBean=SecurityService.class, opType=RestEndpoint.OpType.GET, path="list-connector-work-security-maps", description="List Connector Work Security Maps")})
public class ListConnectorWorkSecurityMaps
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListConnectorWorkSecurityMaps.class);
    @Param(name="securitymap", optional=true)
    String securityMap;
    @Param(name="resource-adapter-name", primary=true)
    String raName;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        ActionReport.MessagePart mp = report.getTopMessagePart();
        try {
            boolean foundWSM = false;
            Collection workSecurityMaps = this.domain.getResources().getResources(WorkSecurityMap.class);
            for (WorkSecurityMap wsm : workSecurityMaps) {
                if (!wsm.getResourceAdapterName().equals(this.raName)) continue;
                if (this.securityMap == null) {
                    this.listWorkSecurityMap(wsm, mp);
                    foundWSM = true;
                    continue;
                }
                if (!wsm.getName().equals(this.securityMap)) continue;
                this.listWorkSecurityMap(wsm, mp);
                foundWSM = true;
                break;
            }
            if (!foundWSM) {
                report.setMessage(localStrings.getLocalString("list.connector.work.security.maps.workSecurityMapNotFound", "Nothing to list. Either the resource adapter {0} does not exist or theresource adapter {0} is not associated with any work security map.", new Object[]{this.raName}));
            }
        }
        catch (Exception e) {
            Logger.getLogger(ListConnectorWorkSecurityMaps.class.getName()).log(Level.SEVERE, "list-connector-work-security-maps failed", e);
            report.setMessage(localStrings.getLocalString("list.connector.work.security.maps.fail", "Unable to list connector work security map {0} for resource adapter {1}", new Object[]{this.securityMap, this.raName}) + " " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void listWorkSecurityMap(WorkSecurityMap wsm, ActionReport.MessagePart mp) {
        ActionReport.MessagePart part;
        List principalList = wsm.getPrincipalMap();
        List groupList = wsm.getGroupMap();
        for (PrincipalMap map : principalList) {
            part = mp.addChild();
            part.setMessage(localStrings.getLocalString("list.connector.work.security.maps.eisPrincipalAndMappedPrincipal", "{0}: EIS principal={1}, mapped principal={2}", new Object[]{wsm.getName(), map.getEisPrincipal(), map.getMappedPrincipal()}));
        }
        for (PrincipalMap map : groupList) {
            part = mp.addChild();
            part.setMessage(localStrings.getLocalString("list.connector.work.security.maps.eisGroupAndMappedGroup", "{0}: EIS group={1}, mapped group={2}", new Object[]{wsm.getName(), map.getEisGroup(), map.getMappedGroup()}));
        }
    }
}

